/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.util;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.stringparsers.ForNameStringParser;
import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.bits.TransformationStrategies;
import it.unimi.dsi.bits.TransformationStrategy;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectSortedSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import it.unimi.dsi.io.FastBufferedReader;
import it.unimi.dsi.io.LineIterator;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.sux4j.mph.Hashes;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZFastTrie<T>
extends AbstractObjectSortedSet<T>
implements Serializable {
    public static final long serialVersionUID = 2L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ZFastTrie.class);
    private static final boolean ASSERTS = false;
    private static final boolean DDDEBUG = false;
    private static final boolean DDEBUG = false;
    private static final boolean DEBUG = false;
    private static final boolean SHORT_SIGNATURES = false;
    private static final long SIGNATURE_MASK = Long.MAX_VALUE;
    private static final long DUPLICATE_MASK = Long.MIN_VALUE;
    private int size;
    private transient Node<T> root;
    private final TransformationStrategy<? super T> transform;
    public transient Handle2NodeMap<T> handle2Node;
    private transient Leaf<T> head;
    private transient Leaf<T> tail;

    private static final long shortSignature(long s) {
        return Math.max(1L, s & 3L);
    }

    public ZFastTrie(TransformationStrategy<? super T> transform) {
        this.transform = transform;
        this.handle2Node = new Handle2NodeMap<T>(transform);
        this.initHeadTail();
    }

    private void initHeadTail() {
        this.head = new Leaf();
        this.tail = new Leaf();
        this.head.next = this.tail;
        this.tail.prev = this.head;
    }

    public ZFastTrie(Iterator<? extends T> elements, TransformationStrategy<? super T> transform) {
        this(transform);
        while (elements.hasNext()) {
            this.add(elements.next());
        }
    }

    public ZFastTrie(Iterable<? extends T> elements, TransformationStrategy<? super T> transform) {
        this(elements.iterator(), transform);
    }

    public int size() {
        return this.size > Integer.MAX_VALUE ? -1 : this.size;
    }

    public static final long twoFattest(long a, long b) {
        return -1L << Fast.mostSignificantBit((long)(a ^ b)) & b;
    }

    private static <U> void removeLeaf(Leaf<U> node) {
        node.next.prev = node.prev;
        node.prev.next = node.next;
    }

    private static <U> void addAfter(Leaf<U> pred, Leaf<U> node) {
        node.next = pred.next;
        node.prev = pred;
        pred.next.prev = node;
        pred.next = node;
    }

    private static <U> void addBefore(Leaf<U> succ, Leaf<U> node) {
        node.prev = succ.prev;
        node.next = succ;
        succ.prev.next = node;
        succ.prev = node;
    }

    private void assertTrie() {
        assert (this.root == null || this.root.parentExtentLength == -1L) : this.root.parentExtentLength + " != " + -1;
        LongArrayBitVector root = null;
        ObjectOpenHashSet nodes = new ObjectOpenHashSet();
        ObjectOpenHashSet leaves = new ObjectOpenHashSet();
        ObjectOpenHashSet references = new ObjectOpenHashSet();
        assert (this.size == 0 && this.handle2Node.size() == 0 || this.size == this.handle2Node.size() + 1);
        for (LongArrayBitVector v : this.handle2Node.keySet()) {
            long vHandleLength = this.handle2Node.get((BitVector)v, true).handleLength();
            if (root == null || this.handle2Node.get((BitVector)root, true).handleLength() > vHandleLength) {
                root = v;
            }
            InternalNode<T> node = this.handle2Node.get((BitVector)v, true);
            nodes.add(node);
            assert (node.reference.reference == node) : node + " -> " + node.reference + " -> " + node.reference.reference;
        }
        assert (nodes.size() == this.handle2Node.size()) : nodes.size() + " != " + this.handle2Node.size();
        assert (this.size < 2 || this.root == this.handle2Node.get((BitVector)root, true));
        if (this.size > 1) {
            Leaf toRight = this.head.next;
            Leaf toLeft = this.tail.prev;
            if (this.head.next.key instanceof CharSequence) {
                for (int i = 1; i < this.size; ++i) {
                    assert (new MutableString((CharSequence)toRight.key).compareTo((CharSequence)toRight.next.key) < 0) : toRight.key + " >= " + toRight.next.key + " " + toRight + " " + toRight.next;
                    assert (new MutableString((CharSequence)toLeft.key).compareTo((CharSequence)toLeft.prev.key) > 0) : toLeft.key + " >= " + toLeft.prev.key + " " + toLeft + " " + toLeft.prev;
                    toRight = toRight.next;
                    toLeft = toLeft.prev;
                }
            }
            int numNodes = this.visit(this.handle2Node.get((BitVector)root, true), null, -1L, 0, nodes, leaves, references);
            assert (numNodes == 2 * this.size - 1) : numNodes + " != " + (2 * this.size - 1);
            assert (leaves.size() == this.size);
            int c = 0;
            for (Leaf leaf : leaves) {
                if (!references.contains(leaf.key)) continue;
                ++c;
            }
            assert (c == this.size - 1) : c + " != " + (this.size - 1);
        } else if (this.size == 1) {
            assert (this.head.next == this.root);
            assert (this.tail.prev == this.root);
        }
        assert (nodes.isEmpty());
    }

    private int visit(Node<T> n, Node<T> parent, long parentExtentLength, int depth, ObjectOpenHashSet<Node<T>> nodes, ObjectOpenHashSet<Leaf<T>> leaves, ObjectOpenHashSet<T> references) {
        if (n == null) {
            return 0;
        }
        assert (parent == null || parent.extent(this.transform).equals(n.extent(this.transform).subVector(0L, ((InternalNode)parent).extentLength)));
        assert (n == this.root || parentExtentLength < n.extentLength(this.transform));
        assert (n != this.root || parentExtentLength <= n.extentLength(this.transform));
        assert (n.parentExtentLength == parentExtentLength) : n.parentExtentLength + " != " + parentExtentLength + " " + n;
        if (n.isInternal()) {
            assert (references.add(((InternalNode)n).reference.key));
            assert (nodes.remove(n)) : n;
            assert (this.handle2Node.keySet().contains((Object)n.handle(this.transform))) : n;
            long jumpLength = ((InternalNode)n).jumpLength();
            Node jumpLeft = ((InternalNode)n).left;
            while (jumpLeft.isInternal() && jumpLength > ((InternalNode)jumpLeft).extentLength) {
                jumpLeft = ((InternalNode)jumpLeft).left;
            }
            assert (jumpLeft == ((InternalNode)n).jumpLeft) : jumpLeft + " != " + ((InternalNode)n).jumpLeft + " (node: " + n + ")";
            Node jumpRight = ((InternalNode)n).right;
            while (jumpRight.isInternal() && jumpLength > ((InternalNode)jumpRight).extentLength) {
                jumpRight = ((InternalNode)jumpRight).right;
            }
            assert (jumpRight == ((InternalNode)n).jumpRight) : jumpRight + " != " + ((InternalNode)n).jumpRight + " (node: " + n + ")";
            return 1 + this.visit(((InternalNode)n).left, n, ((InternalNode)n).extentLength, depth + 1, nodes, leaves, references) + this.visit(((InternalNode)n).right, n, n.extentLength(this.transform), depth + 1, nodes, leaves, references);
        }
        assert (leaves.add((Object)((Leaf)n)));
        assert (n.extentLength(this.transform) == n.key(this.transform).length());
        return 1;
    }

    private static <U> void setJumps(InternalNode<U> node) {
        long jumpLength = node.jumpLength();
        Node jump = node.left;
        while (jump.isInternal() && jumpLength > ((InternalNode)jump).extentLength) {
            jump = ((InternalNode)jump).jumpLeft;
        }
        node.jumpLeft = jump;
        jump = node.right;
        while (jump.isInternal() && jumpLength > ((InternalNode)jump).extentLength) {
            jump = ((InternalNode)jump).jumpRight;
        }
        node.jumpRight = jump;
    }

    private static <U> void fixRightJumpsAfterInsertion(InternalNode<U> internal, Node<U> exitNode, boolean rightChild, Leaf<U> leaf, ObjectArrayList<InternalNode<U>> stack) {
        long lcp = leaf.parentExtentLength;
        InternalNode toBeFixed = null;
        long jumpLength = -1L;
        if (!rightChild) {
            while (!stack.isEmpty()) {
                toBeFixed = (InternalNode)stack.pop();
                jumpLength = toBeFixed.jumpLength();
                if (toBeFixed.jumpLeft == exitNode) {
                    if (jumpLength > lcp) continue;
                    toBeFixed.jumpLeft = internal;
                    continue;
                }
                break;
            }
        } else {
            while (!stack.isEmpty()) {
                toBeFixed = (InternalNode)stack.top();
                jumpLength = toBeFixed.jumpLength();
                if (toBeFixed.jumpRight != exitNode || jumpLength > lcp) break;
                toBeFixed.jumpRight = internal;
                stack.pop();
            }
            while (!stack.isEmpty()) {
                toBeFixed = (InternalNode)stack.pop();
                jumpLength = toBeFixed.jumpLength();
                while (exitNode.isInternal() && toBeFixed.jumpRight != exitNode) {
                    exitNode = ((InternalNode)exitNode).jumpRight;
                }
                if (toBeFixed.jumpRight != exitNode) {
                    return;
                }
                toBeFixed.jumpRight = leaf;
            }
        }
    }

    private static <U> void fixLeftJumpsAfterInsertion(InternalNode<U> internal, Node<U> exitNode, boolean rightChild, Leaf<U> leaf, ObjectArrayList<InternalNode<U>> stack) {
        long lcp = leaf.parentExtentLength;
        InternalNode toBeFixed = null;
        long jumpLength = -1L;
        if (rightChild) {
            while (!stack.isEmpty()) {
                toBeFixed = (InternalNode)stack.pop();
                jumpLength = toBeFixed.jumpLength();
                if (toBeFixed.jumpRight == exitNode) {
                    if (jumpLength > lcp) continue;
                    toBeFixed.jumpRight = internal;
                    continue;
                }
                break;
            }
        } else {
            while (!stack.isEmpty()) {
                toBeFixed = (InternalNode)stack.top();
                jumpLength = toBeFixed.jumpLength();
                if (toBeFixed.jumpLeft != exitNode || jumpLength > lcp) break;
                toBeFixed.jumpLeft = internal;
                stack.pop();
            }
            while (!stack.isEmpty()) {
                toBeFixed = (InternalNode)stack.pop();
                jumpLength = toBeFixed.jumpLength();
                while (exitNode.isInternal() && toBeFixed.jumpLeft != exitNode) {
                    exitNode = ((InternalNode)exitNode).jumpLeft;
                }
                if (toBeFixed.jumpLeft != exitNode) {
                    return;
                }
                toBeFixed.jumpLeft = leaf;
            }
        }
    }

    private static <U> void fixRightJumpsAfterDeletion(InternalNode<U> parentExitNode, Leaf<U> exitNode, Node<U> otherNode, boolean rightChild, ObjectArrayList<InternalNode<U>> stack) {
        InternalNode toBeFixed = null;
        long jumpLength = -1L;
        if (!rightChild) {
            while (!stack.isEmpty()) {
                toBeFixed = (InternalNode)stack.pop();
                jumpLength = toBeFixed.jumpLength();
                if (toBeFixed.jumpLeft == parentExitNode) {
                    toBeFixed.jumpLeft = otherNode;
                    continue;
                }
                break;
            }
        } else {
            while (!stack.isEmpty()) {
                toBeFixed = (InternalNode)stack.top();
                jumpLength = toBeFixed.jumpLength();
                if (toBeFixed.jumpRight != parentExitNode) break;
                toBeFixed.jumpRight = otherNode;
                stack.pop();
            }
            while (!stack.isEmpty()) {
                toBeFixed = (InternalNode)stack.pop();
                if (toBeFixed.jumpRight == exitNode) {
                    jumpLength = toBeFixed.jumpLength();
                    while (!otherNode.intercepts(jumpLength)) {
                        otherNode = ((InternalNode)otherNode).jumpRight;
                    }
                    toBeFixed.jumpRight = otherNode;
                    continue;
                }
                break;
            }
        }
    }

    private static <U> void fixLeftJumpsAfterDeletion(InternalNode<U> parentExitNode, Leaf<U> exitNode, Node<U> otherNode, boolean rightChild, ObjectArrayList<InternalNode<U>> stack) {
        InternalNode toBeFixed = null;
        long jumpLength = -1L;
        if (rightChild) {
            while (!stack.isEmpty()) {
                toBeFixed = (InternalNode)stack.pop();
                jumpLength = toBeFixed.jumpLength();
                if (toBeFixed.jumpRight == parentExitNode) {
                    toBeFixed.jumpRight = otherNode;
                    continue;
                }
                break;
            }
        } else {
            while (!stack.isEmpty()) {
                toBeFixed = (InternalNode)stack.top();
                jumpLength = toBeFixed.jumpLength();
                if (toBeFixed.jumpLeft != parentExitNode) break;
                toBeFixed.jumpLeft = otherNode;
                stack.pop();
            }
            while (!stack.isEmpty()) {
                toBeFixed = (InternalNode)stack.pop();
                if (toBeFixed.jumpLeft == exitNode) {
                    jumpLength = toBeFixed.jumpLength();
                    while (!otherNode.intercepts(jumpLength)) {
                        otherNode = ((InternalNode)otherNode).jumpLeft;
                    }
                    toBeFixed.jumpLeft = otherNode;
                    continue;
                }
                break;
            }
        }
    }

    public boolean add(T k) {
        boolean rightChild;
        LongArrayBitVector v = LongArrayBitVector.copy((BitVector)this.transform.toBitVector(k));
        if (this.size == 0) {
            Leaf<T> leaf = new Leaf<T>();
            leaf.key = k;
            leaf.parentExtentLength = -1L;
            leaf.reference = null;
            ZFastTrie.addAfter(this.head, leaf);
            this.root = leaf;
            ++this.size;
            return true;
        }
        ObjectArrayList stack = new ObjectArrayList(64);
        long[] state = Hashes.preprocessMurmur((BitVector)v, 42L);
        ParexData<T> parexData = this.getParentExitNode(v, state, stack);
        InternalNode parentExitNode = parexData.parexNode;
        Node<Object> exitNode = parexData.exitNode;
        long lcp = parexData.lcp;
        boolean bl = rightChild = parentExitNode != null && parentExitNode.right == exitNode;
        if (exitNode.isLeaf() && this.transform.length(((Leaf)exitNode).key) == parexData.lcp) {
            return false;
        }
        boolean exitDirection = v.getBoolean(lcp);
        long exitNodeHandleLength = exitNode.handleLength(this.transform);
        boolean cutLow = lcp >= exitNodeHandleLength;
        Leaf leaf = new Leaf();
        InternalNode<T> internal = new InternalNode<T>();
        boolean exitNodeIsInternal = exitNode.isInternal();
        leaf.key = k;
        leaf.parentExtentLength = lcp;
        leaf.reference = internal;
        internal.reference = leaf;
        internal.parentExtentLength = exitNode.parentExtentLength;
        internal.extentLength = lcp;
        if (exitDirection) {
            internal.right = leaf;
            internal.jumpRight = internal.right;
            internal.left = exitNode;
            internal.jumpLeft = cutLow && exitNodeIsInternal ? ((InternalNode)exitNode).jumpLeft : exitNode;
        } else {
            internal.left = leaf;
            internal.jumpLeft = internal.left;
            internal.right = exitNode;
            Node<Object> node = internal.jumpRight = cutLow && exitNodeIsInternal ? ((InternalNode)exitNode).jumpRight : exitNode;
        }
        if (exitNode == this.root) {
            this.root = internal;
        } else if (rightChild) {
            parentExitNode.right = internal;
        } else {
            parentExitNode.left = internal;
        }
        if (exitDirection) {
            ZFastTrie.fixRightJumpsAfterInsertion(internal, exitNode, rightChild, leaf, stack);
        } else {
            ZFastTrie.fixLeftJumpsAfterInsertion(internal, exitNode, rightChild, leaf, stack);
        }
        if (cutLow && exitNodeIsInternal) {
            this.handle2Node.replaceExisting((InternalNode)exitNode, internal, Hashes.murmur((BitVector)v, exitNodeHandleLength, state) & Long.MAX_VALUE);
            exitNode.parentExtentLength = lcp;
            this.handle2Node.addNew((InternalNode)exitNode, Hashes.murmur(exitNode.key(this.transform), exitNode.handleLength(this.transform), state, lcp) & Long.MAX_VALUE);
            ZFastTrie.setJumps((InternalNode)exitNode);
        } else {
            exitNode.parentExtentLength = lcp;
            this.handle2Node.addNew(internal, Hashes.murmur((BitVector)v, internal.handleLength(), state) & Long.MAX_VALUE);
        }
        ++this.size;
        if (exitDirection) {
            ZFastTrie.addAfter(exitNode.rightLeaf(), leaf);
        } else {
            ZFastTrie.addBefore(exitNode.leftLeaf(), leaf);
        }
        return true;
    }

    public boolean remove(Object k) {
        InternalNode refersToExitNode;
        long otherNodeHandleLength;
        long parentExitNodehandleLength;
        long t;
        boolean cutLow;
        boolean rightLeaf;
        LongArrayBitVector v = LongArrayBitVector.copy((BitVector)this.transform.toBitVector(k));
        if (this.size == 0) {
            return false;
        }
        if (this.size == 1) {
            if (!((Leaf)this.root).key.equals(k)) {
                return false;
            }
            ZFastTrie.removeLeaf((Leaf)this.root);
            this.root = null;
            this.size = 0;
            return true;
        }
        ObjectArrayList stack = new ObjectArrayList(64);
        boolean rightChild = false;
        long[] state = Hashes.preprocessMurmur((BitVector)v, 42L);
        ParexData<T> parexData = this.getParentExitNode(v, state, stack);
        InternalNode parentExitNode = parexData.parexNode;
        Node exitNode = parexData.exitNode;
        long lcp = parexData.lcp;
        boolean bl = rightLeaf = parentExitNode != null && parentExitNode.right == exitNode;
        if (!exitNode.isLeaf() || this.transform.length(((Leaf)exitNode).key) != parexData.lcp) {
            return false;
        }
        Node<Object> otherNode = rightLeaf ? parentExitNode.left : parentExitNode.right;
        boolean otherNodeIsInternal = otherNode.isInternal();
        if (parentExitNode != null && parentExitNode != this.root) {
            InternalNode<T> grandParentExitNode = this.getGrandParentExitNode(v, state, stack);
            rightChild = grandParentExitNode.right == parentExitNode;
            if (rightChild) {
                grandParentExitNode.right = otherNode;
            } else {
                grandParentExitNode.left = otherNode;
            }
        }
        boolean bl2 = cutLow = ((t = (parentExitNodehandleLength = parentExitNode.handleLength()) | (otherNodeHandleLength = otherNode.handleLength(this.transform))) & -t & otherNodeHandleLength) != 0L;
        if (parentExitNode == this.root) {
            this.root = otherNode;
        }
        if ((refersToExitNode = ((Leaf)exitNode).reference) == null) {
            parentExitNode.reference.reference = null;
        } else {
            refersToExitNode.reference = parentExitNode.reference;
            refersToExitNode.reference.reference = refersToExitNode;
        }
        ZFastTrie.removeLeaf((Leaf)exitNode);
        if (rightLeaf) {
            ZFastTrie.fixRightJumpsAfterDeletion(parentExitNode, (Leaf)exitNode, otherNode, rightChild, stack);
        } else {
            ZFastTrie.fixLeftJumpsAfterDeletion(parentExitNode, (Leaf)exitNode, otherNode, rightChild, stack);
        }
        if (cutLow && otherNodeIsInternal) {
            this.handle2Node.removeExisting((InternalNode)otherNode, Hashes.murmur(otherNode.key(this.transform), otherNodeHandleLength, state, parentExitNode.extentLength) & Long.MAX_VALUE);
            otherNode.parentExtentLength = parentExitNode.parentExtentLength;
            this.handle2Node.replaceExisting(parentExitNode, (InternalNode)otherNode, Hashes.murmur((BitVector)v, parentExitNodehandleLength, state) & Long.MAX_VALUE);
            ZFastTrie.setJumps((InternalNode)otherNode);
        } else {
            otherNode.parentExtentLength = parentExitNode.parentExtentLength;
            this.handle2Node.removeExisting(parentExitNode, Hashes.murmur((BitVector)v, parentExitNodehandleLength, state) & Long.MAX_VALUE);
        }
        --this.size;
        return true;
    }

    private ExitData<T> getExitNode(LongArrayBitVector v, long[] state) {
        long lcpLength;
        if (this.size == 0) {
            throw new IllegalStateException();
        }
        if (this.size == 1) {
            return new ExitData<T>(this.root, v.longestCommonPrefixLength(this.root.extent(this.transform)));
        }
        long length = v.length();
        InternalNode<T> parexOrExitNode = this.fatBinarySearch(v, state, null, false, -1L, length);
        Node<Object> candidateExitNode = parexOrExitNode.extentLength < length && v.getBoolean(parexOrExitNode.extentLength) ? parexOrExitNode.right : parexOrExitNode.left;
        if (candidateExitNode.isExitNodeOf(length, lcpLength = v.longestCommonPrefixLength(candidateExitNode.extent(this.transform)), this.transform)) {
            return new ExitData(candidateExitNode, lcpLength);
        }
        if (parexOrExitNode.isExitNodeOf(length, lcpLength = Math.min(parexOrExitNode.extentLength, lcpLength), this.transform)) {
            return new ExitData<T>(parexOrExitNode, lcpLength);
        }
        parexOrExitNode = this.fatBinarySearch(v, state, null, true, -1L, length);
        candidateExitNode = parexOrExitNode.extent(this.transform).isProperPrefix((BitVector)v) ? (parexOrExitNode.extentLength < length && v.getBoolean(parexOrExitNode.extentLength) ? parexOrExitNode.right : parexOrExitNode.left) : parexOrExitNode;
        return new ExitData(candidateExitNode, v.longestCommonPrefixLength(candidateExitNode.extent(this.transform)));
    }

    public ParexData<T> getParentExitNode(LongArrayBitVector v, long[] state, ObjectArrayList<InternalNode<T>> stack) {
        long lcpLength;
        if (this.size == 0) {
            throw new IllegalStateException();
        }
        if (this.size == 1) {
            return new ParexData<T>(null, this.root, v.longestCommonPrefixLength(this.root.extent(this.transform)));
        }
        long length = v.length();
        InternalNode<T> parexOrExitNode = this.fatBinarySearch(v, state, stack, false, -1L, length);
        Node<Object> candidateExitNode = parexOrExitNode.extentLength < length && v.getBoolean(parexOrExitNode.extentLength) ? parexOrExitNode.right : parexOrExitNode.left;
        if (candidateExitNode.isExitNodeOf(length, lcpLength = v.longestCommonPrefixLength(candidateExitNode.extent(this.transform)), this.transform)) {
            return new ParexData<T>(parexOrExitNode, candidateExitNode, lcpLength);
        }
        if (parexOrExitNode.isExitNodeOf(length, lcpLength = Math.min(parexOrExitNode.extentLength, lcpLength), this.transform)) {
            stack.pop();
            if (parexOrExitNode == this.root) {
                return new ParexData<T>(null, parexOrExitNode, lcpLength);
            }
            long startingPoint = ((InternalNode)stack.top()).extentLength;
            if (startingPoint == parexOrExitNode.parentExtentLength) {
                return new ParexData<T>((InternalNode)stack.top(), parexOrExitNode, lcpLength);
            }
            int stackSize = stack.size();
            InternalNode<T> parexNode = this.fatBinarySearch(v, state, stack, false, startingPoint, parexOrExitNode.parentExtentLength);
            if (parexNode.left == parexOrExitNode || parexNode.right == parexOrExitNode) {
                return new ParexData<T>(parexNode, parexOrExitNode, lcpLength);
            }
            stack.size(stackSize);
            return new ParexData<T>(this.fatBinarySearch(v, state, stack, true, startingPoint, parexOrExitNode.parentExtentLength), parexOrExitNode, lcpLength);
        }
        stack.clear();
        parexOrExitNode = this.fatBinarySearch(v, state, stack, true, -1L, length);
        candidateExitNode = parexOrExitNode.extentLength < length && v.getBoolean(parexOrExitNode.extentLength) ? parexOrExitNode.right : parexOrExitNode.left;
        lcpLength = v.longestCommonPrefixLength(candidateExitNode.extent(this.transform));
        if (candidateExitNode.isExitNodeOf(length, lcpLength, this.transform)) {
            return new ParexData<T>(parexOrExitNode, candidateExitNode, lcpLength);
        }
        stack.pop();
        if (parexOrExitNode == this.root) {
            return new ParexData<T>(null, parexOrExitNode, lcpLength);
        }
        long startingPoint = ((InternalNode)stack.top()).extentLength;
        if (startingPoint == parexOrExitNode.parentExtentLength) {
            return new ParexData<T>((InternalNode)stack.top(), parexOrExitNode, lcpLength);
        }
        return new ParexData<T>(this.fatBinarySearch(v, state, stack, true, startingPoint, parexOrExitNode.parentExtentLength), parexOrExitNode, lcpLength);
    }

    private void assertParent(LongArrayBitVector v, ParexData<T> parexData, ObjectArrayList<InternalNode<T>> stack) {
        assert (parexData.parexNode == null == stack.isEmpty()) : (parexData.parexNode == null) + " != " + stack.isEmpty();
        assert (parexData.parexNode != null || parexData.exitNode == this.root);
        assert (parexData.parexNode == null || parexData.parexNode.left == parexData.exitNode || parexData.parexNode.right == parexData.exitNode);
        for (InternalNode node : stack) {
            assert (v.equals(node.extent(this.transform), Math.max(0L, node.parentExtentLength), node.extentLength));
        }
    }

    public InternalNode<T> getGrandParentExitNode(LongArrayBitVector v, long[] state, ObjectArrayList<InternalNode<T>> stack) {
        InternalNode parentExitNode = (InternalNode)stack.pop();
        if (parentExitNode == this.root) {
            return null;
        }
        long startingPoint = ((InternalNode)stack.top()).extentLength;
        if (startingPoint == parentExitNode.parentExtentLength) {
            return (InternalNode)stack.top();
        }
        int stackSize = stack.size();
        InternalNode<T> grandParentExitNode = this.fatBinarySearch(v, state, stack, false, startingPoint, parentExitNode.parentExtentLength);
        if (grandParentExitNode.left == parentExitNode || grandParentExitNode.right == parentExitNode) {
            return grandParentExitNode;
        }
        stack.size(stackSize);
        return this.fatBinarySearch(v, state, stack, true, startingPoint, parentExitNode.parentExtentLength);
    }

    private InternalNode<T> fatBinarySearch(LongArrayBitVector v, long[] state, ObjectArrayList<InternalNode<T>> stack, boolean exact, long a, long b) {
        InternalNode<U>[] node = this.handle2Node.node;
        InternalNode top = stack == null || stack.isEmpty() ? null : (InternalNode)stack.top();
        long checkMask = -1L << Fast.ceilLog2((long)(b - a));
        while (b - a > 0L) {
            long f = b & checkMask;
            if ((a & checkMask) != f) {
                long g;
                int pos = this.handle2Node.getPos((BitVector)v, f, Hashes.murmur((BitVector)v, f, state) & Long.MAX_VALUE, exact);
                if (pos == -1 || (g = node[pos].extentLength) < f) {
                    b = f - 1L;
                } else {
                    top = node[pos];
                    if (stack != null) {
                        stack.push(top);
                    }
                    a = g;
                }
            }
            checkMask >>= 1;
        }
        return top;
    }

    public boolean contains(Object o) {
        if (this.size == 0) {
            return false;
        }
        LongArrayBitVector v = LongArrayBitVector.copy((BitVector)this.transform.toBitVector(o));
        long[] state = Hashes.preprocessMurmur((BitVector)v, 42L);
        ExitData<T> exitData = this.getExitNode(v, state);
        return exitData.exitNode.isLeaf() && exitData.lcp == this.transform.length(((Leaf)exitData.exitNode).key);
    }

    private Leaf<T> predNode(T k) {
        LongArrayBitVector v = LongArrayBitVector.copy((BitVector)this.transform.toBitVector(k));
        long[] state = Hashes.preprocessMurmur((BitVector)v, 42L);
        Node<? super T> exitNode = this.getExitNode((LongArrayBitVector)v, (long[])state).exitNode;
        if (v.compareTo(exitNode.extent(this.transform)) <= 0) {
            return exitNode.rightLeaf();
        }
        return exitNode.leftLeaf().prev;
    }

    public T pred(Object o) {
        if (this.size == 0) {
            return null;
        }
        return (T)this.predNode(o).key;
    }

    private Leaf<T> succNode(T k) {
        LongArrayBitVector v = LongArrayBitVector.copy((BitVector)this.transform.toBitVector(k));
        long[] state = Hashes.preprocessMurmur((BitVector)v, 42L);
        Node<? super T> exitNode = this.getExitNode((LongArrayBitVector)v, (long[])state).exitNode;
        if (v.compareTo(exitNode.extent(this.transform)) <= 0) {
            return exitNode.leftLeaf();
        }
        return exitNode.rightLeaf().next;
    }

    public T succ(Object o) {
        if (this.size == 0) {
            return null;
        }
        return (T)this.succNode(o).key;
    }

    public ObjectBidirectionalIterator<T> iterator() {
        return this.iteratorFromLeaf(this.head.next);
    }

    public ObjectBidirectionalIterator<T> iterator(T from) {
        return this.size == 0 ? this.iteratorFromLeaf(this.tail) : this.iteratorFromLeaf(this.succNode(from));
    }

    private ObjectBidirectionalIterator<T> iteratorFromLeaf(final Leaf<T> from) {
        return new AbstractObjectBidirectionalIterator<T>(){
            private Leaf<T> curr;
            {
                this.curr = from;
            }

            public boolean hasNext() {
                return this.curr != ZFastTrie.this.tail;
            }

            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object result = this.curr.key;
                this.curr = this.curr.next;
                return result;
            }

            public boolean hasPrevious() {
                return this.curr.prev != ZFastTrie.this.head;
            }

            public T previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.curr = this.curr.prev;
                return this.curr.key;
            }
        };
    }

    public Comparator<? super T> comparator() {
        return null;
    }

    public T first() {
        return (T)this.head.next.key;
    }

    public T last() {
        return (T)this.tail.prev.key;
    }

    public ObjectSortedSet<T> headSet(T arg0) {
        throw new UnsupportedOperationException();
    }

    public ObjectSortedSet<T> subSet(T arg0, T arg1) {
        throw new UnsupportedOperationException();
    }

    public ObjectSortedSet<T> tailSet(T arg0) {
        throw new UnsupportedOperationException();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        if (this.size > 0) {
            ZFastTrie.writeNode(this.root, this.transform, s);
        }
    }

    private static <U> void writeNode(Node<U> node, TransformationStrategy<? super U> transform, ObjectOutputStream s) throws IOException {
        s.writeBoolean(node.isInternal());
        if (node.isInternal()) {
            InternalNode internalNode = (InternalNode)node;
            s.writeLong(internalNode.extentLength - internalNode.parentExtentLength);
            ZFastTrie.writeNode(internalNode.left, transform, s);
            ZFastTrie.writeNode(internalNode.right, transform, s);
        } else {
            s.writeObject(((Leaf)node).key);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.initHeadTail();
        this.handle2Node = new Handle2NodeMap<T>(this.size, this.transform);
        if (this.size > 0) {
            this.root = this.readNode(s, 0, -1L, this.handle2Node, new ObjectArrayList(), new ObjectArrayList(), new IntArrayList(), new IntArrayList(), new BooleanArrayList());
        }
    }

    private Node<T> readNode(ObjectInputStream s, int depth, long parentExtentLength, Handle2NodeMap<T> map, ObjectArrayList<Leaf<T>> leafStack, ObjectArrayList<InternalNode<T>> jumpStack, IntArrayList depthStack, IntArrayList segmentStack, BooleanArrayList dirStack) throws IOException, ClassNotFoundException {
        boolean isInternal = s.readBoolean();
        InternalNode internalNode = isInternal ? new InternalNode() : null;
        Node node = isInternal ? internalNode : new Leaf();
        node.parentExtentLength = parentExtentLength;
        if (isInternal) {
            internalNode.extentLength = parentExtentLength + s.readLong();
        }
        if (!dirStack.isEmpty()) {
            int maxDepthDelta = segmentStack.topInt();
            boolean dir = dirStack.topBoolean();
            do {
                InternalNode anc = (InternalNode)jumpStack.top();
                long jumpLength = anc.jumpLength();
                int d = depthStack.topInt();
                if (depth - d > maxDepthDelta || jumpLength <= parentExtentLength || isInternal && jumpLength > internalNode.extentLength) break;
                if (dir) {
                    anc.jumpRight = node;
                } else {
                    anc.jumpLeft = node;
                }
                jumpStack.pop();
                depthStack.popInt();
            } while (!jumpStack.isEmpty());
        }
        if (isInternal) {
            Leaf referenceLeaf;
            if (dirStack.isEmpty() || dirStack.topBoolean()) {
                segmentStack.push(1);
                dirStack.push(false);
            } else {
                segmentStack.push(segmentStack.popInt() + 1);
            }
            jumpStack.push(internalNode);
            depthStack.push(depth);
            internalNode.left = this.readNode(s, depth + 1, internalNode.extentLength, map, leafStack, jumpStack, depthStack, segmentStack, dirStack);
            int top = segmentStack.popInt();
            if (top != 1) {
                segmentStack.push(top - 1);
            } else {
                dirStack.popBoolean();
            }
            if (dirStack.isEmpty() || !dirStack.topBoolean()) {
                segmentStack.push(1);
                dirStack.push(true);
            } else {
                segmentStack.push(segmentStack.popInt() + 1);
            }
            jumpStack.push(internalNode);
            depthStack.push(depth);
            internalNode.right = this.readNode(s, depth + 1, internalNode.extentLength, map, leafStack, jumpStack, depthStack, segmentStack, dirStack);
            top = segmentStack.popInt();
            if (top != 1) {
                segmentStack.push(top - 1);
            } else {
                dirStack.popBoolean();
            }
            internalNode.reference = referenceLeaf = (Leaf)leafStack.pop();
            referenceLeaf.reference = internalNode;
            map.addNew(internalNode);
        } else {
            Leaf leaf = (Leaf)node;
            leaf.key = s.readObject();
            leafStack.push((Object)leaf);
            ZFastTrie.addBefore(this.tail, leaf);
        }
        return node;
    }

    public static void main(String[] arg) throws NoSuchMethodException, IOException, JSAPException {
        SimpleJSAP jsap = new SimpleJSAP(ZFastTrie.class.getName(), "Builds an PaCo trie-based monotone minimal perfect hash function reading a newline-separated list of strings.", new Parameter[]{new FlaggedOption("encoding", (StringParser)ForNameStringParser.getParser(Charset.class), "UTF-8", false, 'e', "encoding", "The string file encoding."), new Switch("loadAll", 'l', "load-all", "Load all strings into memory before building the trie."), new Switch("iso", 'i', "iso", "Use ISO-8859-1 coding internally (i.e., just use the lower eight bits of each character)."), new Switch("utf32", '\u0000', "utf-32", "Use UTF-32 internally (handles surrogate pairs)."), new Switch("bitVector", 'b', "bit-vector", "Build a trie of bit vectors, rather than a trie of strings."), new Switch("zipped", 'z', "zipped", "The string list is compressed in gzip format."), new UnflaggedOption("trie", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename for the serialised z-fast trie."), new UnflaggedOption("stringFile", (StringParser)JSAP.STRING_PARSER, "-", false, false, "The name of a file containing a newline-separated list of strings, or - for standard input.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        String functionName = jsapResult.getString("trie");
        String stringFile = jsapResult.getString("stringFile");
        Charset encoding = (Charset)jsapResult.getObject("encoding");
        boolean zipped = jsapResult.getBoolean("zipped");
        boolean iso = jsapResult.getBoolean("iso");
        boolean utf32 = jsapResult.getBoolean("utf32");
        boolean bitVector = jsapResult.getBoolean("bitVector");
        InputStream inputStream = "-".equals(stringFile) ? System.in : new FileInputStream(stringFile);
        Object lineIterator = new LineIterator(new FastBufferedReader((Reader)new InputStreamReader(zipped ? new GZIPInputStream(inputStream) : inputStream, encoding)));
        if (jsapResult.userSpecified("loadAll")) {
            lineIterator = lineIterator.allLines().iterator();
        }
        TransformationStrategy transformationStrategy = iso ? TransformationStrategies.prefixFreeIso() : (utf32 ? TransformationStrategies.prefixFreeUtf32() : TransformationStrategies.prefixFreeUtf16());
        ProgressLogger pl = new ProgressLogger();
        pl.displayLocalSpeed = true;
        pl.displayFreeMemory = true;
        pl.itemsName = "keys";
        pl.start((CharSequence)"Adding keys...");
        if (bitVector) {
            ZFastTrie<LongArrayBitVector> zFastTrie = new ZFastTrie<LongArrayBitVector>(TransformationStrategies.identity());
            while (lineIterator.hasNext()) {
                zFastTrie.add(LongArrayBitVector.copy((BitVector)transformationStrategy.toBitVector((Object)((MutableString)lineIterator.next()).copy())));
                pl.lightUpdate();
            }
            pl.done();
            BinIO.storeObject(zFastTrie, (CharSequence)functionName);
        } else {
            ZFastTrie<MutableString> zFastTrie = new ZFastTrie<MutableString>(transformationStrategy);
            while (lineIterator.hasNext()) {
                zFastTrie.add(((MutableString)lineIterator.next()).copy());
                pl.lightUpdate();
            }
            pl.done();
            BinIO.storeObject(zFastTrie, (CharSequence)functionName);
        }
        inputStream.close();
        LOGGER.info("Completed.");
    }

    protected static final class ParexData<U> {
        protected final long lcp;
        protected final InternalNode<U> parexNode;
        protected final Node<U> exitNode;

        protected ParexData(InternalNode<U> parexNode, Node<U> exitNode, long lcp) {
            this.lcp = lcp;
            this.parexNode = parexNode;
            this.exitNode = exitNode;
        }
    }

    protected static final class ExitData<U> {
        protected final long lcp;
        protected final Node<U> exitNode;

        protected ExitData(Node<U> exitNode, long lcp) {
            this.lcp = lcp;
            this.exitNode = exitNode;
        }
    }

    protected static final class Leaf<U>
    extends Node<U> {
        protected Leaf<U> prev;
        protected Leaf<U> next;
        protected U key;
        protected InternalNode<U> reference;

        protected Leaf() {
        }

        @Override
        public BitVector handle(TransformationStrategy<? super U> transform) {
            return this.reference.key(transform).subVector(0L, this.handleLength(transform));
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public boolean isInternal() {
            return false;
        }

        @Override
        public boolean intercepts(long h) {
            return h > this.parentExtentLength;
        }

        @Override
        public BitVector extent(TransformationStrategy<? super U> transform) {
            return this.key(transform);
        }

        @Override
        public long extentLength(TransformationStrategy<? super U> transform) {
            return transform.length(this.key);
        }

        @Override
        public BitVector key(TransformationStrategy<? super U> transform) {
            return transform.toBitVector(this.key);
        }
    }

    protected static final class InternalNode<U>
    extends Node<U> {
        protected long extentLength;
        protected Node<U> left;
        protected Node<U> right;
        protected Node<U> jumpLeft;
        protected Node<U> jumpRight;
        protected Leaf<U> reference;

        protected InternalNode() {
        }

        public long handleLength() {
            return ZFastTrie.twoFattest(this.parentExtentLength, this.extentLength);
        }

        public long jumpLength() {
            long handleLength = this.handleLength();
            if (handleLength == 0L) {
                return Long.MAX_VALUE;
            }
            return handleLength + (handleLength & -handleLength);
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public boolean isInternal() {
            return true;
        }

        @Override
        public boolean intercepts(long h) {
            return h > this.parentExtentLength && h <= this.extentLength;
        }

        @Override
        public BitVector extent(TransformationStrategy<? super U> transform) {
            return this.reference.key(transform).subVector(0L, this.extentLength);
        }

        @Override
        public long extentLength(TransformationStrategy<? super U> transform) {
            return this.extentLength;
        }

        @Override
        public BitVector key(TransformationStrategy<? super U> transform) {
            return this.reference.key(transform);
        }

        @Override
        public BitVector handle(TransformationStrategy<? super U> transform) {
            return this.reference.key(transform).subVector(0L, this.handleLength());
        }
    }

    protected static abstract class Node<U> {
        protected long parentExtentLength;

        protected Node() {
        }

        public boolean isLeaf() {
            return this instanceof Leaf;
        }

        public boolean isInternal() {
            return this instanceof InternalNode;
        }

        public long nameLength() {
            return this.parentExtentLength + 1L;
        }

        public long handleLength(TransformationStrategy<? super U> transform) {
            return ZFastTrie.twoFattest(this.parentExtentLength, this.extentLength(transform));
        }

        public abstract BitVector key(TransformationStrategy<? super U> var1);

        public abstract BitVector handle(TransformationStrategy<? super U> var1);

        public abstract long extentLength(TransformationStrategy<? super U> var1);

        public abstract BitVector extent(TransformationStrategy<? super U> var1);

        public abstract boolean intercepts(long var1);

        public long handleHash(TransformationStrategy<? super U> transform) {
            return Hashes.murmur(this.handle(transform), 42L) & Long.MAX_VALUE;
        }

        public boolean isExitNodeOf(LongArrayBitVector v, TransformationStrategy<? super U> transform) {
            return this.isExitNodeOf(v.length(), v.longestCommonPrefixLength(this.extent(transform)), transform);
        }

        public boolean isExitNodeOf(long length, long lcpLength, TransformationStrategy<? super U> transform) {
            return this.parentExtentLength < lcpLength && (lcpLength < this.extentLength(transform) || lcpLength == length);
        }

        public Leaf<U> leftLeaf() {
            Node node = this;
            while (node.isInternal()) {
                node = ((InternalNode)node).jumpLeft;
            }
            return (Leaf)node;
        }

        public Leaf<U> rightLeaf() {
            Node node = this;
            while (node.isInternal()) {
                node = ((InternalNode)node).jumpRight;
            }
            return (Leaf)node;
        }

        public String toString() {
            Object key = this.isInternal() ? ((InternalNode)this).reference.key : ((Leaf)this).key;
            TransformationStrategy transform = key instanceof CharSequence ? TransformationStrategies.prefixFreeIso() : TransformationStrategies.identity();
            long extentLength = this.extentLength(transform);
            return (this.isLeaf() ? "[" : "(") + Integer.toHexString(this.hashCode() & 0xFFFF) + (this.key(transform) == null ? "" : " " + (extentLength > 16L ? this.key(transform).subVector(0L, 8L) + "..." + this.key(transform).subVector(extentLength - 8L, extentLength) : this.key(transform).subVector(0L, extentLength))) + " (" + this.parentExtentLength + ".." + extentLength + "], " + (this.isInternal() ? ((InternalNode)this).handleLength() + "->" + ((InternalNode)this).jumpLength() : "") + (this.isLeaf() ? "]" : ")");
        }
    }

    protected static final class Handle2NodeMap<U> {
        private static final int INITIAL_LENGTH = 64;
        protected final TransformationStrategy<? super U> transform;
        protected InternalNode<U>[] node;
        protected long[] signature;
        protected int size;
        protected int length;
        protected int mask;

        protected void assertTable() {
            int c = 0;
            int i = this.signature.length;
            while (i-- != 0) {
                if (this.node[i] == null) continue;
                assert (this.get(this.node[i].handle(this.transform), true) == this.node[i]) : this.node[i] + " != " + this.get(this.node[i].handle(this.transform), true);
                ++c;
            }
            assert (c == this.size()) : c + " != " + this.size();
            if (this.size == 0) {
                return;
            }
            IntOpenHashSet overallHashes = new IntOpenHashSet();
            int start = 0;
            int first = -1;
            while (this.node[start] != null) {
                start = start + 1 & this.mask;
            }
            while (true) {
                if (this.node[start] == null) {
                    start = start + 1 & this.mask;
                    continue;
                }
                if (first == -1) {
                    first = start;
                } else if (first == start) break;
                int end = start;
                while (this.node[end] != null) {
                    end = end + 1 & this.mask;
                }
                IntOpenHashSet hashesSeen = new IntOpenHashSet();
                LongOpenHashSet signaturesSeen = new LongOpenHashSet();
                int pos = end;
                while (pos != start) {
                    pos = pos - 1 & this.mask;
                    boolean newSignature = signaturesSeen.add(this.signature[pos] & Long.MAX_VALUE);
                    assert (newSignature != ((this.signature[pos] & Long.MIN_VALUE) != 0L)) : newSignature + " == " + ((this.signature[pos] & Long.MIN_VALUE) != 0L);
                    hashesSeen.add(this.hash(this.signature[pos] & Long.MAX_VALUE));
                }
                IntIterator iterator = hashesSeen.iterator();
                while (iterator.hasNext()) {
                    assert (overallHashes.add(iterator.nextInt()));
                }
                start = end;
            }
        }

        public Handle2NodeMap(int size, TransformationStrategy<? super U> transform) {
            this.transform = transform;
            this.length = Math.max(64, 1 << Fast.ceilLog2((long)(1L + 3L * (long)size / 2L)));
            this.mask = this.length - 1;
            this.signature = new long[this.length];
            this.node = new InternalNode[this.length];
        }

        public Handle2NodeMap(TransformationStrategy<? super U> transform) {
            this.transform = transform;
            this.length = 64;
            this.mask = this.length - 1;
            this.signature = new long[this.length];
            this.node = new InternalNode[this.length];
        }

        protected int hash(long s) {
            return (int)(s ^ s >>> 32) & this.mask;
        }

        protected int findPos(BitVector v, long handleLength, long s) {
            int pos = this.hash(s);
            while (this.signature[pos] != 0L) {
                if ((this.signature[pos] & Long.MAX_VALUE) == s && ((this.signature[pos] & Long.MIN_VALUE) == 0L || handleLength == this.node[pos].handleLength() && v.equals(this.node[pos].reference.key(this.transform), 0L, handleLength))) {
                    return pos;
                }
                pos = pos + 1 & this.mask;
            }
            return -1;
        }

        protected int findExactPos(BitVector v, long handleLength, long s) {
            int pos = this.hash(s);
            while (this.node[pos] != null) {
                if ((this.signature[pos] & Long.MAX_VALUE) == s && handleLength == this.node[pos].handleLength() && v.equals(this.node[pos].reference.key(this.transform), 0L, handleLength)) {
                    return pos;
                }
                pos = pos + 1 & this.mask;
            }
            return -1;
        }

        public void clear() {
            this.length = 64;
            this.mask = this.length - 1;
            this.size = 0;
            this.signature = new long[this.length];
            this.node = new InternalNode[this.length];
        }

        public ObjectSet<LongArrayBitVector> keySet() {
            return new AbstractObjectSet<LongArrayBitVector>(){

                public ObjectIterator<LongArrayBitVector> iterator() {
                    return new AbstractObjectIterator<LongArrayBitVector>(){
                        private int i = 0;
                        private int pos = -1;

                        public boolean hasNext() {
                            return this.i < Handle2NodeMap.this.size;
                        }

                        public LongArrayBitVector next() {
                            if (!this.hasNext()) {
                                throw new NoSuchElementException();
                            }
                            while (Handle2NodeMap.this.node[++this.pos] == null) {
                            }
                            ++this.i;
                            return LongArrayBitVector.copy((BitVector)Handle2NodeMap.this.node[this.pos].handle(Handle2NodeMap.this.transform));
                        }
                    };
                }

                public boolean contains(Object o) {
                    BitVector v = (BitVector)o;
                    return Handle2NodeMap.this.get(v, true) != null;
                }

                public int size() {
                    return Handle2NodeMap.this.size;
                }
            };
        }

        public ObjectSet<Node<U>> values() {
            return new AbstractObjectSet<Node<U>>(){

                public ObjectIterator<Node<U>> iterator() {
                    return new AbstractObjectIterator<Node<U>>(){
                        private int i = 0;
                        private int pos = -1;

                        public boolean hasNext() {
                            return this.i < Handle2NodeMap.this.size;
                        }

                        public Node<U> next() {
                            if (!this.hasNext()) {
                                throw new NoSuchElementException();
                            }
                            while (Handle2NodeMap.this.node[++this.pos] == null) {
                            }
                            ++this.i;
                            return Handle2NodeMap.this.node[this.pos];
                        }
                    };
                }

                public boolean contains(Object o) {
                    Node node = (Node)o;
                    return Handle2NodeMap.this.get(node.handle(Handle2NodeMap.this.transform), true) != null;
                }

                public int size() {
                    return Handle2NodeMap.this.size;
                }
            };
        }

        public void replaceExisting(InternalNode<U> oldNode, InternalNode<U> newNode, long s) {
            int pos = this.hash(s);
            while (this.node[pos] != oldNode) {
                pos = pos + 1 & this.mask;
            }
            if (this.node[pos] == null) {
                throw new IllegalStateException();
            }
            this.node[pos] = newNode;
        }

        public void removeExisting(InternalNode<U> n, long s) {
            int pos = this.hash(s);
            int lastDup = -1;
            while (this.node[pos] != n) {
                if ((this.signature[pos] & Long.MAX_VALUE) == s) {
                    lastDup = pos;
                }
                pos = pos + 1 & this.mask;
            }
            if (this.node[pos] == null) {
                throw new IllegalStateException();
            }
            if ((this.signature[pos] & Long.MIN_VALUE) == 0L && lastDup != -1) {
                int n2 = lastDup;
                this.signature[n2] = this.signature[n2] & Long.MAX_VALUE;
            }
            do {
                int candidateHole = pos;
                while (this.node[pos = pos + 1 & this.mask] != null) {
                    int h = this.hash(this.signature[pos] & Long.MAX_VALUE);
                    if (candidateHole > pos ? candidateHole < h || h <= pos : candidateHole < h && h <= pos) continue;
                    break;
                }
                this.node[candidateHole] = this.node[pos];
                this.signature[candidateHole] = this.signature[pos];
            } while (this.node[pos] != null);
            --this.size;
        }

        public void addNew(InternalNode<U> v) {
            this.addNew(v, v.handleHash(this.transform));
        }

        public void addNew(InternalNode<U> n, long s) {
            int pos = this.hash(s);
            while (this.node[pos] != null) {
                if (this.signature[pos] == s) {
                    int n2 = pos;
                    this.signature[n2] = this.signature[n2] | Long.MIN_VALUE;
                }
                pos = pos + 1 & this.mask;
            }
            ++this.size;
            this.signature[pos] = s;
            this.node[pos] = n;
            if (3L * (long)this.size > 2L * (long)this.length) {
                this.length *= 2;
                this.mask = this.length - 1;
                long[] newKey = new long[this.length];
                InternalNode[] newValue = new InternalNode[this.length];
                long[] key = this.signature;
                InternalNode<U>[] value = this.node;
                int i = key.length;
                while (i-- != 0) {
                    if (value[i] == null) continue;
                    s = key[i] & Long.MAX_VALUE;
                    pos = this.hash(s);
                    while (newValue[pos] != null) {
                        if ((newKey[pos] & Long.MAX_VALUE) == s) {
                            int n3 = pos;
                            newKey[n3] = newKey[n3] | Long.MIN_VALUE;
                        }
                        pos = pos + 1 & this.mask;
                    }
                    newKey[pos] = s;
                    newValue[pos] = value[i];
                }
                this.signature = newKey;
                this.node = newValue;
            }
        }

        public int size() {
            return this.size;
        }

        public InternalNode<U> get(BitVector v, long handleLength, long s, boolean exact) {
            int pos = exact ? this.findExactPos(v, handleLength, s) : this.findPos(v, handleLength, s);
            return pos == -1 ? null : this.node[pos];
        }

        public int getPos(BitVector v, long handleLength, long s, boolean exact) {
            return exact ? this.findExactPos(v, handleLength, s) : this.findPos(v, handleLength, s);
        }

        public InternalNode<U> get(BitVector handle, boolean exact) {
            return this.get(handle, handle.length(), Hashes.murmur(handle, 42L) & Long.MAX_VALUE, exact);
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append('{');
            for (LongArrayBitVector v : this.keySet()) {
                s.append(v).append(" => ").append(this.get((BitVector)v, true)).append(", ");
            }
            if (s.length() > 1) {
                s.setLength(s.length() - 2);
            }
            s.append('}');
            return s.toString();
        }
    }
}

