/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.util;

import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.fastutil.bytes.ByteIterable;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.longs.AbstractLongBigList;
import it.unimi.dsi.fastutil.longs.LongBigList;
import it.unimi.dsi.fastutil.longs.LongIterable;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongIterators;
import it.unimi.dsi.fastutil.shorts.ShortIterable;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import it.unimi.dsi.sux4j.bits.SimpleSelect;
import java.io.Serializable;

public class EliasFanoMonotoneLongBigList
extends AbstractLongBigList
implements Serializable {
    private static final long serialVersionUID = 4L;
    protected final long length;
    protected final int l;
    protected final long[] lowerBits;
    protected final SimpleSelect selectUpper;
    protected final long lowerBitsMask;

    protected EliasFanoMonotoneLongBigList(long length, int l, long[] lowerBits, SimpleSelect selectUpper) {
        this.length = length;
        this.l = l;
        this.lowerBits = lowerBits;
        this.selectUpper = selectUpper;
        this.lowerBitsMask = (1L << l) - 1L;
    }

    public EliasFanoMonotoneLongBigList(final IntIterable list) {
        this(new LongIterable(){

            public LongIterator iterator() {
                return LongIterators.wrap((IntIterator)list.iterator());
            }
        });
    }

    public EliasFanoMonotoneLongBigList(final ShortIterable list) {
        this(new LongIterable(){

            public LongIterator iterator() {
                return LongIterators.wrap((ShortIterator)list.iterator());
            }
        });
    }

    public EliasFanoMonotoneLongBigList(final ByteIterable list) {
        this(new LongIterable(){

            public LongIterator iterator() {
                return LongIterators.wrap((ByteIterator)list.iterator());
            }
        });
    }

    public EliasFanoMonotoneLongBigList(LongIterable list) {
        this(EliasFanoMonotoneLongBigList.computeParameters(list.iterator()), list.iterator());
    }

    private static long[] computeParameters(LongIterator iterator) {
        long v = -1L;
        long prev = -1L;
        long c = 0L;
        while (iterator.hasNext()) {
            v = iterator.nextLong();
            if (prev > v) {
                throw new IllegalArgumentException("The list of values is not monotone: " + prev + " > " + v);
            }
            prev = v;
            ++c;
        }
        return new long[]{c, v};
    }

    public EliasFanoMonotoneLongBigList(long n, long upperBound, ByteIterator iterator) {
        this(new long[]{n, upperBound}, LongIterators.wrap((ByteIterator)iterator));
    }

    public EliasFanoMonotoneLongBigList(long n, long upperBound, ShortIterator iterator) {
        this(new long[]{n, upperBound}, LongIterators.wrap((ShortIterator)iterator));
    }

    public EliasFanoMonotoneLongBigList(long n, long upperBound, IntIterator iterator) {
        this(new long[]{n, upperBound}, LongIterators.wrap((IntIterator)iterator));
    }

    public EliasFanoMonotoneLongBigList(long n, long upperBound, LongIterator iterator) {
        this(new long[]{n, upperBound}, iterator);
    }

    protected EliasFanoMonotoneLongBigList(long[] a, LongIterator iterator) {
        this.length = a[0];
        long v = -1L;
        long upperBound = a[1];
        this.l = this.length == 0L ? 0 : Math.max(0, Fast.mostSignificantBit((long)(upperBound / this.length)));
        this.lowerBitsMask = (1L << this.l) - 1L;
        long lowerBitsMask = (1L << this.l) - 1L;
        LongArrayBitVector lowerBitsVector = LongArrayBitVector.getInstance();
        LongBigList lowerBitsList = lowerBitsVector.asLongBigList(this.l);
        lowerBitsList.size(this.length);
        LongArrayBitVector upperBits = LongArrayBitVector.getInstance().length(this.length + (upperBound >>> this.l) + 1L);
        long last = Long.MIN_VALUE;
        for (long i = 0L; i < this.length; ++i) {
            v = iterator.nextLong();
            if (v > upperBound) {
                throw new IllegalArgumentException("Too large value: " + v + " > " + upperBound);
            }
            if (v < last) {
                throw new IllegalArgumentException("Values are not nondecreasing: " + v + " < " + last);
            }
            if (this.l != 0) {
                lowerBitsList.set(i, v & lowerBitsMask);
            }
            upperBits.set((v >>> this.l) + i);
            last = v;
        }
        if (iterator.hasNext()) {
            throw new IllegalArgumentException("There are more than " + this.length + " values in the provided iterator");
        }
        this.lowerBits = lowerBitsVector.bits();
        this.selectUpper = new SimpleSelect((BitVector)upperBits);
    }

    public long numBits() {
        return this.selectUpper.numBits() + this.selectUpper.bitVector().length() + (long)this.lowerBits.length * 64L;
    }

    public long getLong(long index) {
        int l = this.l;
        long upperBits = this.selectUpper.select(index) - index;
        if (l == 0) {
            return upperBits;
        }
        long position = index * (long)l;
        int startWord = (int)(position / 64L);
        int startBit = (int)(position % 64L);
        int totalOffset = startBit + l;
        long result = this.lowerBits[startWord] >>> startBit;
        return upperBits << l | (totalOffset <= 64 ? result : result | this.lowerBits[startWord + 1] << -startBit) & this.lowerBitsMask;
    }

    public long[] get(long index, long[] dest, int offset, int length) {
        this.selectUpper.select(index, dest, offset, length);
        if (this.l == 0) {
            for (int i = 0; i < length; ++i) {
                int n = offset + i;
                dest[n] = dest[n] - index++;
            }
        } else {
            long position = index * (long)this.l;
            for (int i = 0; i < length; ++i) {
                int startWord = (int)(position / 64L);
                int startBit = (int)(position % 64L);
                int totalOffset = startBit + this.l;
                long result = this.lowerBits[startWord] >>> startBit;
                dest[offset + i] = dest[offset + i] - index++ << this.l | (totalOffset <= 64 ? result : result | this.lowerBits[startWord + 1] << -startBit) & this.lowerBitsMask;
                position += (long)this.l;
            }
        }
        return dest;
    }

    public long[] get(long index, long[] dest) {
        return this.get(index, dest, 0, dest.length);
    }

    public long size64() {
        return this.length;
    }
}

