/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.mph;

import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.BitVectors;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.bits.TransformationStrategies;
import it.unimi.dsi.bits.TransformationStrategy;
import it.unimi.dsi.fastutil.Size64;
import it.unimi.dsi.fastutil.ints.IntBigArrayBigList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongBigList;
import it.unimi.dsi.fastutil.longs.LongIterable;
import it.unimi.dsi.fastutil.objects.AbstractObject2LongFunction;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.io.OfflineIterable;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.sux4j.bits.Rank9;
import it.unimi.dsi.sux4j.io.ChunkedHashStore;
import it.unimi.dsi.sux4j.mph.Hashes;
import it.unimi.dsi.sux4j.mph.MWHCFunction;
import it.unimi.dsi.sux4j.mph.TwoStepsLcpMonotoneMinimalPerfectHashFunction;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZFastTrieDistributor<T>
extends AbstractObject2LongFunction<T>
implements Size64 {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZFastTrieDistributor.class);
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG = false;
    private static final boolean DDEBUG = false;
    private static final boolean DDDEBUG = false;
    private static final boolean ASSERTS = false;
    private static final int LEFT = 0;
    private static final int RIGHT = 1;
    private final Rank9 leaves;
    private final TransformationStrategy<? super T> transformationStrategy;
    private final MWHCFunction<BitVector> behaviour;
    private final long size;
    private MWHCFunction<BitVector> signatures;
    private TwoStepsLcpMonotoneMinimalPerfectHashFunction<BitVector> ranker;
    private long logWMask;
    private int logW;
    private long signatureMask;
    private int numDelimiters;
    private IntOpenHashSet mistakeSignatures;
    private MWHCFunction<BitVector> corrections;
    private boolean emptyTrie;
    private boolean noDelimiters;
    private long seed;

    public ZFastTrieDistributor(Iterable<? extends T> elements, int log2BucketSize, TransformationStrategy<? super T> transformationStrategy, ChunkedHashStore<BitVector> chunkedHashStore) throws IOException {
        this.transformationStrategy = transformationStrategy;
        this.seed = chunkedHashStore.seed();
        ProgressLogger pl = new ProgressLogger(LOGGER);
        pl.displayLocalSpeed = true;
        pl.displayFreeMemory = true;
        IntermediateTrie<? super T> intermediateTrie = new IntermediateTrie<T>(elements, log2BucketSize, transformationStrategy, this.seed, pl);
        this.size = intermediateTrie.numElements;
        this.emptyTrie = ((IntermediateTrie)intermediateTrie).internalNodeRepresentations.size64() == 0L;
        boolean bl = this.noDelimiters = ((IntermediateTrie)intermediateTrie).delimiters == null || ((IntermediateTrie)intermediateTrie).delimiters.size64() == 0L;
        if (this.noDelimiters) {
            this.behaviour = null;
            this.signatures = null;
            this.leaves = null;
            return;
        }
        this.logWMask = ((IntermediateTrie)intermediateTrie).logWMask;
        this.logW = ((IntermediateTrie)intermediateTrie).logW;
        this.signatureMask = ((IntermediateTrie)intermediateTrie).signatureMask;
        LOGGER.info("Computing behaviour function...");
        this.behaviour = new MWHCFunction.Builder().keys(TransformationStrategies.wrap(elements, transformationStrategy)).transform(TransformationStrategies.identity()).store(chunkedHashStore).values((LongIterable)((IntermediateTrie)intermediateTrie).externalValues, 1).indirect().build();
        ((IntermediateTrie)intermediateTrie).externalValues = null;
        if (!this.emptyTrie) {
            this.numDelimiters = ((IntermediateTrie)intermediateTrie).delimiters.size();
            ObjectOpenHashSet rankers = new ObjectOpenHashSet();
            pl.itemsName = "nodes";
            pl.expectedUpdates = ((IntermediateTrie)intermediateTrie).internalNodeRepresentations.size();
            pl.start((CharSequence)"Computing leaf ranker keys...");
            for (BitVector bv : ((IntermediateTrie)intermediateTrie).internalNodeRepresentations) {
                rankers.add((Object)LongArrayBitVector.copy((BitVector)bv.subVector(0L, bv.lastOne() + 1L)));
                rankers.add((Object)LongArrayBitVector.copy((BitVector)bv).append(1L, 1));
                LongArrayBitVector plus1 = LongArrayBitVector.copy((BitVector)bv);
                long lastZero = plus1.lastZero();
                if (lastZero != -1L) {
                    plus1.length(lastZero + 1L);
                    plus1.set(lastZero);
                    rankers.add((Object)plus1);
                }
                pl.lightUpdate();
            }
            pl.done();
            ((IntermediateTrie)intermediateTrie).internalNodeRepresentations.close();
            ((IntermediateTrie)intermediateTrie).internalNodeRepresentations = null;
            LOGGER.info("Sorting leaf ranker keys...");
            Object[] rankerArray = (LongArrayBitVector[])rankers.toArray((Object[])new LongArrayBitVector[rankers.size()]);
            rankers = null;
            Arrays.sort(rankerArray);
            LongArrayBitVector leavesBitVector = LongArrayBitVector.ofLength((long)rankerArray.length);
            int q = 0;
            LOGGER.info("Setting up leaf ranker bit vector...");
            OfflineIterable.OfflineIterator delimiterIterator = ((IntermediateTrie)intermediateTrie).delimiters.iterator();
            LongArrayBitVector bv = (LongArrayBitVector)delimiterIterator.next();
            for (Object v : rankerArray) {
                while (bv != null) {
                    int cmp = bv.compareTo((BitVector)v);
                    if (cmp == 0) {
                        leavesBitVector.set(q);
                    }
                    if (cmp >= 0) break;
                    bv = delimiterIterator.hasNext() ? (LongArrayBitVector)delimiterIterator.next() : null;
                }
                ++q;
            }
            delimiterIterator.close();
            ((IntermediateTrie)intermediateTrie).delimiters.close();
            this.leaves = new Rank9((BitVector)leavesBitVector);
            LOGGER.info("Creating leaf ranker...");
            this.ranker = new TwoStepsLcpMonotoneMinimalPerfectHashFunction.Builder<Object>().keys(Arrays.asList(rankerArray)).transform((TransformationStrategy<Object>)TransformationStrategies.prefixFree()).build();
            rankerArray = null;
            LOGGER.info("Computing length/signature map...");
            this.signatures = new MWHCFunction.Builder().keys(((IntermediateTrie)intermediateTrie).internalNodeKeys).transform(TransformationStrategies.identity()).values((LongIterable)((IntermediateTrie)intermediateTrie).internalNodeSignatures, ((IntermediateTrie)intermediateTrie).logW + ((IntermediateTrie)intermediateTrie).signatureSize).build();
            ((IntermediateTrie)intermediateTrie).internalNodeSignatures = null;
            ((IntermediateTrie)intermediateTrie).internalNodeKeys.close();
            ((IntermediateTrie)intermediateTrie).internalNodeKeys = null;
            this.mistakeSignatures = new IntOpenHashSet();
            IntOpenHashSet mistakeSignatures = new IntOpenHashSet();
            pl.itemsName = "keys";
            pl.expectedUpdates = this.size;
            pl.start((CharSequence)"Searching for mistakes...");
            Iterator iterator = TransformationStrategies.wrap(elements.iterator(), transformationStrategy);
            long c = 0L;
            int mistakes = 0;
            while (iterator.hasNext()) {
                BitVector curr = ((BitVector)iterator.next()).fast();
                if (this.getNodeStringLength(curr) != (long)((IntermediateTrie)intermediateTrie).externalParentRepresentations.getInt(c)) {
                    long h = Hashes.jenkins(curr, this.seed);
                    mistakeSignatures.add((int)h);
                    ++mistakes;
                }
                pl.lightUpdate();
                ++c;
            }
            pl.done();
            LOGGER.info("Errors: " + mistakes + " (" + 100.0 * (double)mistakes / (double)this.size + "%)");
            ObjectArrayList positives = new ObjectArrayList();
            LongArrayList results = new LongArrayList();
            c = 0L;
            pl.expectedUpdates = this.size;
            pl.start((CharSequence)"Searching for false positives...");
            for (BitVector curr : TransformationStrategies.wrap(elements, transformationStrategy)) {
                long h = Hashes.jenkins(curr, this.seed);
                if (mistakeSignatures.contains((int)h)) {
                    positives.add((Object)curr.copy());
                    results.add((long)((IntermediateTrie)intermediateTrie).externalParentRepresentations.getInt(c));
                }
                ++c;
                pl.lightUpdate();
            }
            pl.done();
            LOGGER.info("False errors: " + (positives.size() - mistakes) + (positives.size() != 0 ? " (" + 100 * (positives.size() - mistakes) / positives.size() + "%)" : ""));
            this.mistakeSignatures = mistakeSignatures;
            LOGGER.info("Creating correction function...");
            this.corrections = new MWHCFunction.Builder().keys(positives).transform(TransformationStrategies.identity()).values((LongIterable)results, this.logW).build();
            int bucketSize = 1 << log2BucketSize;
            LOGGER.debug("Forecast signature bits per element: " + 1.0 / (double)bucketSize * (1.23 + Fast.log2((double)((IntermediateTrie)intermediateTrie).w) + Fast.log2((double)bucketSize) + Fast.log2((double)Fast.log2((double)((IntermediateTrie)intermediateTrie).w))));
            LOGGER.debug("Actual signature bits per element: " + (double)this.signatures.numBits() / (double)this.size);
            LOGGER.debug("Forecast ranker bits per element: " + 3.0 / (double)bucketSize * (1.23 + Fast.log2((double)Math.E) - Fast.log2((double)Fast.log2((double)Math.E)) + Fast.log2((double)(1.0 + Fast.log2((double)(3.0 * (double)this.size / (double)bucketSize)))) + Fast.log2((double)((double)((IntermediateTrie)intermediateTrie).w - Fast.log2((double)Fast.log2((double)this.size))))));
            LOGGER.debug("Actual ranker bits per element: " + (double)this.ranker.numBits() / (double)this.size);
            LOGGER.debug("Forecast leaves bits per element: " + 3.0 / (double)bucketSize);
            LOGGER.debug("Actual leaves bits per element: " + (double)this.leaves.bitVector().length() / (double)this.size);
            LOGGER.debug("Forecast mistake bits per element: " + (Fast.log2((double)bucketSize) / (double)bucketSize + 2.46 / (double)bucketSize));
            LOGGER.debug("Actual mistake bits per element: " + (double)this.numBitsForMistakes() / (double)this.size);
            LOGGER.debug("Forecast behaviour bits per element: 1.23");
            LOGGER.debug("Actual behaviour bits per element: " + (double)this.behaviour.numBits() / (double)this.size);
        } else {
            this.signatures = null;
            this.leaves = null;
        }
    }

    private long getNodeStringLength(BitVector v) {
        return this.getNodeStringLength(v, Hashes.preprocessJenkins(v, this.seed));
    }

    private long getNodeStringLength(BitVector v, long[][] state) {
        long[] a = state[0];
        long[] b = state[1];
        long[] c = state[2];
        long corr = Hashes.jenkins(v, v.length(), a, b, c);
        if (this.mistakeSignatures.contains((int)corr)) {
            return this.corrections.getLong(v);
        }
        long r = v.length();
        long l = 0L;
        int i = Fast.mostSignificantBit((long)r);
        long mask = 1L << i;
        long[] triple = new long[3];
        while (r - l > 1L) {
            if ((l & mask) != (r - 1L & mask)) {
                long f = r - 1L & -1L << i;
                Hashes.jenkins(v, f, a, b, c, triple);
                long data = this.signatures.getLongByTriple(triple);
                if (data == -1L) {
                    r = f;
                } else {
                    long g = data & this.logWMask;
                    if (g > v.length()) {
                        r = f;
                    } else {
                        long h = Hashes.jenkins(v, g, a, b, c);
                        if (data >>> this.logW == (h & this.signatureMask) && g >= f) {
                            l = g;
                        } else {
                            r = f;
                        }
                    }
                }
            }
            --i;
            mask >>= 1;
        }
        return l;
    }

    public long getLong(Object o) {
        BitVector bv = (BitVector)o;
        long[][] state = Hashes.preprocessJenkins(bv, this.seed);
        long[] triple = new long[3];
        Hashes.jenkins(bv, bv.length(), state[0], state[1], state[2], triple);
        return this.getLongByBitVectorTripleAndState(bv, triple, state);
    }

    public long getLongByBitVectorTripleAndState(BitVector v, long[] triple, long[][] state) {
        if (this.noDelimiters) {
            return 0L;
        }
        int b = (int)this.behaviour.getLongByTriple(triple);
        if (this.emptyTrie) {
            return b;
        }
        long length = this.getNodeStringLength(v, state);
        if (length >= v.length()) {
            return -1L;
        }
        BitVector key = v.subVector(0L, length).copy();
        boolean bit = v.getBoolean(length);
        if (b == 0) {
            if (bit) {
                key.add(true);
            } else {
                key.length(key.lastOne() + 1L);
            }
            long pos = this.ranker.getLong(key);
            return this.leaves.rank(pos);
        }
        if (bit) {
            long lastZero = key.lastZero();
            if (lastZero == -1L) {
                return this.numDelimiters;
            }
            key.length(lastZero + 1L).set(lastZero);
            long pos = this.ranker.getLong(key);
            return this.leaves.rank(pos);
        }
        key.add(true);
        long pos = this.ranker.getLong(key);
        return this.leaves.rank(pos);
    }

    private long numBitsForMistakes() {
        if (this.emptyTrie) {
            return 0L;
        }
        return this.corrections.numBits() + (long)this.mistakeSignatures.size() * 32L;
    }

    public long numBits() {
        if (this.emptyTrie) {
            return 0L;
        }
        return this.behaviour.numBits() + this.signatures.numBits() + this.ranker.numBits() + this.leaves.bitVector().length() + this.transformationStrategy.numBits() + this.numBitsForMistakes();
    }

    public boolean containsKey(Object o) {
        return true;
    }

    public long size64() {
        return this.size;
    }

    @Deprecated
    public int size() {
        return (int)Math.min(this.size, Integer.MAX_VALUE);
    }

    private static final class IntermediateTrie<T> {
        protected Node root;
        protected final long numElements;
        private LongBigList externalValues;
        private IntBigArrayBigList externalParentRepresentations;
        private long w;
        private int logW;
        private int logLogW;
        private long logWMask;
        private int signatureSize;
        private long signatureMask;
        private OfflineIterable<BitVector, LongArrayBitVector> internalNodeKeys;
        private OfflineIterable<BitVector, LongArrayBitVector> internalNodeRepresentations;
        private LongBigList internalNodeSignatures;
        private OfflineIterable<BitVector, LongArrayBitVector> delimiters;
        private ObjectLinkedOpenHashSet<BitVector> leaves;

        void labelIntermediateTrie(Node node, LongArrayBitVector path, OfflineIterable<BitVector, LongArrayBitVector> delimiters, OfflineIterable<BitVector, LongArrayBitVector> representations, OfflineIterable<BitVector, LongArrayBitVector> keys, LongBigList internalNodeSignatures, long seed, boolean left) throws IOException {
            long parentPathLength = Math.max(0L, path.length() - 1L);
            if (node.left != null) {
                path.append((BitVector)node.path);
                this.labelIntermediateTrie(node.left, path.append(0L, 1), delimiters, representations, keys, internalNodeSignatures, seed, true);
                path.remove((int)(path.length() - 1L));
                long h = Hashes.jenkins((BitVector)path, seed);
                long p = -1L << Fast.mostSignificantBit((long)(parentPathLength ^ path.length())) & path.length();
                keys.add((Object)LongArrayBitVector.copy((BitVector)path.subVector(0L, p)));
                representations.add((Object)path.copy());
                internalNodeSignatures.add((h & this.signatureMask) << this.logW | path.length() & this.logWMask);
                this.labelIntermediateTrie(node.right, path.append(1L, 1), delimiters, representations, keys, internalNodeSignatures, seed, false);
                path.length(path.length() - node.path.length() - 1L);
            } else if (left) {
                delimiters.add((Object)LongArrayBitVector.copy((BitVector)path.subVector(0L, path.lastOne() + 1L)));
            } else {
                delimiters.add((Object)LongArrayBitVector.copy((BitVector)path));
            }
        }

        public IntermediateTrie(Iterable<? extends T> elements, int log2BucketSize, TransformationStrategy<? super T> transformationStrategy, long seed, ProgressLogger pl) throws IOException {
            Iterator<T> iterator = elements.iterator();
            long bucketSizeMask = (1L << log2BucketSize) - 1L;
            pl.itemsName = "keys";
            pl.displayFreeMemory = true;
            this.leaves = null;
            if (iterator.hasNext()) {
                Node node;
                int pos;
                int prefix;
                pl.start((CharSequence)"Building trie...");
                LongArrayBitVector prev = LongArrayBitVector.copy((BitVector)transformationStrategy.toBitVector(iterator.next()));
                pl.lightUpdate();
                LongArrayBitVector prevDelimiter = LongArrayBitVector.getInstance();
                Node root = null;
                LongArrayBitVector curr = LongArrayBitVector.getInstance();
                long count = 1L;
                long maxLength = prev.length();
                while (iterator.hasNext()) {
                    curr.replace(transformationStrategy.toBitVector(iterator.next()));
                    pl.lightUpdate();
                    prefix = (int)curr.longestCommonPrefixLength(prev);
                    if ((long)prefix == prev.length() && (long)prefix == curr.length()) {
                        throw new IllegalArgumentException("The input bit vectors are not distinct");
                    }
                    if ((long)prefix == prev.length() || (long)prefix == curr.length()) {
                        throw new IllegalArgumentException("The input bit vectors are not prefix-free");
                    }
                    if (prev.getBoolean(prefix)) {
                        throw new IllegalArgumentException("The input bit vectors are not lexicographically sorted");
                    }
                    if ((count & bucketSizeMask) == 0L) {
                        if (root == null) {
                            root = new Node(null, null, prev.copy());
                            prevDelimiter.replace(prev);
                        } else {
                            prefix = (int)prev.longestCommonPrefixLength(prevDelimiter);
                            pos = 0;
                            node = root;
                            Node n = null;
                            while (node != null) {
                                long pathLength = node.path.length();
                                if ((long)prefix < pathLength) {
                                    n = new Node(node.left, node.right, node.path.copy((long)(prefix + 1), pathLength));
                                    node.path.length((long)prefix);
                                    node.path.trim();
                                    node.left = n;
                                    node.right = new Node(null, null, prev.copy((long)(pos + prefix + 1), prev.length()));
                                    break;
                                }
                                prefix = (int)((long)prefix - (pathLength + 1L));
                                pos = (int)((long)pos + (pathLength + 1L));
                                node = node.right;
                            }
                            prevDelimiter.replace(prev);
                        }
                    }
                    prev.replace(curr);
                    maxLength = Math.max(maxLength, prev.length());
                    ++count;
                }
                pl.done();
                this.numElements = count;
                this.logLogW = Fast.ceilLog2((int)Fast.ceilLog2((long)maxLength));
                this.logW = 1 << this.logLogW;
                this.w = 1L << this.logW;
                this.logWMask = (1L << this.logW) - 1L;
                this.signatureSize = this.logLogW + log2BucketSize;
                this.signatureMask = (1L << this.signatureSize) - 1L;
                this.root = root;
                this.internalNodeRepresentations = new OfflineIterable((OfflineIterable.Serializer)BitVectors.OFFLINE_SERIALIZER, (Object)LongArrayBitVector.getInstance());
                if (root != null) {
                    LOGGER.info("Computing approximate structure...");
                    this.internalNodeSignatures = LongArrayBitVector.getInstance().asLongBigList(this.logW + this.signatureSize);
                    this.internalNodeKeys = new OfflineIterable((OfflineIterable.Serializer)BitVectors.OFFLINE_SERIALIZER, (Object)LongArrayBitVector.getInstance());
                    this.delimiters = new OfflineIterable((OfflineIterable.Serializer)BitVectors.OFFLINE_SERIALIZER, (Object)LongArrayBitVector.getInstance());
                    this.labelIntermediateTrie(root, LongArrayBitVector.getInstance(), this.delimiters, this.internalNodeRepresentations, this.internalNodeKeys, this.internalNodeSignatures, seed, true);
                    pl.expectedUpdates = this.numElements;
                    pl.start((CharSequence)"Computing function keys...");
                    this.externalValues = LongArrayBitVector.getInstance().asLongBigList(1);
                    this.externalParentRepresentations = new IntBigArrayBigList(this.numElements);
                    iterator = elements.iterator();
                    Node[] stack = new Node[(int)maxLength];
                    int[] len = new int[(int)maxLength];
                    stack[0] = root;
                    int depth = 0;
                    int c = 0;
                    boolean first = true;
                    while (iterator.hasNext()) {
                        curr.replace(transformationStrategy.toBitVector(iterator.next()));
                        pl.lightUpdate();
                        if (!first) {
                            prefix = (int)prev.longestCommonPrefixLength(curr);
                            while (depth > 0 && len[depth] > prefix) {
                                --depth;
                            }
                        } else {
                            first = false;
                        }
                        node = stack[depth];
                        pos = len[depth];
                        while (true) {
                            LongArrayBitVector nodePath = node.path;
                            BitVector currFromPos = curr.subVector((long)pos);
                            prefix = (int)currFromPos.longestCommonPrefixLength((BitVector)nodePath);
                            if ((long)prefix < nodePath.length() || node.isLeaf()) {
                                int behaviour = (long)prefix < nodePath.length() && !nodePath.getBoolean(prefix) ? 1 : 0;
                                LongArrayBitVector path = curr;
                                this.externalValues.add((long)behaviour);
                                this.externalParentRepresentations.add(depth == 0 ? pos : pos - 1);
                                break;
                            }
                            if ((long)(pos = (int)((long)pos + (nodePath.length() + 1L))) > curr.length()) {
                                assert (false);
                                break;
                            }
                            node = curr.getBoolean(pos - 1) ? node.right : node.left;
                            len[++depth] = pos;
                            stack[depth] = node;
                        }
                        prev.replace(curr);
                        ++c;
                    }
                    pl.done();
                }
            } else {
                this.numElements = 0L;
            }
            this.root = null;
        }

        private void recToString(Node n, MutableString printPrefix, MutableString result, MutableString path, int level) {
            if (n == null) {
                return;
            }
            result.append(printPrefix).append('(').append(level).append(')');
            if (n.path != null) {
                path.append((Object)n.path);
                result.append(" path: (").append(n.path.length()).append(") :").append((Object)n.path);
            }
            result.append('\n');
            path.append('0');
            this.recToString(n.left, printPrefix.append('\t').append("0 => "), result, path, level + 1);
            path.charAt(path.length() - 1, '1');
            this.recToString(n.right, printPrefix.replace(printPrefix.length() - 5, printPrefix.length(), "1 => "), result, path, level + 1);
            path.delete(path.length() - 1, path.length());
            printPrefix.delete(printPrefix.length() - 6, printPrefix.length());
            path.delete((int)((long)path.length() - n.path.length()), path.length());
        }

        public String toString() {
            MutableString s = new MutableString();
            this.recToString(this.root, new MutableString(), s, new MutableString(), 0);
            return s.toString();
        }

        private static class Node {
            private Node left;
            private Node right;
            private final LongArrayBitVector path;

            public Node(Node left, Node right, LongArrayBitVector path) {
                this.left = left;
                this.right = right;
                this.path = path;
            }

            public boolean isLeaf() {
                return this.right == null && this.left == null;
            }

            public String toString() {
                return "[" + this.path + "]";
            }
        }
    }
}

