/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.mph;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.stringparsers.ForNameStringParser;
import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.BitVectors;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.bits.HuTuckerTransformationStrategy;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.bits.TransformationStrategies;
import it.unimi.dsi.bits.TransformationStrategy;
import it.unimi.dsi.fastutil.Size64;
import it.unimi.dsi.fastutil.ints.IntBigArrays;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.longs.LongBigList;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.io.FastBufferedReader;
import it.unimi.dsi.io.FileLinesCollection;
import it.unimi.dsi.io.LineIterator;
import it.unimi.dsi.io.OfflineIterable;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.sux4j.io.ChunkedHashStore;
import it.unimi.dsi.sux4j.mph.AbstractHashFunction;
import it.unimi.dsi.sux4j.mph.Hashes;
import it.unimi.dsi.sux4j.mph.MWHCFunction;
import it.unimi.dsi.sux4j.mph.MinimalPerfectHashFunction;
import it.unimi.dsi.sux4j.util.EliasFanoLongBigList;
import it.unimi.dsi.util.XorShift1024StarRandomGenerator;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VLLcpMonotoneMinimalPerfectHashFunction<T>
extends AbstractHashFunction<T>
implements Serializable,
Size64 {
    public static final long serialVersionUID = 2L;
    private static final Logger LOGGER = LoggerFactory.getLogger(VLLcpMonotoneMinimalPerfectHashFunction.class);
    private static final boolean DEBUG = false;
    protected final long n;
    protected final int bucketSize;
    protected final int log2BucketSize;
    protected final int bucketSizeMask;
    protected final MinimalPerfectHashFunction<BitVector> mph;
    protected final LongBigList offsets;
    protected final EliasFanoLongBigList lcpLengths;
    protected final MWHCFunction<BitVector> lcp2Bucket;
    protected final TransformationStrategy<? super T> transform;
    private long seed;

    public long getLong(Object o) {
        if (this.n == 0L) {
            return this.defRetValue;
        }
        BitVector bitVector = this.transform.toBitVector(o).fast();
        long[] triple = new long[3];
        Hashes.jenkins(this.transform.toBitVector(o), this.seed, triple);
        long index = this.mph.getLongByTriple(triple);
        if (index == -1L) {
            return this.defRetValue;
        }
        long prefix = this.lcpLengths.getLong(index);
        if (prefix == -1L || prefix > bitVector.length()) {
            return this.defRetValue;
        }
        return (this.lcp2Bucket.getLong(bitVector.subVector(0L, prefix)) << this.log2BucketSize) + this.offsets.getLong(index);
    }

    public VLLcpMonotoneMinimalPerfectHashFunction(Iterable<? extends T> iterable, TransformationStrategy<? super T> transform) throws IOException {
        this(iterable, -1, transform);
    }

    public VLLcpMonotoneMinimalPerfectHashFunction(Iterable<? extends T> iterable, int numElements, TransformationStrategy<? super T> transform) throws IOException {
        ProgressLogger pl = new ProgressLogger(LOGGER);
        pl.displayLocalSpeed = true;
        pl.displayFreeMemory = true;
        this.transform = transform;
        XorShift1024StarRandomGenerator r = new XorShift1024StarRandomGenerator();
        if (numElements == -1) {
            if (iterable instanceof Size64) {
                this.n = ((Size64)iterable).size64();
            } else if (iterable instanceof Collection) {
                this.n = ((Collection)iterable).size();
            } else {
                long c = 0L;
                for (T dummy : iterable) {
                    ++c;
                }
                this.n = c;
            }
        } else {
            this.n = numElements;
        }
        if (this.n == 0L) {
            this.log2BucketSize = 0;
            this.bucketSizeMask = 0;
            this.bucketSize = 0;
            this.lcp2Bucket = null;
            this.offsets = null;
            this.lcpLengths = null;
            this.mph = null;
            return;
        }
        this.defRetValue = -1L;
        int theoreticalBucketSize = (int)Math.ceil(1.0 + 1.23 * Math.log(2.0) + Math.log(this.n) - Math.log(1.0 + Math.log(this.n)));
        this.log2BucketSize = Fast.ceilLog2((int)theoreticalBucketSize);
        this.bucketSize = 1 << this.log2BucketSize;
        this.bucketSizeMask = this.bucketSize - 1;
        long numBuckets = (this.n + (long)this.bucketSize - 1L) / (long)this.bucketSize;
        LongArrayBitVector prev = LongArrayBitVector.getInstance();
        LongArrayBitVector curr = LongArrayBitVector.getInstance();
        int currLcp = 0;
        int maxLcp = 0;
        int minLcp = Integer.MAX_VALUE;
        long maxLength = 0L;
        long totalLength = 0L;
        ChunkedHashStore<LongArrayBitVector> chunkedHashStore = new ChunkedHashStore<LongArrayBitVector>(TransformationStrategies.identity(), pl);
        chunkedHashStore.reset(r.nextLong());
        OfflineIterable lcps = new OfflineIterable((OfflineIterable.Serializer)BitVectors.OFFLINE_SERIALIZER, (Object)LongArrayBitVector.getInstance());
        pl.expectedUpdates = this.n;
        pl.start((CharSequence)"Scanning collection...");
        Iterator<T> iterator = iterable.iterator();
        for (long b = 0L; b < numBuckets; ++b) {
            prev.replace(transform.toBitVector(iterator.next()));
            chunkedHashStore.add(prev);
            pl.lightUpdate();
            maxLength = Math.max(maxLength, prev.length());
            totalLength += (long)Fast.length((long)(1L + prev.length()));
            currLcp = (int)prev.length();
            int currBucketSize = (int)Math.min((long)this.bucketSize, this.n - b * (long)this.bucketSize);
            for (int i = 0; i < currBucketSize - 1; ++i) {
                curr.replace(transform.toBitVector(iterator.next()));
                chunkedHashStore.add(curr);
                pl.lightUpdate();
                int prefix = (int)curr.longestCommonPrefixLength(prev);
                if ((long)prefix == prev.length() && (long)prefix == curr.length()) {
                    throw new IllegalArgumentException("The input bit vectors are not distinct");
                }
                if ((long)prefix == prev.length() || (long)prefix == curr.length()) {
                    throw new IllegalArgumentException("The input bit vectors are not prefix-free");
                }
                if (prev.getBoolean(prefix)) {
                    throw new IllegalArgumentException("The input bit vectors are not lexicographically sorted");
                }
                currLcp = Math.min(prefix, currLcp);
                prev.replace(curr);
                maxLength = Math.max(maxLength, prev.length());
                totalLength += (long)Fast.length((long)(1L + prev.length()));
            }
            lcps.add((Object)prev.subVector(0L, (long)currLcp));
            maxLcp = Math.max(maxLcp, currLcp);
            minLcp = Math.min(minLcp, currLcp);
        }
        pl.done();
        this.lcp2Bucket = new MWHCFunction.Builder().keys(lcps).transform(TransformationStrategies.identity()).build();
        int[][] lcpLength = IntBigArrays.newBigArray((long)lcps.size64());
        long p = 0L;
        for (LongArrayBitVector bv : lcps) {
            IntBigArrays.set((int[][])lcpLength, (long)p++, (int)((int)bv.length()));
        }
        lcps.close();
        Iterable bitVectors = TransformationStrategies.wrap(iterable, transform);
        this.mph = new MinimalPerfectHashFunction.Builder().keys(bitVectors).transform(TransformationStrategies.identity()).store(chunkedHashStore).build();
        this.seed = chunkedHashStore.seed();
        this.offsets = LongArrayBitVector.getInstance().asLongBigList(this.log2BucketSize);
        this.offsets.size(this.n);
        LongBigList lcpLengthsTemp = LongArrayBitVector.getInstance().asLongBigList(Fast.length((int)maxLcp));
        lcpLengthsTemp.size(this.n);
        LOGGER.info("Generating data tables...");
        for (ChunkedHashStore.Chunk chunk : chunkedHashStore) {
            for (long[] quadruple : chunk) {
                long index = this.mph.getLongByTriple(quadruple);
                this.offsets.set(index, quadruple[3] & (long)this.bucketSizeMask);
                lcpLengthsTemp.set(index, (long)IntBigArrays.get((int[][])lcpLength, (long)((int)quadruple[3] >> this.log2BucketSize)));
            }
        }
        chunkedHashStore.close();
        this.lcpLengths = new EliasFanoLongBigList((LongIterator)lcpLengthsTemp.iterator(), minLcp, true);
        LOGGER.debug("Bucket size: " + this.bucketSize);
        double avgLength = (double)totalLength / (double)this.n;
        LOGGER.debug("Forecast bit cost per element: " + (4.46 + avgLength + Fast.log2((double)avgLength) + Fast.log2((double)Math.E) - Fast.log2((double)Fast.log2((double)Math.E)) + Fast.log2((double)(1.0 + Fast.log2((double)this.n)))));
        LOGGER.info("Actual bit cost per element: " + (double)this.numBits() / (double)this.n);
    }

    @Override
    public long size64() {
        return this.n;
    }

    public long numBits() {
        if (this.n == 0L) {
            return 0L;
        }
        return this.offsets.size64() * (long)this.log2BucketSize + this.lcpLengths.numBits() + this.lcp2Bucket.numBits() + this.mph.numBits() + this.transform.numBits();
    }

    public static void main(String[] arg) throws NoSuchMethodException, IOException, JSAPException {
        Object collection;
        SimpleJSAP jsap = new SimpleJSAP(VLLcpMonotoneMinimalPerfectHashFunction.class.getName(), "Builds an LCP-based monotone minimal perfect hash function reading a newline-separated list of strings.", new Parameter[]{new FlaggedOption("encoding", (StringParser)ForNameStringParser.getParser(Charset.class), "UTF-8", false, 'e', "encoding", "The string file encoding."), new Switch("huTucker", 'h', "hu-tucker", "Use Hu-Tucker coding to reduce string length."), new Switch("iso", 'i', "iso", "Use ISO-8859-1 coding internally (i.e., just use the lower eight bits of each character)."), new Switch("utf32", '\u0000', "utf-32", "Use UTF-32 internally (handles surrogate pairs)."), new Switch("zipped", 'z', "zipped", "The string list is compressed in gzip format."), new UnflaggedOption("function", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename for the serialised monotone minimal perfect hash function."), new UnflaggedOption("stringFile", (StringParser)JSAP.STRING_PARSER, "-", false, false, "The name of a file containing a newline-separated list of strings, or - for standard input; in the first case, strings will not be loaded into core memory.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        String functionName = jsapResult.getString("function");
        String stringFile = jsapResult.getString("stringFile");
        Charset encoding = (Charset)jsapResult.getObject("encoding");
        boolean zipped = jsapResult.getBoolean("zipped");
        boolean iso = jsapResult.getBoolean("iso");
        boolean utf32 = jsapResult.getBoolean("utf32");
        boolean huTucker = jsapResult.getBoolean("huTucker");
        if ("-".equals(stringFile)) {
            ProgressLogger pl = new ProgressLogger(LOGGER);
            pl.displayLocalSpeed = true;
            pl.displayFreeMemory = true;
            pl.start((CharSequence)"Loading strings...");
            collection = new LineIterator(new FastBufferedReader((Reader)new InputStreamReader(zipped ? new GZIPInputStream(System.in) : System.in, encoding)), pl).allLines();
            pl.done();
        } else {
            collection = new FileLinesCollection((CharSequence)stringFile, encoding.toString(), zipped);
        }
        HuTuckerTransformationStrategy transformationStrategy = huTucker ? new HuTuckerTransformationStrategy((Iterable)collection, true) : (iso ? TransformationStrategies.prefixFreeIso() : (utf32 ? TransformationStrategies.prefixFreeUtf32() : TransformationStrategies.prefixFreeUtf16()));
        BinIO.storeObject(new VLLcpMonotoneMinimalPerfectHashFunction(collection, transformationStrategy), (CharSequence)functionName);
        LOGGER.info("Completed.");
    }
}

