/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.mph;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.stringparsers.ForNameStringParser;
import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.bits.HuTuckerTransformationStrategy;
import it.unimi.dsi.bits.TransformationStrategies;
import it.unimi.dsi.bits.TransformationStrategy;
import it.unimi.dsi.fastutil.Size64;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.longs.AbstractLongBigList;
import it.unimi.dsi.fastutil.longs.LongIterable;
import it.unimi.dsi.io.FastBufferedReader;
import it.unimi.dsi.io.FileLinesCollection;
import it.unimi.dsi.io.LineIterator;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.sux4j.io.ChunkedHashStore;
import it.unimi.dsi.sux4j.mph.AbstractHashFunction;
import it.unimi.dsi.sux4j.mph.MWHCFunction;
import it.unimi.dsi.sux4j.mph.PaCoTrieDistributor;
import it.unimi.dsi.util.XorShift1024StarRandomGenerator;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaCoTrieDistributorMonotoneMinimalPerfectHashFunction<T>
extends AbstractHashFunction<T>
implements Size64,
Serializable {
    public static final long serialVersionUID = 3L;
    private static final Logger LOGGER = LoggerFactory.getLogger(PaCoTrieDistributorMonotoneMinimalPerfectHashFunction.class);
    private final long size;
    private final int bucketSize;
    private final int log2BucketSize;
    private final TransformationStrategy<? super T> transform;
    private final PaCoTrieDistributor<BitVector> distributor;
    private final MWHCFunction<BitVector> offset;

    public long getLong(Object o) {
        if (this.size == 0L) {
            return this.defRetValue;
        }
        BitVector bv = this.transform.toBitVector(o).fast();
        long bucket = this.distributor.getLong(bv);
        return (bucket << this.log2BucketSize) + this.offset.getLong(bv);
    }

    public PaCoTrieDistributorMonotoneMinimalPerfectHashFunction(Iterable<? extends T> elements, TransformationStrategy<? super T> transform) throws IOException {
        this.transform = transform;
        this.defRetValue = -1L;
        long maxLength = 0L;
        long totalLength = 0L;
        XorShift1024StarRandomGenerator random = new XorShift1024StarRandomGenerator();
        ProgressLogger pl = new ProgressLogger(LOGGER);
        pl.displayLocalSpeed = true;
        pl.displayFreeMemory = true;
        pl.itemsName = "keys";
        pl.start((CharSequence)"Creating chunked hash store...");
        ChunkedHashStore<BitVector> chunkedHashStore = new ChunkedHashStore<BitVector>(TransformationStrategies.identity());
        chunkedHashStore.reset(random.nextLong());
        for (T s : elements) {
            BitVector bv = transform.toBitVector(s);
            chunkedHashStore.add(bv);
            maxLength = Math.max(maxLength, bv.length());
            totalLength += bv.length();
            pl.lightUpdate();
        }
        pl.done();
        LOGGER.debug("Maximum length: " + maxLength);
        LOGGER.debug("Average length: " + (double)totalLength / (double)chunkedHashStore.size());
        this.size = chunkedHashStore.size();
        if (this.size == 0L) {
            this.log2BucketSize = 0;
            this.bucketSize = 0;
            this.distributor = null;
            this.offset = null;
            chunkedHashStore.close();
            return;
        }
        long averageLength = (totalLength + this.size - 1L) / this.size;
        int t = Fast.mostSignificantBit((int)((int)Math.floor((double)averageLength - Math.log(this.size) - Math.log((double)averageLength - Math.log(this.size)) - 1.0)));
        int firstbucketSize = 1 << t;
        LOGGER.debug("First bucket size estimate: " + firstbucketSize);
        Iterable bitVectors = TransformationStrategies.wrap(elements, transform);
        LOGGER.info("Creating distributor...");
        PaCoTrieDistributor firstDistributor = new PaCoTrieDistributor(bitVectors, t, TransformationStrategies.identity());
        this.log2BucketSize = firstDistributor.numBits() == 0L || (long)firstbucketSize >= this.size ? t : t - Fast.mostSignificantBit((int)((int)Math.ceil((double)this.size / ((double)firstDistributor.numBits() * Math.log(2.0)))));
        this.bucketSize = 1 << this.log2BucketSize;
        LOGGER.debug("Second bucket size estimate: " + this.bucketSize);
        if (firstbucketSize == this.bucketSize) {
            this.distributor = firstDistributor;
        } else {
            firstDistributor = null;
            this.distributor = new PaCoTrieDistributor(bitVectors, this.log2BucketSize, TransformationStrategies.identity());
        }
        LOGGER.debug("Bucket size: " + this.bucketSize);
        final int bucketSizeMask = this.bucketSize - 1;
        LOGGER.info("Generating offset function...");
        this.offset = new MWHCFunction.Builder().keys(bitVectors).transform(TransformationStrategies.identity()).store(chunkedHashStore).values((LongIterable)new AbstractLongBigList(){

            public long getLong(long index) {
                return index & (long)bucketSizeMask;
            }

            public long size64() {
                return PaCoTrieDistributorMonotoneMinimalPerfectHashFunction.this.size;
            }
        }, this.log2BucketSize).indirect().build();
        chunkedHashStore.close();
        LOGGER.debug("Forecast distributor bit cost: " + (double)(this.size / (long)this.bucketSize) * ((double)(maxLength + (long)this.log2BucketSize) - Math.log(this.size)));
        LOGGER.debug("Actual distributor bit cost: " + this.distributor.numBits());
        LOGGER.debug("Forecast bit cost per element: " + (1.23 + Fast.log2((double)Math.E) - Fast.log2((double)Fast.log2((double)Math.E)) + Fast.log2((double)((double)maxLength - Fast.log2((double)this.size)))));
        LOGGER.info("Actual bit cost per element: " + (double)this.numBits() / (double)this.size);
    }

    @Override
    public long size64() {
        return this.size;
    }

    public long numBits() {
        return this.distributor.numBits() + this.offset.numBits() + this.transform.numBits();
    }

    public static void main(String[] arg) throws NoSuchMethodException, IOException, JSAPException {
        Object collection;
        SimpleJSAP jsap = new SimpleJSAP(PaCoTrieDistributorMonotoneMinimalPerfectHashFunction.class.getName(), "Builds an PaCo trie-based monotone minimal perfect hash function reading a newline-separated list of strings.", new Parameter[]{new FlaggedOption("encoding", (StringParser)ForNameStringParser.getParser(Charset.class), "UTF-8", false, 'e', "encoding", "The string file encoding."), new Switch("huTucker", 'h', "hu-tucker", "Use Hu-Tucker coding to reduce string length."), new Switch("iso", 'i', "iso", "Use ISO-8859-1 coding internally (i.e., just use the lower eight bits of each character)."), new Switch("utf32", '\u0000', "utf-32", "Use UTF-32 internally (handles surrogate pairs)."), new Switch("zipped", 'z', "zipped", "The string list is compressed in gzip format."), new UnflaggedOption("function", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename for the serialised monotone minimal perfect hash function."), new UnflaggedOption("stringFile", (StringParser)JSAP.STRING_PARSER, "-", false, false, "The name of a file containing a newline-separated list of strings, or - for standard input; in the first case, strings will not be loaded into core memory.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        String functionName = jsapResult.getString("function");
        String stringFile = jsapResult.getString("stringFile");
        Charset encoding = (Charset)jsapResult.getObject("encoding");
        boolean zipped = jsapResult.getBoolean("zipped");
        boolean iso = jsapResult.getBoolean("iso");
        boolean utf32 = jsapResult.getBoolean("utf32");
        boolean huTucker = jsapResult.getBoolean("huTucker");
        if ("-".equals(stringFile)) {
            ProgressLogger pl = new ProgressLogger(LOGGER);
            pl.displayLocalSpeed = true;
            pl.displayFreeMemory = true;
            pl.start((CharSequence)"Loading strings...");
            collection = new LineIterator(new FastBufferedReader((Reader)new InputStreamReader(zipped ? new GZIPInputStream(System.in) : System.in, encoding)), pl).allLines();
            pl.done();
        } else {
            collection = new FileLinesCollection((CharSequence)stringFile, encoding.toString(), zipped);
        }
        HuTuckerTransformationStrategy transformationStrategy = huTucker ? new HuTuckerTransformationStrategy((Iterable)collection, true) : (iso ? TransformationStrategies.prefixFreeIso() : (utf32 ? TransformationStrategies.prefixFreeUtf32() : TransformationStrategies.prefixFreeUtf16()));
        BinIO.storeObject(new PaCoTrieDistributorMonotoneMinimalPerfectHashFunction(collection, transformationStrategy), (CharSequence)functionName);
        LOGGER.info("Completed.");
    }
}

