/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.mph;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.stringparsers.FileStringParser;
import com.martiansoftware.jsap.stringparsers.ForNameStringParser;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.bits.TransformationStrategies;
import it.unimi.dsi.bits.TransformationStrategy;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.longs.LongBigList;
import it.unimi.dsi.io.FastBufferedReader;
import it.unimi.dsi.io.FileLinesCollection;
import it.unimi.dsi.io.LineIterator;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.sux4j.io.ChunkedHashStore;
import it.unimi.dsi.sux4j.mph.AbstractHashFunction;
import it.unimi.dsi.sux4j.mph.Hashes;
import it.unimi.dsi.sux4j.mph.HypergraphSorter;
import it.unimi.dsi.util.XorShift1024StarRandomGenerator;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinimalPerfectHashFunction<T>
extends AbstractHashFunction<T>
implements Serializable {
    public static final long serialVersionUID = 5L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MinimalPerfectHashFunction.class);
    private static final boolean ASSERTS = false;
    private static final int WORDS_PER_SUPERBLOCK = 32;
    public static final int BITS_PER_BLOCK = 1024;
    public static final int LOG2_CHUNK_SIZE = 10;
    protected final long n;
    private final int chunkShift;
    protected final long globalSeed;
    protected final long[] seed;
    protected final long[] offset;
    protected final LongBigList values;
    protected final LongArrayBitVector bitVector;
    protected transient long[] array;
    protected final TransformationStrategy<? super T> transform;
    protected final long signatureMask;
    protected final LongBigList signatures;
    protected final long[] count;

    public static int countNonzeroPairs(long x) {
        return Long.bitCount((x | x >>> 1) & 0x5555555555555555L);
    }

    private long rank(long pos) {
        assert ((pos *= 2L) >= 0L);
        assert (pos <= this.bitVector.length());
        int word = (int)(pos / 64L);
        int block = word / 16 & 0xFFFFFFFE;
        int offset = word % 32 / 6 - 1;
        long result = this.count[block] + (this.count[block + 1] >> 12 * (offset + (offset >>> 28 & 6)) & 0x7FFL) + (long)MinimalPerfectHashFunction.countNonzeroPairs(this.array[word] & (1L << (int)(pos % 64L)) - 1L);
        int todo = (word & 0x1F) % 6;
        while (todo-- != 0) {
            result += (long)MinimalPerfectHashFunction.countNonzeroPairs(this.array[--word]);
        }
        return result;
    }

    @Deprecated
    public MinimalPerfectHashFunction(Iterable<? extends T> keys, TransformationStrategy<? super T> transform) throws IOException {
        this(keys, transform, null, null);
    }

    @Deprecated
    public MinimalPerfectHashFunction(Iterable<? extends T> keys, TransformationStrategy<? super T> transform, File tempDir) throws IOException {
        this(keys, transform, tempDir, null);
    }

    @Deprecated
    public MinimalPerfectHashFunction(TransformationStrategy<? super T> transform, ChunkedHashStore<T> chunkedHashStore) throws IOException {
        this(null, transform, null, chunkedHashStore);
    }

    @Deprecated
    public MinimalPerfectHashFunction(Iterable<? extends T> keys, TransformationStrategy<? super T> transform, ChunkedHashStore<T> chunkedHashStore) throws IOException {
        this(keys, transform, null, chunkedHashStore);
    }

    @Deprecated
    public MinimalPerfectHashFunction(Iterable<? extends T> keys, TransformationStrategy<? super T> transform, File tempDir, ChunkedHashStore<T> chunkedHashStore) throws IOException {
        this(keys, transform, 0, tempDir, chunkedHashStore);
    }

    protected MinimalPerfectHashFunction(Iterable<? extends T> keys, TransformationStrategy<? super T> transform, int signatureWidth, File tempDir, ChunkedHashStore<T> chunkedHashStore) throws IOException {
        boolean givenChunkedHashStore;
        this.transform = transform;
        ProgressLogger pl = new ProgressLogger(LOGGER);
        pl.displayLocalSpeed = true;
        pl.displayFreeMemory = true;
        XorShift1024StarRandomGenerator r = new XorShift1024StarRandomGenerator();
        pl.itemsName = "keys";
        boolean bl = givenChunkedHashStore = chunkedHashStore != null;
        if (!givenChunkedHashStore) {
            chunkedHashStore = new ChunkedHashStore<T>(transform, tempDir, pl);
            chunkedHashStore.reset(r.nextLong());
            chunkedHashStore.addAll(keys.iterator());
        }
        this.n = chunkedHashStore.size();
        this.defRetValue = -1L;
        int log2NumChunks = Math.max(0, Fast.mostSignificantBit((long)(this.n >> 10)));
        this.chunkShift = chunkedHashStore.log2Chunks(log2NumChunks);
        int numChunks = 1 << log2NumChunks;
        LOGGER.debug("Number of chunks: " + numChunks);
        this.seed = new long[numChunks];
        this.offset = new long[numChunks + 1];
        this.bitVector = LongArrayBitVector.getInstance();
        this.values = this.bitVector.asLongBigList(2);
        this.values.size((long)Math.ceil((double)this.n * 1.23) + (long)(4 * numChunks));
        this.array = this.bitVector.bits();
        int duplicates = 0;
        while (true) {
            LOGGER.debug("Generating minimal perfect hash function...");
            long seed = 0L;
            pl.expectedUpdates = numChunks;
            pl.itemsName = "chunks";
            pl.start((CharSequence)"Analysing chunks... ");
            try {
                int q = 0;
                for (ChunkedHashStore.Chunk chunk : chunkedHashStore) {
                    HypergraphSorter sorter = new HypergraphSorter(chunk.size(), false);
                    do {
                        seed = r.nextLong();
                    } while (!sorter.generateAndSort(chunk.iterator(), seed));
                    this.seed[q] = seed;
                    this.offset[q + 1] = this.offset[q] + (long)sorter.numVertices;
                    int top = chunk.size();
                    int v = 0;
                    int[] stack = sorter.stack;
                    int[] vertex1 = sorter.vertex1;
                    int[] vertex2 = sorter.vertex2;
                    long off = this.offset[q];
                    while (top > 0) {
                        int k = ((v = stack[--top]) > vertex1[v] ? 1 : 0) + (v > vertex2[v] ? 1 : 0);
                        assert (k >= 0 && k < 3) : Integer.toString(k);
                        long s = this.values.getLong(off + (long)vertex1[v]) + this.values.getLong(off + (long)vertex2[v]);
                        long value = ((long)k - s + 9L) % 3L;
                        assert (this.values.getLong(off + (long)v) == 0L);
                        this.values.set(off + (long)v, value == 0L ? 3L : value);
                    }
                    ++q;
                    pl.update();
                }
                pl.done();
            }
            catch (ChunkedHashStore.DuplicateException e) {
                if (keys == null) {
                    throw new IllegalStateException("You provided no keys, but the chunked hash store was not checked");
                }
                if (duplicates++ > 3) {
                    throw new IllegalArgumentException("The input list contains duplicates");
                }
                LOGGER.warn("Found duplicate. Recomputing triples...");
                chunkedHashStore.reset(r.nextLong());
                chunkedHashStore.addAll(keys.iterator());
                continue;
            }
            break;
        }
        this.globalSeed = chunkedHashStore.seed();
        if (this.n > 0L) {
            long m = this.values.size64();
            long length = this.bitVector.length();
            int numWords = (int)((length + 64L - 1L) / 64L);
            int numCounts = (int)((length + 2048L - 1L) / 2048L) * 2;
            this.count = new long[numCounts + 1];
            long c = 0L;
            int pos = 0;
            int i = 0;
            while (i < numWords) {
                this.count[pos] = c;
                for (int j = 0; j < 32; ++j) {
                    if (j != 0 && j % 6 == 0) {
                        int n = pos + 1;
                        this.count[n] = this.count[n] | (i + j <= numWords ? c - this.count[pos] : 2047L) << 12 * (j / 6 - 1);
                    }
                    if (i + j >= numWords) continue;
                    c += (long)MinimalPerfectHashFunction.countNonzeroPairs(this.array[i + j]);
                }
                i += 32;
                pos += 2;
            }
            this.count[numCounts] = c;
        } else {
            this.count = LongArrays.EMPTY_ARRAY;
        }
        LOGGER.info("Completed.");
        LOGGER.debug("Forecast bit cost per key: 2.585");
        LOGGER.info("Actual bit cost per key: " + (double)this.numBits() / (double)this.n);
        if (signatureWidth != 0) {
            this.signatureMask = -1L >>> 64 - signatureWidth;
            this.signatures = LongArrayBitVector.getInstance().asLongBigList(signatureWidth);
            this.signatures.size(this.n);
            pl.expectedUpdates = this.n;
            pl.itemsName = "signatures";
            pl.start((CharSequence)"Signing...");
            for (ChunkedHashStore.Chunk chunk : chunkedHashStore) {
                Iterator<long[]> iterator = chunk.iterator();
                int i = chunk.size();
                while (i-- != 0) {
                    long[] triple = iterator.next();
                    int[] e = new int[3];
                    this.signatures.set(this.getLongByTripleNoCheck(triple, e), this.signatureMask & triple[0]);
                    pl.lightUpdate();
                }
            }
            pl.done();
        } else {
            this.signatureMask = 0L;
            this.signatures = null;
        }
        if (!givenChunkedHashStore) {
            chunkedHashStore.close();
        }
    }

    public long numBits() {
        return this.values.size64() * 2L + (long)(this.count.length * 64) + (long)this.offset.length * 64L + (long)this.seed.length * 64L;
    }

    @Deprecated
    protected MinimalPerfectHashFunction(MinimalPerfectHashFunction<T> mph) {
        this.n = mph.n;
        this.seed = mph.seed;
        this.offset = mph.offset;
        this.bitVector = mph.bitVector;
        this.globalSeed = mph.globalSeed;
        this.chunkShift = mph.chunkShift;
        this.values = mph.values;
        this.array = mph.array;
        this.count = mph.count;
        this.transform = mph.transform.copy();
        this.signatureMask = mph.signatureMask;
        this.signatures = mph.signatures;
    }

    public long getLong(Object key) {
        if (this.n == 0L) {
            return this.defRetValue;
        }
        int[] e = new int[3];
        long[] h = new long[3];
        Hashes.jenkins(this.transform.toBitVector(key), this.globalSeed, h);
        int chunk = this.chunkShift == 64 ? 0 : (int)(h[0] >>> this.chunkShift);
        long chunkOffset = this.offset[chunk];
        HypergraphSorter.tripleToEdge(h, this.seed[chunk], (int)(this.offset[chunk + 1] - chunkOffset), e);
        if (e[0] == -1) {
            return this.defRetValue;
        }
        long result = this.rank(chunkOffset + (long)e[(int)(this.values.getLong((long)e[0] + chunkOffset) + this.values.getLong((long)e[1] + chunkOffset) + this.values.getLong((long)e[2] + chunkOffset)) % 3]);
        if (this.signatureMask != 0L) {
            return result >= this.n || ((this.signatures.getLong(result) ^ h[0]) & this.signatureMask) != 0L ? this.defRetValue : result;
        }
        return result < this.n ? result : this.defRetValue;
    }

    public long getLongByTriple(long[] triple) {
        if (this.n == 0L) {
            return this.defRetValue;
        }
        int[] e = new int[3];
        int chunk = this.chunkShift == 64 ? 0 : (int)(triple[0] >>> this.chunkShift);
        long chunkOffset = this.offset[chunk];
        HypergraphSorter.tripleToEdge(triple, this.seed[chunk], (int)(this.offset[chunk + 1] - chunkOffset), e);
        if (e[0] == -1) {
            return this.defRetValue;
        }
        long result = this.rank(chunkOffset + (long)e[(int)(this.values.getLong((long)e[0] + chunkOffset) + this.values.getLong((long)e[1] + chunkOffset) + this.values.getLong((long)e[2] + chunkOffset)) % 3]);
        if (this.signatureMask != 0L) {
            return result >= this.n || this.signatures.getLong(result) != (triple[0] & this.signatureMask) ? this.defRetValue : result;
        }
        return result < this.n ? result : this.defRetValue;
    }

    private long getLongByTripleNoCheck(long[] triple, int[] e) {
        int chunk = this.chunkShift == 64 ? 0 : (int)(triple[0] >>> this.chunkShift);
        long chunkOffset = this.offset[chunk];
        HypergraphSorter.tripleToEdge(triple, this.seed[chunk], (int)(this.offset[chunk + 1] - chunkOffset), e);
        return this.rank(chunkOffset + (long)e[(int)(this.values.getLong((long)e[0] + chunkOffset) + this.values.getLong((long)e[1] + chunkOffset) + this.values.getLong((long)e[2] + chunkOffset)) % 3]);
    }

    @Override
    public long size64() {
        return this.n;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.array = this.bitVector.bits();
    }

    public static void main(String[] arg) throws NoSuchMethodException, IOException, JSAPException {
        Object collection;
        SimpleJSAP jsap = new SimpleJSAP(MinimalPerfectHashFunction.class.getName(), "Builds a minimal perfect hash function reading a newline-separated list of strings.", new Parameter[]{new FlaggedOption("encoding", (StringParser)ForNameStringParser.getParser(Charset.class), "UTF-8", false, 'e', "encoding", "The string file encoding."), new FlaggedOption("tempDir", (StringParser)FileStringParser.getParser(), JSAP.NO_DEFAULT, false, 'T', "temp-dir", "A directory for temporary files."), new Switch("iso", 'i', "iso", "Use ISO-8859-1 coding internally (i.e., just use the lower eight bits of each character)."), new Switch("utf32", '\u0000', "utf-32", "Use UTF-32 internally (handles surrogate pairs)."), new FlaggedOption("signatureWidth", (StringParser)JSAP.INTEGER_PARSER, JSAP.NO_DEFAULT, false, 's', "signature-width", "If specified, the signature width in bits."), new Switch("zipped", 'z', "zipped", "The string list is compressed in gzip format."), new UnflaggedOption("function", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename for the serialised minimal perfect hash function."), new UnflaggedOption("stringFile", (StringParser)JSAP.STRING_PARSER, "-", false, false, "The name of a file containing a newline-separated list of strings, or - for standard input; in the first case, strings will not be loaded into core memory.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        String functionName = jsapResult.getString("function");
        String stringFile = jsapResult.getString("stringFile");
        Charset encoding = (Charset)jsapResult.getObject("encoding");
        boolean zipped = jsapResult.getBoolean("zipped");
        boolean iso = jsapResult.getBoolean("iso");
        boolean utf32 = jsapResult.getBoolean("utf32");
        int signatureWidth = jsapResult.getInt("signatureWidth", 0);
        if ("-".equals(stringFile)) {
            ProgressLogger pl = new ProgressLogger(LOGGER);
            pl.displayLocalSpeed = true;
            pl.displayFreeMemory = true;
            pl.start((CharSequence)"Loading strings...");
            collection = new LineIterator(new FastBufferedReader((Reader)new InputStreamReader(zipped ? new GZIPInputStream(System.in) : System.in, encoding)), pl).allLines();
            pl.done();
        } else {
            collection = new FileLinesCollection((CharSequence)stringFile, encoding.toString(), zipped);
        }
        TransformationStrategy transformationStrategy = iso ? TransformationStrategies.iso() : (utf32 ? TransformationStrategies.utf32() : TransformationStrategies.utf16());
        BinIO.storeObject(new MinimalPerfectHashFunction(collection, transformationStrategy, signatureWidth, jsapResult.getFile("tempDir"), null), (CharSequence)functionName);
        LOGGER.info("Saved.");
    }

    public static class Builder<T> {
        protected Iterable<? extends T> keys;
        protected TransformationStrategy<? super T> transform;
        protected int signatureWidth;
        protected File tempDir;
        protected ChunkedHashStore<T> chunkedHashStore;
        protected boolean built;

        public Builder<T> keys(Iterable<? extends T> keys) {
            this.keys = keys;
            return this;
        }

        public Builder<T> transform(TransformationStrategy<? super T> transform) {
            this.transform = transform;
            return this;
        }

        public Builder<T> signed(int signatureWidth) {
            this.signatureWidth = signatureWidth;
            return this;
        }

        public Builder<T> tempDir(File tempDir) {
            this.tempDir = tempDir;
            return this;
        }

        public Builder<T> store(ChunkedHashStore<T> chunkedHashStore) {
            this.chunkedHashStore = chunkedHashStore;
            return this;
        }

        public MinimalPerfectHashFunction<T> build() throws IOException {
            if (this.built) {
                throw new IllegalStateException("This builder has been already used");
            }
            this.built = true;
            if (this.transform == null) {
                if (this.chunkedHashStore != null) {
                    this.transform = this.chunkedHashStore.transform();
                } else {
                    throw new IllegalArgumentException("You must specify a TransformationStrategy, either explicitly or via a given ChunkedHashStore");
                }
            }
            return new MinimalPerfectHashFunction<T>(this.keys, this.transform, this.signatureWidth, this.tempDir, this.chunkedHashStore);
        }
    }
}

