/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.mph;

import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.bits.TransformationStrategies;
import it.unimi.dsi.bits.TransformationStrategy;
import it.unimi.dsi.fastutil.Size64;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.longs.LongBigList;
import it.unimi.dsi.fastutil.longs.LongIterable;
import it.unimi.dsi.fastutil.objects.AbstractObject2LongFunction;
import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.fastutil.objects.Object2LongFunction;
import it.unimi.dsi.io.InputBitStream;
import it.unimi.dsi.io.OutputBitStream;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.sux4j.bits.BalancedParentheses;
import it.unimi.dsi.sux4j.mph.HollowTrieMonotoneMinimalPerfectHashFunction;
import it.unimi.dsi.sux4j.mph.MWHCFunction;
import it.unimi.dsi.sux4j.util.EliasFanoLongBigList;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HollowTrieDistributor<T>
extends AbstractObject2LongFunction<T>
implements Size64 {
    private static final Logger LOGGER = LoggerFactory.getLogger(HollowTrieDistributor.class);
    private static final long serialVersionUID = 3L;
    private static final boolean DEBUG = false;
    private static final boolean ASSERTS = false;
    private static final int LEFT = 0;
    private static final int RIGHT = 1;
    private static final int FOLLOW = 2;
    private final TransformationStrategy<? super T> transformationStrategy;
    private final LongArrayBitVector trie;
    private final EliasFanoLongBigList skips;
    private final MWHCFunction<BitVector> externalBehaviour;
    private final long size;
    private final BalancedParentheses balParen;
    private final MWHCFunction<BitVector> falseFollowsDetector;
    protected double meanSkipLength;
    Object2LongFunction<BitVector> externalTestFunction;
    Object2LongFunction<BitVector> falseFollows;

    public HollowTrieDistributor(Iterable<? extends T> elements, int log2BucketSize, TransformationStrategy<? super T> transformationStrategy) throws IOException {
        this(elements, log2BucketSize, transformationStrategy, null);
    }

    public HollowTrieDistributor(final Iterable<? extends T> elements, int log2BucketSize, TransformationStrategy<? super T> transformationStrategy, File tempDir) throws IOException {
        ProgressLogger pl;
        OutputBitStream falseFollowsKeys;
        OutputBitStream externalKeys;
        this.transformationStrategy = transformationStrategy;
        final int bucketSize = 1 << log2BucketSize;
        final long[] count = new long[1];
        HollowTrieMonotoneMinimalPerfectHashFunction<T> intermediateTrie = new HollowTrieMonotoneMinimalPerfectHashFunction<T>(new AbstractObjectIterator<T>(){
            final Iterator<? extends T> iterator;
            boolean toAdvance;
            private T curr;
            {
                this.iterator = elements.iterator();
                this.toAdvance = true;
            }

            public boolean hasNext() {
                if (this.toAdvance) {
                    int i;
                    this.toAdvance = false;
                    for (i = 0; i < bucketSize && this.iterator.hasNext(); ++i) {
                        this.curr = this.iterator.next();
                        count[0] = count[0] + 1L;
                    }
                    if (i != bucketSize) {
                        this.curr = null;
                    }
                }
                return this.curr != null;
            }

            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.toAdvance = true;
                return this.curr;
            }
        }, transformationStrategy);
        this.size = count[0];
        File externalKeysFile = File.createTempFile(HollowTrieDistributor.class.getName(), "ext", tempDir);
        externalKeysFile.deleteOnExit();
        File falseFollowsKeyFile = File.createTempFile(HollowTrieDistributor.class.getName(), "false", tempDir);
        falseFollowsKeyFile.deleteOnExit();
        LongBigList externalValues = LongArrayBitVector.getInstance().asLongBigList(1);
        LongBigList falseFollowsValues = LongArrayBitVector.getInstance().asLongBigList(1);
        long sumOfSkipLengths = 0L;
        if (intermediateTrie.size64() > 0L) {
            externalKeys = new OutputBitStream(externalKeysFile);
            falseFollowsKeys = new OutputBitStream(falseFollowsKeyFile);
            Iterator<T> iterator = elements.iterator();
            LongArrayBitVector[] bucketKey = new LongArrayBitVector[bucketSize];
            LongArrayBitVector rightDelimiter = null;
            long delimiterLcp = -1L;
            this.trie = intermediateTrie.trie;
            this.skips = intermediateTrie.skips;
            this.balParen = intermediateTrie.balParen;
            LongArrayBitVector emitted = LongArrayBitVector.ofLength((long)intermediateTrie.size64());
            pl = new ProgressLogger(LOGGER);
            pl.displayLocalSpeed = true;
            pl.displayFreeMemory = true;
            pl.expectedUpdates = this.size;
            pl.start((CharSequence)"Computing function keys...");
            while (iterator.hasNext()) {
                int realBucketSize;
                for (realBucketSize = 0; realBucketSize < bucketSize && iterator.hasNext(); ++realBucketSize) {
                    bucketKey[realBucketSize] = LongArrayBitVector.copy((BitVector)transformationStrategy.toBitVector(iterator.next()));
                    pl.lightUpdate();
                }
                LongArrayBitVector leftDelimiter = rightDelimiter;
                rightDelimiter = realBucketSize == bucketSize ? bucketKey[bucketSize - 1] : null;
                delimiterLcp = rightDelimiter != null && leftDelimiter != null ? rightDelimiter.longestCommonPrefixLength(leftDelimiter) : -1L;
                long[] stackP = new long[1024];
                long[] stackR = new long[1024];
                int[] stackS = new int[1024];
                long[] stackIndex = new long[1024];
                stackP[0] = 1L;
                int depth = 0;
                long lastNode = -1L;
                BitVector lastPath = null;
                LongArrayBitVector curr = null;
                for (int j = 0; j < realBucketSize; ++j) {
                    int i;
                    boolean isInternal;
                    long maxDescentLength;
                    LongArrayBitVector prev = curr;
                    curr = bucketKey[j];
                    long p = 1L;
                    long length = curr.length();
                    long index = 0L;
                    long r = 0L;
                    int s = 0;
                    int skip = 0;
                    int startPath = -1;
                    int endPath = -1;
                    boolean exitLeft = false;
                    if (prev != null) {
                        int prefix = (int)curr.longestCommonPrefixLength(prev);
                        if ((long)prefix == prev.length() && (long)prefix == curr.length()) {
                            throw new IllegalArgumentException("The input bit vectors are not distinct");
                        }
                        if ((long)prefix == prev.length() || (long)prefix == curr.length()) {
                            throw new IllegalArgumentException("The input bit vectors are not prefix-free");
                        }
                        if (prev.getBoolean(prefix)) {
                            throw new IllegalArgumentException("The input bit vectors are not lexicographically sorted");
                        }
                        while (depth > 0 && stackS[depth] > prefix) {
                            --depth;
                        }
                    }
                    p = stackP[depth];
                    r = stackR[depth];
                    s = stackS[depth];
                    index = stackIndex[depth];
                    if (leftDelimiter == null) {
                        maxDescentLength = rightDelimiter.longestCommonPrefixLength(curr) + 1L;
                        exitLeft = true;
                    } else if (rightDelimiter == null) {
                        maxDescentLength = leftDelimiter.longestCommonPrefixLength(curr) + 1L;
                        exitLeft = false;
                    } else {
                        exitLeft = curr.getBoolean(delimiterLcp);
                        long l = maxDescentLength = exitLeft ? rightDelimiter.longestCommonPrefixLength(curr) + 1L : leftDelimiter.longestCommonPrefixLength(curr) + 1L;
                    }
                    while (true) {
                        if (isInternal = this.trie.getBoolean(p)) {
                            skip = (int)this.skips.getLong(r);
                        }
                        if (isInternal && (long)(s + skip) < maxDescentLength && !emitted.getBoolean(r)) {
                            sumOfSkipLengths += (long)Fast.length((int)(skip + 1));
                            emitted.set(r, true);
                            falseFollowsValues.add(0L);
                            falseFollowsKeys.writeLong(p - 1L, 64);
                            falseFollowsKeys.writeDelta(skip);
                            for (i = 0; i < skip; i += 64) {
                                falseFollowsKeys.writeLong(curr.getLong((long)(s + i), (long)Math.min(s + i + 64, s + skip)), Math.min(64, skip - i));
                            }
                        }
                        if (!isInternal || (long)(s += skip) >= maxDescentLength) break;
                        if (curr.getBoolean(s)) {
                            long q = this.balParen.findClose(p) + 1L;
                            index += (q - p) / 2L;
                            r += (q - p) / 2L;
                            p = q;
                        } else {
                            ++p;
                            ++r;
                        }
                        ++s;
                        if (++depth >= stackP.length) {
                            stackP = LongArrays.grow((long[])stackP, (int)(depth + 1));
                            stackR = LongArrays.grow((long[])stackR, (int)(depth + 1));
                            stackS = IntArrays.grow((int[])stackS, (int)(depth + 1));
                            stackIndex = LongArrays.grow((long[])stackIndex, (int)(depth + 1));
                        }
                        stackP[depth] = p;
                        stackR[depth] = r;
                        stackS[depth] = s;
                        stackIndex[depth] = index;
                    }
                    if (isInternal) {
                        startPath = s - skip;
                        endPath = (int)Math.min(length, (long)s);
                    } else {
                        startPath = s;
                        endPath = (int)length;
                    }
                    if (!isInternal) {
                        lastNode = -1L;
                    }
                    if (lastNode == p - 1L && curr.subVector((long)startPath, (long)endPath).equals(lastPath)) continue;
                    externalValues.add(exitLeft ? 0L : 1L);
                    int pathLength = endPath - startPath;
                    externalKeys.writeLong(p - 1L, 64);
                    externalKeys.writeDelta(pathLength);
                    for (i = 0; i < pathLength; i += 64) {
                        externalKeys.writeLong(curr.getLong((long)(startPath + i), (long)Math.min(startPath + i + 64, endPath)), Math.min(64, endPath - i - startPath));
                    }
                    if (!isInternal) continue;
                    lastPath = curr.subVector((long)startPath, (long)endPath);
                    lastNode = p - 1L;
                    falseFollowsValues.add(1L);
                    falseFollowsKeys.writeLong(p - 1L, 64);
                    falseFollowsKeys.writeDelta(pathLength);
                    for (i = 0; i < pathLength; i += 64) {
                        falseFollowsKeys.writeLong(curr.getLong((long)(startPath + i), (long)Math.min(startPath + i + 64, endPath)), Math.min(64, endPath - i - startPath));
                    }
                }
            }
        } else {
            this.trie = null;
            this.balParen = null;
            this.skips = null;
            this.falseFollowsDetector = null;
            this.externalBehaviour = null;
            return;
        }
        this.meanSkipLength = (double)sumOfSkipLengths / (double)this.size;
        pl.done();
        externalKeys.close();
        falseFollowsKeys.close();
        class IterableStream
        implements Iterable<BitVector> {
            private InputBitStream ibs;
            private long n;
            private Object2LongFunction<BitVector> test;
            private LongBigList values;

            public IterableStream(InputBitStream ibs, Object2LongFunction<BitVector> testFunction, LongBigList testValues) {
                this.ibs = ibs;
                this.n = testValues.size64();
                this.test = testFunction;
                this.values = testValues;
            }

            @Override
            public Iterator<BitVector> iterator() {
                try {
                    this.ibs.position(0L);
                    return new AbstractObjectIterator<BitVector>(){
                        private long pos = 0L;

                        public boolean hasNext() {
                            return this.pos < n;
                        }

                        public BitVector next() {
                            if (!this.hasNext()) {
                                throw new NoSuchElementException();
                            }
                            try {
                                long index = ibs.readLong(64);
                                assert (index >= 0L);
                                int pathLength = ibs.readDelta();
                                long[] key = new long[(pathLength + 64 - 1) / 64 + 1];
                                key[0] = index;
                                for (int i = 0; i < (pathLength + 64 - 1) / 64; ++i) {
                                    key[i + 1] = ibs.readLong(Math.min(64, pathLength - i * 64));
                                }
                                ++this.pos;
                                return LongArrayBitVector.wrap((long[])key, (long)(pathLength + 64));
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    };
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        this.externalBehaviour = new MWHCFunction.Builder<BitVector>().keys(new IterableStream(new InputBitStream(externalKeysFile), this.externalTestFunction, externalValues)).transform((TransformationStrategy<BitVector>)TransformationStrategies.identity()).values((LongIterable)externalValues, 1).build();
        this.falseFollowsDetector = new MWHCFunction.Builder<BitVector>().keys(new IterableStream(new InputBitStream(falseFollowsKeyFile), this.falseFollows, falseFollowsValues)).transform((TransformationStrategy<BitVector>)TransformationStrategies.identity()).values((LongIterable)falseFollowsValues, 1).build();
        LOGGER.debug("False positives: " + (this.falseFollowsDetector.size64() - intermediateTrie.size64()));
        externalKeysFile.delete();
        falseFollowsKeyFile.delete();
    }

    /*
     * Unable to fully structure code
     */
    public long getLong(Object o) {
        if (this.size == 0L) {
            return 0L;
        }
        bitVector = this.transformationStrategy.toBitVector(o).fast();
        key = LongArrayBitVector.getInstance();
        fragment = null;
        p = 1L;
        length = bitVector.length();
        index = 0L;
        r = 0L;
        s = 0;
        skip = 0;
        lastLeftTurn = 0L;
        lastLeftTurnIndex = 0L;
        while (true) {
            if (isInternal = this.trie.getBoolean(p)) {
                skip = (int)this.skips.getLong(r);
            }
            if (!isInternal) ** GOTO lbl-1000
            fragment = bitVector.subVector((long)s, Math.min(length, (long)(s + skip)));
            if (this.falseFollowsDetector.getLong(key.length(0L).append(p - 1L, 64).append(fragment)) == 0L) {
                behaviour = 2;
            } else lbl-1000:
            // 2 sources

            {
                behaviour = (int)this.externalBehaviour.getLong(key.length(0L).append(p - 1L, 64).append(isInternal != false ? fragment : bitVector.subVector((long)s, length)));
            }
            if (behaviour != 2 || !isInternal || (long)(s += skip) >= length) break;
            if (bitVector.getBoolean((long)s)) {
                q = this.balParen.findClose(p) + 1L;
                index += (q - p) / 2L;
                r += (q - p) / 2L;
                p = q;
            } else {
                lastLeftTurn = p++;
                lastLeftTurnIndex = index;
                ++r;
            }
            ++s;
        }
        if (behaviour == 0) {
            return index;
        }
        if (isInternal) {
            q = this.balParen.findClose(lastLeftTurn);
            index = (q - lastLeftTurn + 1L) / 2L + lastLeftTurnIndex;
        } else {
            ++index;
        }
        return index;
    }

    public long numBits() {
        return this.trie.length() + this.skips.numBits() + this.falseFollowsDetector.numBits() + this.balParen.numBits() + this.externalBehaviour.numBits() + this.transformationStrategy.numBits();
    }

    public boolean containsKey(Object o) {
        return true;
    }

    public long size64() {
        return this.size;
    }

    @Deprecated
    public int size() {
        return (int)Math.min(this.size, Integer.MAX_VALUE);
    }

    public double bitsPerSkip() {
        return (double)this.skips.numBits() / (double)this.skips.size64();
    }
}

