/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.mph;

import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.logging.ProgressLogger;

public class Hashes {
    private static final long M = -4132994306676758123L;
    private static final int R = 47;

    private Hashes() {
    }

    public static void jenkins(BitVector bv, long seed, long[] h) {
        long b;
        long length = bv.length();
        long from = 0L;
        if (length == 0L) {
            h[0] = seed ^ 0x8DE6A918D6538324L;
            h[1] = seed ^ 0x6BDA2AEF21654E7DL;
            h[2] = seed ^ 0x36071E726D0BA0C5L;
            return;
        }
        long a = b = seed;
        long c = -7046029254386353133L;
        while (length - from > 128L) {
            a += bv.getLong(from, from + 64L);
            a -= (b += bv.getLong(from + 64L, from + 128L));
            a -= (c += bv.getLong(from + 128L, Math.min(from + 192L, length)));
            b -= c;
            b -= (a ^= c >>> 43);
            c -= a;
            c -= (b ^= a << 9);
            a -= b;
            a -= (c ^= b >>> 8);
            b -= c;
            b -= (a ^= c >>> 38);
            c -= a;
            c -= (b ^= a << 23);
            a -= b;
            a -= (c ^= b >>> 5);
            b -= c;
            b -= (a ^= c >>> 35);
            c -= a;
            c -= (b ^= a << 49);
            a -= b;
            a -= (c ^= b >>> 11);
            b -= c;
            b -= (a ^= c >>> 12);
            c -= a;
            c -= (b ^= a << 18);
            c ^= b >>> 22;
            from += 192L;
        }
        c += length;
        long residual = length - from;
        if (residual > 0L) {
            if (residual > 64L) {
                a += bv.getLong(from, from + 64L);
                residual -= 64L;
            }
            if (residual != 0L) {
                b += bv.getLong(length - residual, length);
            }
        }
        a -= b;
        a -= c;
        b -= c;
        b -= (a ^= c >>> 43);
        c -= a;
        c -= (b ^= a << 9);
        a -= b;
        a -= (c ^= b >>> 8);
        b -= c;
        b -= (a ^= c >>> 38);
        c -= a;
        c -= (b ^= a << 23);
        a -= b;
        a -= (c ^= b >>> 5);
        b -= c;
        b -= (a ^= c >>> 35);
        c -= a;
        c -= (b ^= a << 49);
        a -= b;
        a -= (c ^= b >>> 11);
        b -= c;
        b -= (a ^= c >>> 12);
        c -= a;
        c -= (b ^= a << 18);
        h[0] = a;
        h[1] = b;
        h[2] = c ^= b >>> 22;
    }

    public static long jenkins(BitVector bv, long seed) {
        long b;
        long length = bv.length();
        long from = 0L;
        if (length == 0L) {
            return seed ^ 0x36071E726D0BA0C5L;
        }
        long a = b = seed;
        long c = -7046029254386353133L;
        while (length - from > 128L) {
            a += bv.getLong(from, from + 64L);
            a -= (b += bv.getLong(from + 64L, from + 128L));
            a -= (c += bv.getLong(from + 128L, Math.min(from + 192L, length)));
            b -= c;
            b -= (a ^= c >>> 43);
            c -= a;
            c -= (b ^= a << 9);
            a -= b;
            a -= (c ^= b >>> 8);
            b -= c;
            b -= (a ^= c >>> 38);
            c -= a;
            c -= (b ^= a << 23);
            a -= b;
            a -= (c ^= b >>> 5);
            b -= c;
            b -= (a ^= c >>> 35);
            c -= a;
            c -= (b ^= a << 49);
            a -= b;
            a -= (c ^= b >>> 11);
            b -= c;
            b -= (a ^= c >>> 12);
            c -= a;
            c -= (b ^= a << 18);
            c ^= b >>> 22;
            from += 192L;
        }
        c += length;
        long residual = length - from;
        if (residual > 0L) {
            if (residual > 64L) {
                a += bv.getLong(from, from + 64L);
                residual -= 64L;
            }
            if (residual != 0L) {
                b += bv.getLong(length - residual, length);
            }
        }
        a -= b;
        a -= c;
        b -= c;
        b -= (a ^= c >>> 43);
        c -= a;
        c -= (b ^= a << 9);
        a -= b;
        a -= (c ^= b >>> 8);
        b -= c;
        b -= (a ^= c >>> 38);
        c -= a;
        c -= (b ^= a << 23);
        a -= b;
        a -= (c ^= b >>> 5);
        b -= c;
        b -= (a ^= c >>> 35);
        c -= a;
        c -= (b ^= a << 49);
        a -= b;
        a -= (c ^= b >>> 11);
        b -= c;
        b -= (a ^= c >>> 12);
        c -= a;
        c -= (b ^= a << 18);
        return c ^= b >>> 22;
    }

    public static long jenkins(BitVector bv) {
        return Hashes.jenkins(bv, 0L);
    }

    public static long[][] preprocessJenkins(BitVector bv, long seed) {
        long b;
        long length = bv.length();
        int wordLength = (int)(length / 192L) + 1;
        long[] aa = new long[wordLength];
        long[] bb = new long[wordLength];
        long[] cc = new long[wordLength];
        long from = 0L;
        if (aa.length == 0) {
            return new long[3][0];
        }
        int i = 0;
        long a = b = seed;
        long c = -7046029254386353133L;
        aa[i] = a;
        bb[i] = b;
        cc[i] = c;
        ++i;
        while (length - from >= 192L) {
            a += bv.getLong(from, from + 64L);
            a -= (b += bv.getLong(from + 64L, from + 128L));
            a -= (c += bv.getLong(from + 128L, from + 192L));
            b -= c;
            b -= (a ^= c >>> 43);
            c -= a;
            c -= (b ^= a << 9);
            a -= b;
            a -= (c ^= b >>> 8);
            b -= c;
            b -= (a ^= c >>> 38);
            c -= a;
            c -= (b ^= a << 23);
            a -= b;
            a -= (c ^= b >>> 5);
            b -= c;
            b -= (a ^= c >>> 35);
            c -= a;
            c -= (b ^= a << 49);
            a -= b;
            a -= (c ^= b >>> 11);
            b -= c;
            b -= (a ^= c >>> 12);
            c -= a;
            c -= (b ^= a << 18);
            from += 192L;
            aa[i] = a;
            bb[i] = b;
            cc[i] = c ^= b >>> 22;
            ++i;
        }
        return new long[][]{aa, bb, cc};
    }

    public static void jenkins(BitVector bv, long prefixLength, long[] aa, long[] bb, long[] cc, long[] h) {
        if (prefixLength == 0L) {
            long seed = aa[0];
            h[0] = seed ^ 0x8DE6A918D6538324L;
            h[1] = seed ^ 0x6BDA2AEF21654E7DL;
            h[2] = seed ^ 0x36071E726D0BA0C5L;
            return;
        }
        int stateOffset = (int)(prefixLength / 192L);
        long from = stateOffset * 3 * 64;
        long a = aa[stateOffset];
        long b = bb[stateOffset];
        long c = cc[stateOffset];
        if (prefixLength - from > 128L) {
            a += bv.getLong(from, from + 64L);
            a -= (b += bv.getLong(from + 64L, from + 128L));
            a -= (c += bv.getLong(from + 128L, Math.min(from + 192L, prefixLength)));
            b -= c;
            b -= (a ^= c >>> 43);
            c -= a;
            c -= (b ^= a << 9);
            a -= b;
            a -= (c ^= b >>> 8);
            b -= c;
            b -= (a ^= c >>> 38);
            c -= a;
            c -= (b ^= a << 23);
            a -= b;
            a -= (c ^= b >>> 5);
            b -= c;
            b -= (a ^= c >>> 35);
            c -= a;
            c -= (b ^= a << 49);
            a -= b;
            a -= (c ^= b >>> 11);
            b -= c;
            b -= (a ^= c >>> 12);
            c -= a;
            c -= (b ^= a << 18);
            c ^= b >>> 22;
            from += 192L;
        }
        c += prefixLength;
        long residual = prefixLength - from;
        if (residual > 0L) {
            if (residual > 64L) {
                a += bv.getLong(from, from + 64L);
                residual -= 64L;
            }
            if (residual != 0L) {
                b += bv.getLong(prefixLength - residual, prefixLength);
            }
        }
        a -= b;
        a -= c;
        b -= c;
        b -= (a ^= c >>> 43);
        c -= a;
        c -= (b ^= a << 9);
        a -= b;
        a -= (c ^= b >>> 8);
        b -= c;
        b -= (a ^= c >>> 38);
        c -= a;
        c -= (b ^= a << 23);
        a -= b;
        a -= (c ^= b >>> 5);
        b -= c;
        b -= (a ^= c >>> 35);
        c -= a;
        c -= (b ^= a << 49);
        a -= b;
        a -= (c ^= b >>> 11);
        b -= c;
        b -= (a ^= c >>> 12);
        c -= a;
        c -= (b ^= a << 18);
        h[0] = a;
        h[1] = b;
        h[2] = c ^= b >>> 22;
    }

    public static long jenkins(BitVector bv, long prefixLength, long[] aa, long[] bb, long[] cc) {
        if (prefixLength == 0L) {
            return aa[0] ^ 0x36071E726D0BA0C5L;
        }
        int stateOffset = (int)(prefixLength / 192L);
        long from = stateOffset * 3 * 64;
        long a = aa[stateOffset];
        long b = bb[stateOffset];
        long c = cc[stateOffset];
        if (prefixLength - from > 128L) {
            a += bv.getLong(from, from + 64L);
            a -= (b += bv.getLong(from + 64L, from + 128L));
            a -= (c += bv.getLong(from + 128L, Math.min(from + 192L, prefixLength)));
            b -= c;
            b -= (a ^= c >>> 43);
            c -= a;
            c -= (b ^= a << 9);
            a -= b;
            a -= (c ^= b >>> 8);
            b -= c;
            b -= (a ^= c >>> 38);
            c -= a;
            c -= (b ^= a << 23);
            a -= b;
            a -= (c ^= b >>> 5);
            b -= c;
            b -= (a ^= c >>> 35);
            c -= a;
            c -= (b ^= a << 49);
            a -= b;
            a -= (c ^= b >>> 11);
            b -= c;
            b -= (a ^= c >>> 12);
            c -= a;
            c -= (b ^= a << 18);
            c ^= b >>> 22;
            from += 192L;
        }
        c += prefixLength;
        long residual = prefixLength - from;
        if (residual > 0L) {
            if (residual > 64L) {
                a += bv.getLong(from, from + 64L);
                residual -= 64L;
            }
            if (residual != 0L) {
                b += bv.getLong(prefixLength - residual, prefixLength);
            }
        }
        a -= b;
        a -= c;
        b -= c;
        b -= (a ^= c >>> 43);
        c -= a;
        c -= (b ^= a << 9);
        a -= b;
        a -= (c ^= b >>> 8);
        b -= c;
        b -= (a ^= c >>> 38);
        c -= a;
        c -= (b ^= a << 23);
        a -= b;
        a -= (c ^= b >>> 5);
        b -= c;
        b -= (a ^= c >>> 35);
        c -= a;
        c -= (b ^= a << 49);
        a -= b;
        a -= (c ^= b >>> 11);
        b -= c;
        b -= (a ^= c >>> 12);
        c -= a;
        c -= (b ^= a << 18);
        return c ^= b >>> 22;
    }

    public static void jenkins(long[] triple, long seed, long[] h) {
        long b;
        long a = b = seed;
        long c = -7046029254386353133L;
        a += triple[0];
        a -= (b += triple[1]);
        a -= (c += triple[2]);
        b -= c;
        b -= (a ^= c >>> 43);
        c -= a;
        c -= (b ^= a << 9);
        a -= b;
        a -= (c ^= b >>> 8);
        b -= c;
        b -= (a ^= c >>> 38);
        c -= a;
        c -= (b ^= a << 23);
        a -= b;
        a -= (c ^= b >>> 5);
        b -= c;
        b -= (a ^= c >>> 35);
        c -= a;
        c -= (b ^= a << 49);
        a -= b;
        a -= (c ^= b >>> 11);
        b -= c;
        b -= (a ^= c >>> 12);
        c -= a;
        c -= (b ^= a << 18);
        h[0] = a;
        h[1] = b;
        h[2] = c ^= b >>> 22;
    }

    public static long murmur(BitVector bv, long seed) {
        long k;
        long h = seed;
        long from = 0L;
        long length = bv.length();
        while (length - from >= 64L) {
            k = bv.getLong(from, from += 64L);
            k *= -4132994306676758123L;
            k ^= k >>> 47;
            h ^= (k *= -4132994306676758123L);
            h *= -4132994306676758123L;
        }
        if (length > from) {
            k = bv.getLong(from, length);
            k *= -4132994306676758123L;
            k ^= k >>> 47;
            h ^= (k *= -4132994306676758123L);
            h *= -4132994306676758123L;
        }
        k = length;
        k *= -4132994306676758123L;
        k ^= k >>> 47;
        h ^= (k *= -4132994306676758123L);
        return h *= -4132994306676758123L;
    }

    public static long murmur(BitVector bv, long prefixLength, long[] state) {
        long k;
        long precomputedUpTo = prefixLength - prefixLength % 64L;
        long h = state[(int)(precomputedUpTo / 64L)];
        if (prefixLength > precomputedUpTo) {
            k = bv.getLong(precomputedUpTo, prefixLength);
            k *= -4132994306676758123L;
            k ^= k >>> 47;
            h ^= (k *= -4132994306676758123L);
            h *= -4132994306676758123L;
        }
        k = prefixLength;
        k *= -4132994306676758123L;
        k ^= k >>> 47;
        h ^= (k *= -4132994306676758123L);
        return h *= -4132994306676758123L;
    }

    public static long murmur(BitVector bv, long prefixLength, long[] state, long lcp) {
        long k;
        int startStateWord = (int)(Math.min(lcp, prefixLength) / 64L);
        long h = state[startStateWord];
        long from = startStateWord * 64;
        while (prefixLength - from >= 64L) {
            k = bv.getLong(from, from += 64L);
            k *= -4132994306676758123L;
            k ^= k >>> 47;
            h ^= (k *= -4132994306676758123L);
            h *= -4132994306676758123L;
        }
        if (prefixLength > from) {
            k = bv.getLong(from, prefixLength);
            k *= -4132994306676758123L;
            k ^= k >>> 47;
            h ^= (k *= -4132994306676758123L);
            h *= -4132994306676758123L;
        }
        k = prefixLength;
        k *= -4132994306676758123L;
        k ^= k >>> 47;
        h ^= (k *= -4132994306676758123L);
        return h *= -4132994306676758123L;
    }

    public static long[] preprocessMurmur(BitVector bv, long seed) {
        long h = seed;
        long from = 0L;
        long length = bv.length();
        int wordLength = (int)(length / 64L);
        long[] state = new long[wordLength + 1];
        int i = 0;
        state[i++] = h;
        while (length - from >= 64L) {
            long k = bv.getLong(from, from += 64L);
            k *= -4132994306676758123L;
            k ^= k >>> 47;
            h ^= (k *= -4132994306676758123L);
            state[i] = h *= -4132994306676758123L;
            ++i;
        }
        return state;
    }

    private static final long finalizeMurmur3(long x) {
        x ^= x >>> 33;
        x *= -49064778989728563L;
        x ^= x >>> 33;
        x *= -4265267296055464877L;
        x ^= x >>> 33;
        return x;
    }

    public static void murmur3(BitVector bv, long seed, long[] h) {
        long k2;
        long k1;
        long h1 = 0x9368E53C2F6AF274L ^ seed;
        long h2 = 0x586DCD208F7CD3FDL ^ seed;
        long c1 = -8663945395140668459L;
        long c2 = 5545529020109919103L;
        long from = 0L;
        long length = bv.length();
        while (length - from >= 128L) {
            k1 = bv.getLong(from, from += 64L);
            k2 = bv.getLong(from, from += 64L);
            k1 *= c1;
            k1 = k1 << 23 | k1 >>> 41;
            h1 ^= (k1 *= c2);
            h1 += h2;
            h2 = h2 << 41 | h2 >>> 23;
            k2 *= c2;
            k2 = k2 << 23 | k2 >>> 41;
            h2 ^= (k2 *= c1);
            h2 += h1;
            h1 = h1 * 3L + 1390208809L;
            h2 = h2 * 3L + 944331445L;
            c1 = c1 * 5L + 2071795100L;
            c2 = c2 * 5L + 1808688022L;
        }
        if (length > from) {
            if (length - from > 64L) {
                k1 = bv.getLong(from, from += 64L);
                k2 = bv.getLong(from, length);
            } else {
                k1 = bv.getLong(from, length);
                k2 = 0L;
            }
            k1 *= c1;
            k1 = k1 << 23 | k1 >>> 41;
            h1 ^= (k1 *= c2);
            h1 += h2;
            h2 = h2 << 41 | h2 >>> 23;
            k2 *= c2;
            k2 = k2 << 23 | k2 >>> 41;
            h2 ^= (k2 *= c1);
            h2 += h1;
            h1 = h1 * 3L + 1390208809L;
            h2 = h2 * 3L + 944331445L;
            c1 = c1 * 5L + 2071795100L;
            c2 = c2 * 5L + 1808688022L;
        }
        h1 += (h2 ^= length);
        h2 += h1;
        h1 = Hashes.finalizeMurmur3(h1);
        h2 = Hashes.finalizeMurmur3(h2);
        h1 += h2;
        h[0] = h1;
        h[1] = h2 += h1;
    }

    public static long murmur3(BitVector bv, long seed) {
        long k2;
        long k1;
        long h1 = 0x9368E53C2F6AF274L ^ seed;
        long h2 = 0x586DCD208F7CD3FDL ^ seed;
        long c1 = -8663945395140668459L;
        long c2 = 5545529020109919103L;
        long from = 0L;
        long length = bv.length();
        while (length - from >= 128L) {
            k1 = bv.getLong(from, from += 64L);
            k2 = bv.getLong(from, from += 64L);
            k1 *= c1;
            k1 = k1 << 23 | k1 >>> 41;
            h1 ^= (k1 *= c2);
            h1 += h2;
            h2 = h2 << 41 | h2 >>> 23;
            k2 *= c2;
            k2 = k2 << 23 | k2 >>> 41;
            h2 ^= (k2 *= c1);
            h2 += h1;
            h1 = h1 * 3L + 1390208809L;
            h2 = h2 * 3L + 944331445L;
            c1 = c1 * 5L + 2071795100L;
            c2 = c2 * 5L + 1808688022L;
        }
        if (length > from) {
            if (length - from > 64L) {
                k1 = bv.getLong(from, from += 64L);
                k2 = bv.getLong(from, length);
            } else {
                k1 = bv.getLong(from, length);
                k2 = 0L;
            }
            k1 *= c1;
            k1 = k1 << 23 | k1 >>> 41;
            h1 ^= (k1 *= c2);
            h1 += h2;
            h2 = h2 << 41 | h2 >>> 23;
            k2 *= c2;
            k2 = k2 << 23 | k2 >>> 41;
            h2 ^= (k2 *= c1);
            h2 += h1;
            h1 = h1 * 3L + 1390208809L;
            h2 = h2 * 3L + 944331445L;
            c1 = c1 * 5L + 2071795100L;
            c2 = c2 * 5L + 1808688022L;
        }
        h1 += (h2 ^= length);
        h2 += h1;
        h1 = Hashes.finalizeMurmur3(h1);
        h2 = Hashes.finalizeMurmur3(h2);
        return h1 + h2;
    }

    public static void murmur3(BitVector bv, long prefixLength, long[] hh1, long[] hh2, long[] cc1, long[] cc2, long[] h) {
        int startStateWord = (int)(prefixLength / 128L);
        long precomputedUpTo = (long)startStateWord * 2L * 64L;
        long h1 = hh1[startStateWord];
        long h2 = hh2[startStateWord];
        long c1 = cc1[startStateWord];
        long c2 = cc2[startStateWord];
        if (prefixLength > precomputedUpTo) {
            long k2;
            long k1;
            if (prefixLength - precomputedUpTo > 64L) {
                k1 = bv.getLong(precomputedUpTo, precomputedUpTo += 64L);
                k2 = bv.getLong(precomputedUpTo, prefixLength);
            } else {
                k1 = bv.getLong(precomputedUpTo, prefixLength);
                k2 = 0L;
            }
            k1 *= c1;
            k1 = k1 << 23 | k1 >>> 41;
            h1 ^= (k1 *= c2);
            h1 += h2;
            h2 = h2 << 41 | h2 >>> 23;
            k2 *= c2;
            k2 = k2 << 23 | k2 >>> 41;
            h2 ^= (k2 *= c1);
            h2 += h1;
            h1 = h1 * 3L + 1390208809L;
            h2 = h2 * 3L + 944331445L;
            c1 = c1 * 5L + 2071795100L;
            c2 = c2 * 5L + 1808688022L;
        }
        h1 += (h2 ^= prefixLength);
        h2 += h1;
        h1 = Hashes.finalizeMurmur3(h1);
        h2 = Hashes.finalizeMurmur3(h2);
        h1 += h2;
        h[0] = h1;
        h[1] = h2 += h1;
    }

    public static long murmur3(BitVector bv, long prefixLength, long[] hh1, long[] hh2, long[] cc1, long[] cc2) {
        int startStateWord = (int)(prefixLength / 128L);
        long precomputedUpTo = (long)startStateWord * 2L * 64L;
        long h1 = hh1[startStateWord];
        long h2 = hh2[startStateWord];
        long c1 = cc1[startStateWord];
        long c2 = cc2[startStateWord];
        if (prefixLength > precomputedUpTo) {
            long k2;
            long k1;
            if (prefixLength - precomputedUpTo > 64L) {
                k1 = bv.getLong(precomputedUpTo, precomputedUpTo += 64L);
                k2 = bv.getLong(precomputedUpTo, prefixLength);
            } else {
                k1 = bv.getLong(precomputedUpTo, prefixLength);
                k2 = 0L;
            }
            k1 *= c1;
            k1 = k1 << 23 | k1 >>> 41;
            h1 ^= (k1 *= c2);
            h1 += h2;
            h2 = h2 << 41 | h2 >>> 23;
            k2 *= c2;
            k2 = k2 << 23 | k2 >>> 41;
            h2 ^= (k2 *= c1);
            h2 += h1;
            h1 = h1 * 3L + 1390208809L;
            h2 = h2 * 3L + 944331445L;
            c1 = c1 * 5L + 2071795100L;
            c2 = c2 * 5L + 1808688022L;
        }
        h1 += (h2 ^= prefixLength);
        h2 += h1;
        h1 = Hashes.finalizeMurmur3(h1);
        h2 = Hashes.finalizeMurmur3(h2);
        return h1 + h2;
    }

    public static void murmur3(BitVector bv, long prefixLength, long[] hh1, long[] hh2, long[] cc1, long[] cc2, long lcp, long[] h) {
        long k2;
        long k1;
        int startStateWord = (int)(Math.min(lcp, prefixLength) / 128L);
        long from = (long)startStateWord * 2L * 64L;
        long h1 = hh1[startStateWord];
        long h2 = hh2[startStateWord];
        long c1 = cc1[startStateWord];
        long c2 = cc2[startStateWord];
        while (prefixLength - from >= 128L) {
            k1 = bv.getLong(from, from += 64L);
            k2 = bv.getLong(from, from += 64L);
            k1 *= c1;
            k1 = k1 << 23 | k1 >>> 41;
            h1 ^= (k1 *= c2);
            h1 += h2;
            h2 = h2 << 41 | h2 >>> 23;
            k2 *= c2;
            k2 = k2 << 23 | k2 >>> 41;
            h2 ^= (k2 *= c1);
            h2 += h1;
            h1 = h1 * 3L + 1390208809L;
            h2 = h2 * 3L + 944331445L;
            c1 = c1 * 5L + 2071795100L;
            c2 = c2 * 5L + 1808688022L;
        }
        if (prefixLength - from != 0L) {
            if (prefixLength - from > 64L) {
                k1 = bv.getLong(from, from += 64L);
                k2 = bv.getLong(from, prefixLength);
            } else {
                k1 = bv.getLong(from, prefixLength);
                k2 = 0L;
            }
            k1 *= c1;
            k1 = k1 << 23 | k1 >>> 41;
            h1 ^= (k1 *= c2);
            h1 += h2;
            h2 = h2 << 41 | h2 >>> 23;
            k2 *= c2;
            k2 = k2 << 23 | k2 >>> 41;
            h2 ^= (k2 *= c1);
            h2 += h1;
            h1 = h1 * 3L + 1390208809L;
            h2 = h2 * 3L + 944331445L;
            c1 = c1 * 5L + 2071795100L;
            c2 = c2 * 5L + 1808688022L;
        }
        h1 += (h2 ^= prefixLength);
        h2 += h1;
        h1 = Hashes.finalizeMurmur3(h1);
        h2 = Hashes.finalizeMurmur3(h2);
        h1 += h2;
        h[0] = h1;
        h[1] = h2 += h1;
    }

    public static long murmur3(BitVector bv, long prefixLength, long[] hh1, long[] hh2, long[] cc1, long[] cc2, long lcp) {
        long k2;
        long k1;
        int startStateWord = (int)(Math.min(lcp, prefixLength) / 128L);
        long from = (long)startStateWord * 2L * 64L;
        long h1 = hh1[startStateWord];
        long h2 = hh2[startStateWord];
        long c1 = cc1[startStateWord];
        long c2 = cc2[startStateWord];
        while (prefixLength - from >= 128L) {
            k1 = bv.getLong(from, from += 64L);
            k2 = bv.getLong(from, from += 64L);
            k1 *= c1;
            k1 = k1 << 23 | k1 >>> 41;
            h1 ^= (k1 *= c2);
            h1 += h2;
            h2 = h2 << 41 | h2 >>> 23;
            k2 *= c2;
            k2 = k2 << 23 | k2 >>> 41;
            h2 ^= (k2 *= c1);
            h2 += h1;
            h1 = h1 * 3L + 1390208809L;
            h2 = h2 * 3L + 944331445L;
            c1 = c1 * 5L + 2071795100L;
            c2 = c2 * 5L + 1808688022L;
        }
        if (prefixLength - from != 0L) {
            if (prefixLength - from > 64L) {
                k1 = bv.getLong(from, from += 64L);
                k2 = bv.getLong(from, prefixLength);
            } else {
                k1 = bv.getLong(from, prefixLength);
                k2 = 0L;
            }
            k1 *= c1;
            k1 = k1 << 23 | k1 >>> 41;
            h1 ^= (k1 *= c2);
            h1 += h2;
            h2 = h2 << 41 | h2 >>> 23;
            k2 *= c2;
            k2 = k2 << 23 | k2 >>> 41;
            h2 ^= (k2 *= c1);
            h2 += h1;
            h1 = h1 * 3L + 1390208809L;
            h2 = h2 * 3L + 944331445L;
            c1 = c1 * 5L + 2071795100L;
            c2 = c2 * 5L + 1808688022L;
        }
        h1 += (h2 ^= prefixLength);
        h2 += h1;
        h1 = Hashes.finalizeMurmur3(h1);
        h2 = Hashes.finalizeMurmur3(h2);
        return h1 + h2;
    }

    public static long[][] preprocessMurmur3(BitVector bv, long seed) {
        long from = 0L;
        long length = bv.length();
        long h1 = 0x9368E53C2F6AF274L ^ seed;
        long h2 = 0x586DCD208F7CD3FDL ^ seed;
        long c1 = -8663945395140668459L;
        long c2 = 5545529020109919103L;
        int wordLength = (int)(length / 128L);
        long[][] state = new long[4][wordLength + 1];
        int i = 0;
        state[0][i] = h1;
        state[1][i] = h2;
        state[2][i] = c1;
        state[3][i] = c2;
        ++i;
        while (length - from >= 128L) {
            long k1 = bv.getLong(from, from += 64L);
            long k2 = bv.getLong(from, from += 64L);
            k1 *= c1;
            k1 = k1 << 23 | k1 >>> 41;
            h1 ^= (k1 *= c2);
            h1 += h2;
            h2 = h2 << 41 | h2 >>> 23;
            k2 *= c2;
            k2 = k2 << 23 | k2 >>> 41;
            h2 ^= (k2 *= c1);
            h2 += h1;
            h1 = h1 * 3L + 1390208809L;
            h2 = h2 * 3L + 944331445L;
            c1 = c1 * 5L + 2071795100L;
            c2 = c2 * 5L + 1808688022L;
            state[0][i] = h1;
            state[1][i] = h2;
            state[2][i] = c1;
            state[3][i] = c2;
            ++i;
        }
        return state;
    }

    public static void main(String[] arg) {
        int l = Integer.parseInt(arg[0]);
        int n = Integer.parseInt(arg[1]);
        LongArrayBitVector bv = LongArrayBitVector.ofLength((long)l);
        ProgressLogger pl = new ProgressLogger();
        long t = 0L;
        int k = 4;
        while (k-- != 0) {
            pl.start((CharSequence)"Timing MurmurHash...");
            int i = n;
            while (i-- != 0) {
                t += Hashes.murmur((BitVector)bv, 0L);
            }
            if (t == 0L) {
                System.err.println(t);
            }
            pl.done((long)n);
            pl.start((CharSequence)"Timing MurmurHash3...");
            long[] h = new long[3];
            int i2 = n;
            while (i2-- != 0) {
                Hashes.murmur3((BitVector)bv, 0L, h);
                t += h[0];
            }
            if (t == 0L) {
                System.err.println(t);
            }
            pl.done((long)n);
            pl.start((CharSequence)"Timing Jenkins's hash...");
            i2 = n;
            while (i2-- != 0) {
                Hashes.jenkins((BitVector)bv, 0L, h);
                t += h[0];
            }
            if (t == 0L) {
                System.err.println(t);
            }
            pl.done((long)n);
            long[] preprocessMurmur = Hashes.preprocessMurmur((BitVector)bv, 0L);
            pl.start((CharSequence)"Timing preprocessed MurmurHash...");
            int i3 = n;
            while (i3-- != 0) {
                t += Hashes.murmur((BitVector)bv, l - 1, preprocessMurmur);
            }
            if (t == 0L) {
                System.err.println(t);
            }
            pl.done((long)n);
            long[][] preprocessMurmur3 = Hashes.preprocessMurmur3((BitVector)bv, 0L);
            long[] hh1 = preprocessMurmur3[0];
            long[] hh2 = preprocessMurmur3[1];
            long[] cc1 = preprocessMurmur3[2];
            long[] cc2 = preprocessMurmur3[3];
            pl.start((CharSequence)"Timing preprocessed MurmurHash3...");
            int i4 = n;
            while (i4-- != 0) {
                t += Hashes.murmur3((BitVector)bv, l - 1, hh1, hh2, cc1, cc2);
            }
            if (t == 0L) {
                System.err.println(t);
            }
            pl.done((long)n);
            long[][] preprocessJenkins = Hashes.preprocessJenkins((BitVector)bv, 0L);
            long[] aa = preprocessJenkins[0];
            long[] bb = preprocessJenkins[1];
            long[] cc = preprocessJenkins[2];
            pl.start((CharSequence)"Timing preprocessed Jenkins's hash...");
            int i5 = n;
            while (i5-- != 0) {
                t += Hashes.jenkins((BitVector)bv, l - 1, aa, bb, cc);
            }
            if (t == 0L) {
                System.err.println(t);
            }
            pl.done((long)n);
        }
    }
}

