/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.io;

import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import it.unimi.dsi.fastutil.longs.AbstractLongIterator;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectList;
import it.unimi.dsi.fastutil.objects.AbstractObjectListIterator;
import it.unimi.dsi.io.SafelyCloseable;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.sux4j.util.EliasFanoMonotoneLongBigList;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public class FileLinesList
extends AbstractObjectList<MutableString>
implements RandomAccess,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String filename;
    private final int size;
    private final int bufferSize;
    private final EnumSet<FastBufferedInputStream.LineTerminator> terminators;
    private final ByteBuffer byteBuffer;
    private final CharBuffer charBuffer;
    private final EliasFanoMonotoneLongBigList borders;
    private final FastBufferedInputStream inputStream;
    private final CharsetDecoder decoder;
    private final Charset charset;

    public FileLinesList(CharSequence filename, String encoding, int bufferSize, final EnumSet<FastBufferedInputStream.LineTerminator> terminators) throws IOException {
        this.bufferSize = bufferSize;
        this.terminators = terminators;
        this.filename = filename.toString();
        this.inputStream = new FastBufferedInputStream((InputStream)new FileInputStream(this.filename), bufferSize);
        this.charset = Charset.forName(encoding);
        this.decoder = this.charset.newDecoder();
        byte[] array = new byte[16];
        int count = 0;
        while (true) {
            int len;
            int start = 0;
            while ((len = this.inputStream.readLine(array, start, array.length - start, terminators)) == array.length - start) {
                start += len;
                array = ByteArrays.grow((byte[])array, (int)(array.length + 1));
            }
            if (len == -1) break;
            ++count;
        }
        this.size = count;
        this.byteBuffer = ByteBuffer.wrap(array);
        this.charBuffer = CharBuffer.wrap(new char[array.length]);
        this.inputStream.position(0L);
        this.borders = new EliasFanoMonotoneLongBigList((long)count, this.inputStream.length(), (LongIterator)new AbstractLongIterator(){
            long pos = 0L;
            byte[] buffer = FileLinesList.access$000(FileLinesList.this).array();

            public boolean hasNext() {
                return this.pos < (long)FileLinesList.this.size;
            }

            public long nextLong() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ++this.pos;
                try {
                    long result = FileLinesList.this.inputStream.position();
                    FileLinesList.this.inputStream.readLine(this.buffer, terminators);
                    return result;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public FileLinesList(CharSequence filename, String encoding, int bufferSize) throws IOException {
        this(filename, encoding, bufferSize, FastBufferedInputStream.ALL_TERMINATORS);
    }

    public FileLinesList(CharSequence filename, String encoding) throws IOException {
        this(filename, encoding, 8192);
    }

    public int size() {
        return this.size;
    }

    public MutableString get(int index) {
        return this.get(index, this.inputStream, this.byteBuffer, this.charBuffer, this.decoder);
    }

    public MutableString get(int index, FastBufferedInputStream fastBufferedInputStream, ByteBuffer byteBuffer, CharBuffer charBuffer, CharsetDecoder decoder) {
        try {
            fastBufferedInputStream.position(this.borders.getLong(index));
            byteBuffer.clear();
            byteBuffer.limit(fastBufferedInputStream.readLine(byteBuffer.array(), this.terminators));
            charBuffer.clear();
            decoder.decode(byteBuffer, charBuffer, true);
            return new MutableString(charBuffer.array(), 0, charBuffer.position());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public FileLinesIterator listIterator(int index) {
        try {
            return new FileLinesIterator(this, index, new FastBufferedInputStream((InputStream)new FileInputStream(this.filename), this.bufferSize), this.charset.newDecoder(), ByteBuffer.wrap(new byte[this.byteBuffer.array().length]), CharBuffer.wrap(new char[this.charBuffer.array().length]));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        MutableString separator = new MutableString(System.getProperty("line.separator"));
        MutableString s = new MutableString();
        Iterator i$ = this.iterator();
        while (i$.hasNext()) {
            MutableString l = (MutableString)i$.next();
            s.append(l).append(separator);
        }
        return s.toString();
    }

    static /* synthetic */ ByteBuffer access$000(FileLinesList x0) {
        return x0.byteBuffer;
    }

    public static final class FileLinesIterator
    extends AbstractObjectListIterator<MutableString>
    implements SafelyCloseable {
        private FastBufferedInputStream inputStream;
        private final ByteBuffer byteBuffer;
        private final CharBuffer charBuffer;
        private final CharsetDecoder decoder;
        private final FileLinesList fileLinesList;
        private int pos;

        protected FileLinesIterator(FileLinesList fileLinesList, int index, FastBufferedInputStream inputStream, CharsetDecoder decoder, ByteBuffer byteBuffer, CharBuffer charBuffer) {
            this.inputStream = inputStream;
            this.decoder = decoder;
            this.byteBuffer = byteBuffer;
            this.charBuffer = charBuffer;
            this.fileLinesList = fileLinesList;
            this.pos = index;
        }

        public boolean hasNext() {
            return this.pos < this.fileLinesList.size;
        }

        public boolean hasPrevious() {
            return this.pos > 0;
        }

        public MutableString next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.fileLinesList.get(this.pos++, this.inputStream, this.byteBuffer, this.charBuffer, this.decoder);
        }

        public MutableString previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return this.fileLinesList.get(--this.pos, this.inputStream, this.byteBuffer, this.charBuffer, this.decoder);
        }

        public int nextIndex() {
            return this.pos;
        }

        public int previousIndex() {
            return this.pos - 1;
        }

        public synchronized void close() {
            if (this.inputStream == null) {
                throw new IllegalStateException();
            }
            try {
                this.inputStream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.inputStream = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized void finalize() throws Throwable {
            try {
                if (this.inputStream != null) {
                    this.close();
                }
            }
            finally {
                super.finalize();
            }
        }
    }
}

