/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.io;

import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.bits.TransformationStrategy;
import it.unimi.dsi.fastutil.Swapper;
import it.unimi.dsi.fastutil.ints.AbstractIntComparator;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import it.unimi.dsi.fastutil.longs.LongBigList;
import it.unimi.dsi.fastutil.longs.LongIterable;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.io.SafelyCloseable;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.sux4j.mph.Hashes;
import it.unimi.dsi.util.XorShift1024StarRandomGenerator;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.iterators.IteratorEnumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkedHashStore<T>
implements Serializable,
SafelyCloseable,
Iterable<Chunk> {
    public static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ChunkedHashStore.class);
    private static final boolean DEBUG = false;
    public static final int OUTPUT_BUFFER_SIZE = 32768;
    public static final int LOG2_DISK_CHUNKS = 8;
    public static final int DISK_CHUNKS = 256;
    public static final int DISK_CHUNKS_SHIFT = 56;
    protected long size;
    protected long filteredSize;
    protected long seed;
    private int[] count;
    private long chunks;
    private File[] file;
    private int diskChunkStep;
    private int chunkShift;
    private boolean checkedForDuplicates;
    private final TransformationStrategy<? super T> transform;
    private final ProgressLogger pl;
    private final long hashMask;
    private DataOutputStream[] dos;
    private int virtualDiskChunks;
    private Predicate filter;
    private boolean locked;
    private boolean closed;

    public ChunkedHashStore(TransformationStrategy<? super T> transform) throws IOException {
        this(transform, null, null);
    }

    public ChunkedHashStore(TransformationStrategy<? super T> transform, File tempDir) throws IOException {
        this(transform, tempDir, null);
    }

    public ChunkedHashStore(TransformationStrategy<? super T> transform, ProgressLogger pl) throws IOException {
        this(transform, null, pl);
    }

    public ChunkedHashStore(TransformationStrategy<? super T> transform, File tempDir, ProgressLogger pl) throws IOException {
        this(transform, tempDir, 0, pl);
    }

    public ChunkedHashStore(TransformationStrategy<? super T> transform, File tempDir, int hashWidth, ProgressLogger pl) throws IOException {
        this.transform = transform;
        this.pl = pl;
        this.hashMask = hashWidth == 0 ? 0L : -1L >>> 64 - hashWidth;
        this.file = new File[256];
        this.dos = new DataOutputStream[256];
        for (int i = 0; i < 256; ++i) {
            this.file[i] = File.createTempFile(ChunkedHashStore.class.getSimpleName(), String.valueOf(i), tempDir);
            this.dos[i] = new DataOutputStream((OutputStream)new FastBufferedOutputStream((OutputStream)new FileOutputStream(this.file[i]), 32768));
            this.file[i].deleteOnExit();
        }
        this.count = new int[256];
    }

    public long seed() {
        this.locked = true;
        return this.seed;
    }

    public TransformationStrategy<? super T> transform() {
        return this.transform;
    }

    public void add(T o, long value) throws IOException {
        long[] triple = new long[3];
        Hashes.jenkins(this.transform.toBitVector(o), this.seed, triple);
        this.add(triple, value);
    }

    public void add(T o) throws IOException {
        this.add(o, this.filteredSize);
    }

    private void add(long[] triple, long value) throws IOException {
        int chunk;
        int n = chunk = (int)(triple[0] >>> 56);
        this.count[n] = this.count[n] + 1;
        this.checkedForDuplicates = false;
        this.dos[chunk].writeLong(triple[0]);
        this.dos[chunk].writeLong(triple[1]);
        this.dos[chunk].writeLong(triple[2]);
        if (this.hashMask == 0L) {
            this.dos[chunk].writeLong(value);
        }
        if (this.filteredSize != -1L && (this.filter == null || this.filter.evaluate((Object)triple))) {
            ++this.filteredSize;
        }
        ++this.size;
    }

    public void addAll(Iterator<? extends T> elements, LongIterator values) throws IOException {
        if (this.pl != null) {
            this.pl.start((CharSequence)"Adding elements...");
        }
        long[] triple = new long[3];
        while (elements.hasNext()) {
            Hashes.jenkins(this.transform.toBitVector(elements.next()), this.seed, triple);
            this.add(triple, values != null ? values.nextLong() : this.filteredSize);
            if (this.pl == null) continue;
            this.pl.lightUpdate();
        }
        if (values != null && values.hasNext()) {
            throw new IllegalStateException("The iterator on values contains more entries than the iterator on keys");
        }
        if (this.pl != null) {
            this.pl.done();
        }
    }

    public void addAll(Iterator<? extends T> elements) throws IOException {
        this.addAll(elements, null);
    }

    public long size() throws IOException {
        if (this.filter == null) {
            return this.size;
        }
        if (this.filteredSize == -1L) {
            long c = 0L;
            long[] triple = new long[3];
            for (int i = 0; i < 256; ++i) {
                if (this.filter == null) {
                    c += (long)this.count[i];
                    continue;
                }
                for (DataOutputStream d : this.dos) {
                    d.flush();
                }
                DataInputStream dis = new DataInputStream((InputStream)new FastBufferedInputStream((InputStream)new FileInputStream(this.file[i])));
                for (int j = 0; j < this.count[i]; ++j) {
                    triple[0] = dis.readLong();
                    triple[1] = dis.readLong();
                    triple[2] = dis.readLong();
                    if (this.hashMask == 0L) {
                        dis.readLong();
                    }
                    if (!this.filter.evaluate((Object)triple)) continue;
                    ++c;
                }
                dis.close();
            }
            this.filteredSize = c;
        }
        return this.filteredSize;
    }

    public void clear() {
        this.locked = false;
        this.reset(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (!this.closed) {
                LOGGER.warn("This " + this.getClass().getName() + " [" + this.toString() + "] should have been closed.");
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            for (DataOutputStream d : this.dos) {
                try {
                    d.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            for (File f : this.file) {
                f.delete();
            }
        }
    }

    public void reset(long seed) {
        if (this.locked) {
            throw new IllegalStateException();
        }
        this.filteredSize = 0L;
        this.seed = seed;
        this.checkedForDuplicates = false;
        Arrays.fill(this.count, 0);
        try {
            for (DataOutputStream d : this.dos) {
                d.close();
            }
            for (int i = 0; i < 256; ++i) {
                this.dos[i] = new DataOutputStream((OutputStream)new FastBufferedOutputStream((OutputStream)new FileOutputStream(this.file[i])));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void check() throws DuplicateException {
        for (Chunk b : this) {
            b.iterator();
        }
    }

    public void checkAndRetry(Iterable<? extends T> iterable, LongIterable values) throws IOException {
        XorShift1024StarRandomGenerator random = new XorShift1024StarRandomGenerator();
        int duplicates = 0;
        while (true) {
            try {
                this.check();
            }
            catch (DuplicateException e) {
                if (duplicates++ > 3) {
                    throw new IllegalArgumentException("The input list contains duplicates");
                }
                LOGGER.warn("Found duplicate. Recomputing triples...");
                this.reset(random.nextLong());
                this.addAll(iterable.iterator(), values.iterator());
                continue;
            }
            break;
        }
        this.checkedForDuplicates = true;
    }

    public void checkAndRetry(Iterable<? extends T> iterable) throws IOException {
        this.checkAndRetry(iterable, null);
    }

    public LongBigList signatures(int signatureWidth, ProgressLogger pl) throws IOException {
        LongBigList signatures = LongArrayBitVector.getInstance().asLongBigList(signatureWidth);
        long signatureMask = -1L >>> 64 - signatureWidth;
        signatures.size(this.size());
        pl.expectedUpdates = this.size();
        pl.itemsName = "signatures";
        pl.start((CharSequence)"Signing...");
        for (Chunk chunk : this) {
            Iterator<long[]> chunkIterator = chunk.iterator();
            int i = chunk.size();
            while (i-- != 0) {
                long[] quadruple = chunkIterator.next();
                signatures.set(quadruple[3], signatureMask & quadruple[0]);
                pl.lightUpdate();
            }
        }
        pl.done();
        return signatures;
    }

    public int log2Chunks(int log2chunks) {
        this.chunks = 1 << log2chunks;
        this.diskChunkStep = (int)Math.max(256L / this.chunks, 1L);
        this.virtualDiskChunks = 256 / this.diskChunkStep;
        this.chunkShift = 64 - log2chunks;
        LOGGER.debug("Number of chunks: " + this.chunks);
        LOGGER.debug("Number of disk chunks: 256");
        LOGGER.debug("Number of virtual disk chunks: " + this.virtualDiskChunks);
        return this.chunkShift;
    }

    public void filter(Predicate filter) {
        this.filter = filter;
        this.filteredSize = -1L;
    }

    @Override
    public Iterator<Chunk> iterator() {
        if (this.closed) {
            throw new IllegalStateException("This " + this.getClass().getSimpleName() + " has been closed ");
        }
        for (DataOutputStream d : this.dos) {
            try {
                d.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        int m = 0;
        for (int i = 0; i < this.virtualDiskChunks; ++i) {
            int s = 0;
            for (int j = 0; j < this.diskChunkStep; ++j) {
                s += this.count[i * this.diskChunkStep + j];
            }
            if (s <= m) continue;
            m = s;
        }
        final int maxCount = m;
        return new AbstractObjectIterator<Chunk>(){
            private int chunk;
            private FastBufferedInputStream fbis;
            private int last;
            private int chunkSize;
            private final long[] buffer0;
            private final long[] buffer1;
            private final long[] buffer2;
            private final long[] data;
            {
                this.buffer0 = new long[maxCount];
                this.buffer1 = new long[maxCount];
                this.buffer2 = new long[maxCount];
                this.data = ChunkedHashStore.this.hashMask != 0L ? null : new long[maxCount];
            }

            public boolean hasNext() {
                return (long)this.chunk < ChunkedHashStore.this.chunks;
            }

            public Chunk next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                final long[] buffer0 = this.buffer0;
                if ((long)this.chunk % (ChunkedHashStore.this.chunks / (long)ChunkedHashStore.this.virtualDiskChunks) == 0L) {
                    int diskChunk = (int)((long)this.chunk / (ChunkedHashStore.this.chunks / (long)ChunkedHashStore.this.virtualDiskChunks));
                    final long[] buffer1 = this.buffer1;
                    final long[] buffer2 = this.buffer2;
                    this.chunkSize = 0;
                    try {
                        if (ChunkedHashStore.this.diskChunkStep == 1) {
                            this.fbis = new FastBufferedInputStream((InputStream)new FileInputStream(ChunkedHashStore.this.file[diskChunk]));
                            this.chunkSize = ChunkedHashStore.this.count[diskChunk];
                        } else {
                            FileInputStream[] fis = new FileInputStream[ChunkedHashStore.this.diskChunkStep];
                            for (int i = 0; i < fis.length; ++i) {
                                fis[i] = new FileInputStream(ChunkedHashStore.this.file[diskChunk * ChunkedHashStore.this.diskChunkStep + i]);
                                this.chunkSize += ChunkedHashStore.this.count[diskChunk * ChunkedHashStore.this.diskChunkStep + i];
                            }
                            this.fbis = new FastBufferedInputStream((InputStream)new SequenceInputStream((Enumeration<? extends InputStream>)new IteratorEnumeration(Arrays.asList(fis).iterator())));
                        }
                        DataInputStream dis = new DataInputStream((InputStream)this.fbis);
                        long[] triple = new long[3];
                        int count = 0;
                        for (int j = 0; j < this.chunkSize; ++j) {
                            triple[0] = dis.readLong();
                            triple[1] = dis.readLong();
                            triple[2] = dis.readLong();
                            if (ChunkedHashStore.this.filter == null || ChunkedHashStore.this.filter.evaluate((Object)triple)) {
                                buffer0[count] = triple[0];
                                buffer1[count] = triple[1];
                                buffer2[count] = triple[2];
                                if (ChunkedHashStore.this.hashMask == 0L) {
                                    this.data[count] = dis.readLong();
                                }
                                ++count;
                                continue;
                            }
                            if (ChunkedHashStore.this.hashMask != 0L) continue;
                            dis.readLong();
                        }
                        this.chunkSize = count;
                        dis.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    it.unimi.dsi.fastutil.Arrays.quickSort((int)0, (int)this.chunkSize, (IntComparator)new AbstractIntComparator(){

                        public int compare(int x, int y) {
                            return Long.signum(buffer0[x] - buffer0[y]);
                        }
                    }, (Swapper)new Swapper(){

                        public void swap(int x, int y) {
                            long e0 = buffer0[x];
                            long e1 = buffer1[x];
                            long e2 = buffer2[x];
                            buffer0[x] = buffer0[y];
                            buffer1[x] = buffer1[y];
                            buffer2[x] = buffer2[y];
                            buffer0[y] = e0;
                            buffer1[y] = e1;
                            buffer2[y] = e2;
                            if (ChunkedHashStore.this.hashMask == 0L) {
                                long v = data[x];
                                (this).data[x] = data[y];
                                (this).data[y] = v;
                            }
                        }
                    });
                    if (!ChunkedHashStore.this.checkedForDuplicates && this.chunkSize > 1) {
                        int i = this.chunkSize - 1;
                        while (i-- != 0) {
                            if (buffer0[i] != buffer0[i + 1] || buffer1[i] != buffer1[i + 1] || buffer2[i] != buffer2[i + 1]) continue;
                            throw new DuplicateException();
                        }
                    }
                    if ((long)this.chunk == ChunkedHashStore.this.chunks - 1L) {
                        ChunkedHashStore.this.checkedForDuplicates = true;
                    }
                    this.last = 0;
                }
                int start = this.last;
                while (this.last < this.chunkSize && (ChunkedHashStore.this.chunkShift == 64 ? 0L : buffer0[this.last] >>> ChunkedHashStore.this.chunkShift) == (long)this.chunk) {
                    ++this.last;
                }
                ++this.chunk;
                return new Chunk(buffer0, this.buffer1, this.buffer2, this.data, ChunkedHashStore.this.hashMask, start, this.last);
            }
        };
    }

    public static final class Chunk
    implements Iterable<long[]> {
        private final int start;
        private final int end;
        private final long[] buffer0;
        private final long[] buffer1;
        private final long[] buffer2;
        private final long[] data;
        private final long hashMask;

        private Chunk(long[] buffer0, long[] buffer1, long[] buffer2, long[] data, long hashMask, int start, int end) {
            this.start = start;
            this.end = end;
            this.data = data;
            this.hashMask = hashMask;
            this.buffer0 = buffer0;
            this.buffer1 = buffer1;
            this.buffer2 = buffer2;
        }

        public int size() {
            return this.end - this.start;
        }

        public long data(long k) {
            return this.data != null ? this.data[(int)((long)this.start + k)] : this.buffer0[(int)((long)this.start + k)] & this.hashMask;
        }

        @Override
        public Iterator<long[]> iterator() {
            return new AbstractObjectIterator<long[]>(){
                private int pos;
                private long[] quadruple;
                {
                    this.pos = Chunk.this.start;
                    this.quadruple = new long[4];
                }

                public boolean hasNext() {
                    return this.pos < Chunk.this.end;
                }

                public long[] next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    long[] quadruple = this.quadruple;
                    quadruple[0] = Chunk.this.buffer0[this.pos];
                    quadruple[1] = Chunk.this.buffer1[this.pos];
                    quadruple[2] = Chunk.this.buffer2[this.pos];
                    quadruple[3] = Chunk.this.data != null ? Chunk.this.data[this.pos] : Chunk.this.buffer0[this.pos] & Chunk.this.hashMask;
                    ++this.pos;
                    return quadruple;
                }
            };
        }
    }

    public static class DuplicateException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }
}

