/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.bits;

import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.fastutil.longs.LongBigList;
import it.unimi.dsi.fastutil.longs.LongIterable;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.sux4j.bits.Select;
import it.unimi.dsi.sux4j.bits.SimpleSelect;
import it.unimi.dsi.sux4j.bits.SparseRank;
import it.unimi.dsi.sux4j.util.EliasFanoMonotoneLongBigList;

public class SparseSelect
extends EliasFanoMonotoneLongBigList
implements Select {
    private static final long serialVersionUID = 2L;
    private final long n;
    protected final boolean fromRank;

    public SparseSelect(long[] bits, long length) {
        this((BitVector)LongArrayBitVector.wrap((long[])bits, (long)length));
    }

    public SparseSelect(BitVector bitVector) {
        this(bitVector.length(), bitVector.count(), (LongIterator)bitVector.asLongSet().iterator());
    }

    public SparseSelect(long n, long m, LongIterator iterator) {
        super(m, n, iterator);
        this.n = n;
        this.fromRank = false;
    }

    public SparseSelect(LongList list) {
        super((LongIterable)list);
        this.n = list.isEmpty() ? 0L : list.getLong(list.size() - 1) + 1L;
        this.fromRank = false;
    }

    public SparseSelect(LongBigList list) {
        super((LongIterable)list);
        this.n = list.isEmpty() ? 0L : list.getLong(list.size64() - 1L) + 1L;
        this.fromRank = false;
    }

    protected SparseSelect(long n, long m, int l, long[] lowerBits, SimpleSelect selectUpper) {
        super(m, l, lowerBits, selectUpper);
        this.n = n;
        this.fromRank = true;
    }

    public SparseRank getRank() {
        return new SparseRank(this.n, this.length, this.l, this.lowerBits, this.selectUpper.bitVector());
    }

    @Override
    public long size64() {
        return this.n;
    }

    @Deprecated
    public int size() {
        return (int)Math.min(this.n, Integer.MAX_VALUE);
    }

    @Override
    public long getLong(long pos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long numBits() {
        return this.selectUpper.numBits() + (this.fromRank ? 0L : this.selectUpper.bitVector().length() + (long)this.lowerBits.length * 64L);
    }

    @Override
    public long select(long rank) {
        if (rank >= this.length) {
            return -1L;
        }
        int l = this.l;
        long upperBits = this.selectUpper.select(rank) - rank;
        if (l == 0) {
            return upperBits;
        }
        long position = rank * (long)l;
        int startWord = (int)(position / 64L);
        int startBit = (int)(position % 64L);
        int totalOffset = startBit + l;
        long result = this.lowerBits[startWord] >>> startBit;
        return upperBits << l | (totalOffset <= 64 ? result : result | this.lowerBits[startWord + 1] << -startBit) & this.lowerBitsMask;
    }

    @Override
    public BitVector bitVector() {
        LongArrayBitVector result = LongArrayBitVector.ofLength((long)this.n);
        long i = this.length;
        while (i-- != 0L) {
            result.set(this.select(i));
        }
        return result;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public boolean equals(Object o) {
        return o == this;
    }

    public String toString() {
        return this.getClass().getName() + '@' + Integer.toHexString(this.hashCode());
    }
}

