/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.webgraph.labelling;

import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.fastutil.objects.ObjectIterators;
import it.unimi.dsi.webgraph.Transform;
import it.unimi.dsi.webgraph.labelling.ArcLabelledImmutableGraph;
import it.unimi.dsi.webgraph.labelling.ArcLabelledNodeIterator;
import it.unimi.dsi.webgraph.labelling.Label;
import it.unimi.dsi.webgraph.labelling.LabelMergeStrategy;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnionArcLabelledImmutableGraph
extends ArcLabelledImmutableGraph {
    private static final Logger LOGGER = LoggerFactory.getLogger(Transform.class);
    private static final boolean DEBUG = false;
    private static final boolean ASSERTS = false;
    private static final int INITIAL_ARRAY_SIZE = 16;
    private final ArcLabelledImmutableGraph g0;
    private final ArcLabelledImmutableGraph g1;
    private final int n0;
    private final int n1;
    private final int numNodes;
    private LabelMergeStrategy labelMergeStrategy;
    private int cachedNode = -1;
    private int outdegree;
    private int[] cache;
    private Label[] labelCache;
    private Label prototype;

    @Override
    public UnionArcLabelledImmutableGraph copy() {
        return new UnionArcLabelledImmutableGraph(this.g0.copy(), this.g1.copy(), this.labelMergeStrategy);
    }

    public UnionArcLabelledImmutableGraph(ArcLabelledImmutableGraph g0, ArcLabelledImmutableGraph g1, LabelMergeStrategy labelMergeStrategy) {
        this.g0 = g0;
        this.g1 = g1;
        this.labelMergeStrategy = labelMergeStrategy;
        this.n0 = g0.numNodes();
        this.n1 = g1.numNodes();
        this.numNodes = Math.max(this.n0, this.n1);
        if (g0.prototype().getClass() != g1.prototype().getClass()) {
            throw new IllegalArgumentException("The two graphs have different label classes (" + g0.prototype().getClass().getSimpleName() + ", " + g1.prototype().getClass().getSimpleName() + ")");
        }
        this.prototype = g0.prototype();
    }

    @Override
    public ArcLabelledNodeIterator nodeIterator(final int from) {
        return new ArcLabelledNodeIterator(){
            private int[] cache = IntArrays.EMPTY_ARRAY;
            private Label[] labelCache = new Label[0];
            private int outdegree = -1;
            private ArcLabelledNodeIterator i0 = from < UnionArcLabelledImmutableGraph.access$000(UnionArcLabelledImmutableGraph.this) ? UnionArcLabelledImmutableGraph.access$100(UnionArcLabelledImmutableGraph.this).nodeIterator(from) : null;
            private ArcLabelledNodeIterator i1 = from < UnionArcLabelledImmutableGraph.access$200(UnionArcLabelledImmutableGraph.this) ? UnionArcLabelledImmutableGraph.access$300(UnionArcLabelledImmutableGraph.this).nodeIterator(from) : null;

            public boolean hasNext() {
                return this.i0 != null && this.i0.hasNext() || this.i1 != null && this.i1.hasNext();
            }

            public int nextInt() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.outdegree = -1;
                int result = -1;
                if (this.i0 != null) {
                    if (this.i0.hasNext()) {
                        result = this.i0.nextInt();
                    } else {
                        this.i0 = null;
                    }
                }
                if (this.i1 != null) {
                    if (this.i1.hasNext()) {
                        result = this.i1.nextInt();
                    } else {
                        this.i1 = null;
                    }
                }
                return result;
            }

            @Override
            public int[] successorArray() {
                if (this.outdegree != -1) {
                    return this.cache;
                }
                if (this.i0 == null) {
                    this.outdegree = this.i1.outdegree();
                    this.cache = this.i1.successorArray();
                    this.labelCache = this.i1.labelArray();
                    return this.cache;
                }
                if (this.i1 == null) {
                    this.outdegree = this.i0.outdegree();
                    this.cache = this.i0.successorArray();
                    this.labelCache = this.i0.labelArray();
                    return this.cache;
                }
                ArcLabelledNodeIterator.LabelledArcIterator succ0 = this.i0.successors();
                ArcLabelledNodeIterator.LabelledArcIterator succ1 = this.i1.successors();
                int s0 = -1;
                int s1 = -1;
                Label l0 = null;
                Label l1 = null;
                this.outdegree = 0;
                while ((s0 != -1 || (s0 = succ0.nextInt()) != -1) | (s1 != -1 || (s1 = succ1.nextInt()) != -1)) {
                    if (s0 != -1) {
                        l0 = succ0.label().copy();
                    }
                    if (s1 != -1) {
                        l1 = succ1.label().copy();
                    }
                    this.cache = IntArrays.grow((int[])this.cache, (int)(this.outdegree + 1));
                    this.labelCache = (Label[])ObjectArrays.grow((Object[])this.labelCache, (int)(this.outdegree + 1));
                    if (s1 < 0 || 0 <= s0 && s0 < s1) {
                        this.cache[this.outdegree] = s0;
                        this.labelCache[this.outdegree] = l0;
                        s0 = -1;
                    } else if (s0 < 0 || 0 <= s1 && s1 < s0) {
                        this.cache[this.outdegree] = s1;
                        this.labelCache[this.outdegree] = l1;
                        s1 = -1;
                    } else {
                        this.cache[this.outdegree] = s0;
                        this.labelCache[this.outdegree] = UnionArcLabelledImmutableGraph.this.labelMergeStrategy.merge(l0, l1);
                        s1 = -1;
                        s0 = -1;
                    }
                    ++this.outdegree;
                }
                return this.cache;
            }

            @Override
            public int outdegree() {
                this.successorArray();
                return this.outdegree;
            }

            @Override
            public Label[] labelArray() {
                this.successorArray();
                return this.labelCache;
            }

            @Override
            public ArcLabelledNodeIterator.LabelledArcIterator successors() {
                this.successorArray();
                return new ArcLabelledNodeIterator.LabelledArcIterator(){
                    int nextToBeReturned = 0;

                    @Override
                    public Label label() {
                        return labelCache[this.nextToBeReturned - 1];
                    }

                    @Override
                    public int nextInt() {
                        if (this.nextToBeReturned == outdegree) {
                            return -1;
                        }
                        return cache[this.nextToBeReturned++];
                    }

                    @Override
                    public int skip(int x) {
                        int skipped = Math.min(x, outdegree - this.nextToBeReturned);
                        this.nextToBeReturned += skipped;
                        return skipped;
                    }
                };
            }
        };
    }

    @Override
    public int numNodes() {
        return this.numNodes;
    }

    @Override
    public boolean randomAccess() {
        return this.g0.randomAccess() && this.g1.randomAccess();
    }

    @Override
    public int[] successorArray(int x) {
        this.fillCache(x);
        return this.cache;
    }

    private void fillCache(int x) {
        if (x == this.cachedNode) {
            return;
        }
        ArcLabelledNodeIterator.LabelledArcIterator succ0 = x < this.n0 ? this.g0.successors(x) : ObjectIterators.EMPTY_ITERATOR;
        ArcLabelledNodeIterator.LabelledArcIterator succ1 = x < this.n1 ? this.g1.successors(x) : ObjectIterators.EMPTY_ITERATOR;
        int outdegree = 0;
        int s0 = -1;
        int s1 = -1;
        Label l0 = null;
        Label l1 = null;
        int[] cache = new int[16];
        Object[] labelCache = new Label[16];
        while ((s0 != -1 || (s0 = succ0.nextInt()) != -1) | (s1 != -1 || (s1 = succ1.nextInt()) != -1)) {
            if (s0 != -1) {
                l0 = succ0.label().copy();
            }
            if (s1 != -1) {
                l1 = succ1.label().copy();
            }
            cache = IntArrays.grow((int[])cache, (int)(outdegree + 1));
            labelCache = (Label[])ObjectArrays.grow((Object[])labelCache, (int)(outdegree + 1));
            if (s1 < 0 || 0 <= s0 && s0 < s1) {
                cache[outdegree] = s0;
                labelCache[outdegree] = l0;
                s0 = -1;
            } else if (s0 < 0 || 0 <= s1 && s1 < s0) {
                cache[outdegree] = s1;
                labelCache[outdegree] = l1;
                s1 = -1;
            } else {
                cache[outdegree] = s0;
                labelCache[outdegree] = this.labelMergeStrategy.merge(l0, l1);
                s1 = -1;
                s0 = -1;
            }
            ++outdegree;
        }
        this.cache = cache;
        this.labelCache = labelCache;
        this.outdegree = outdegree;
        this.cachedNode = x;
    }

    @Override
    public int outdegree(int x) {
        this.fillCache(x);
        return this.outdegree;
    }

    @Override
    public Label[] labelArray(int x) {
        this.fillCache(x);
        return this.labelCache;
    }

    @Override
    public ArcLabelledNodeIterator.LabelledArcIterator successors(int x) {
        this.fillCache(x);
        final int outdegree = this.outdegree;
        final int[] cache = this.cache;
        final Label[] labelCache = this.labelCache;
        return new ArcLabelledNodeIterator.LabelledArcIterator(){
            int nextToBeReturned = -1;

            @Override
            public Label label() {
                return labelCache[this.nextToBeReturned];
            }

            @Override
            public int nextInt() {
                if (++this.nextToBeReturned >= outdegree) {
                    return -1;
                }
                return cache[this.nextToBeReturned];
            }

            @Override
            public int skip(int n) {
                int skipped = Math.min(n, outdegree - this.nextToBeReturned - 1);
                if (skipped < 0) {
                    return 0;
                }
                this.nextToBeReturned += skipped;
                return skipped;
            }
        };
    }

    @Override
    public Label prototype() {
        return this.prototype;
    }

    static /* synthetic */ int access$000(UnionArcLabelledImmutableGraph x0) {
        return x0.n0;
    }

    static /* synthetic */ ArcLabelledImmutableGraph access$100(UnionArcLabelledImmutableGraph x0) {
        return x0.g0;
    }

    static /* synthetic */ int access$200(UnionArcLabelledImmutableGraph x0) {
        return x0.n1;
    }

    static /* synthetic */ ArcLabelledImmutableGraph access$300(UnionArcLabelledImmutableGraph x0) {
        return x0.g1;
    }
}

