/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.webgraph.labelling;

import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.io.FastMultiByteArrayInputStream;
import it.unimi.dsi.fastutil.longs.AbstractLongIterator;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.io.InputBitStream;
import it.unimi.dsi.io.OutputBitStream;
import it.unimi.dsi.lang.ObjectParser;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.sux4j.util.EliasFanoMonotoneLongBigList;
import it.unimi.dsi.webgraph.AbstractLazyIntIterator;
import it.unimi.dsi.webgraph.ImmutableGraph;
import it.unimi.dsi.webgraph.LazyIntIterator;
import it.unimi.dsi.webgraph.NodeIterator;
import it.unimi.dsi.webgraph.labelling.ArcLabelledImmutableGraph;
import it.unimi.dsi.webgraph.labelling.ArcLabelledNodeIterator;
import it.unimi.dsi.webgraph.labelling.Label;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Properties;

public class BitStreamArcLabelledImmutableGraph
extends ArcLabelledImmutableGraph {
    public static final String LABELS_EXTENSION = ".labels";
    public static final String LABEL_OFFSETS_EXTENSION = ".labeloffsets";
    public static final String LABELSPEC_PROPERTY_KEY = "labelspec";
    private static final int STD_BUFFER_SIZE = 0x100000;
    public final ImmutableGraph g;
    protected final Label prototype;
    private final byte[] byteArray;
    private final FastMultiByteArrayInputStream labelStream;
    protected final CharSequence basename;
    protected final EliasFanoMonotoneLongBigList offset;

    protected BitStreamArcLabelledImmutableGraph(CharSequence basename, ImmutableGraph g, Label prototype, byte[] byteArray, FastMultiByteArrayInputStream labelStream, EliasFanoMonotoneLongBigList offset) {
        this.g = g;
        this.byteArray = byteArray;
        this.labelStream = labelStream;
        this.prototype = prototype;
        this.basename = basename;
        this.offset = offset;
    }

    @Override
    public BitStreamArcLabelledImmutableGraph copy() {
        return new BitStreamArcLabelledImmutableGraph(this.basename, this.g.copy(), this.prototype.copy(), this.byteArray, this.labelStream, this.offset);
    }

    protected InputBitStream newInputBitStream() throws FileNotFoundException {
        return this.byteArray != null ? new InputBitStream(this.byteArray) : (this.labelStream != null ? new InputBitStream((InputStream)new FastMultiByteArrayInputStream(this.labelStream)) : new InputBitStream(this.basename + LABELS_EXTENSION));
    }

    @Override
    public CharSequence basename() {
        return this.basename;
    }

    protected long offset(int x) {
        return this.offset.getLong(x);
    }

    @Override
    public ArcLabelledNodeIterator.LabelledArcIterator successors(int x) {
        return new BitStreamLabelledArcIterator(this, x);
    }

    @Override
    public int[] successorArray(int x) {
        return this.g.successorArray(x);
    }

    @Override
    public int numNodes() {
        return this.g.numNodes();
    }

    @Override
    public long numArcs() {
        return this.g.numArcs();
    }

    @Override
    public boolean randomAccess() {
        return this.g.randomAccess() && this.offset != null;
    }

    @Override
    public int outdegree(int x) {
        return this.g.outdegree(x);
    }

    public static BitStreamArcLabelledImmutableGraph loadSequential(CharSequence basename) throws IOException {
        return BitStreamArcLabelledImmutableGraph.load(ImmutableGraph.LoadMethod.SEQUENTIAL, basename, null);
    }

    public static BitStreamArcLabelledImmutableGraph loadSequential(CharSequence basename, ProgressLogger pl) throws IOException {
        return BitStreamArcLabelledImmutableGraph.load(ImmutableGraph.LoadMethod.SEQUENTIAL, basename, pl);
    }

    public static BitStreamArcLabelledImmutableGraph loadOffline(CharSequence basename) throws IOException {
        return BitStreamArcLabelledImmutableGraph.load(ImmutableGraph.LoadMethod.OFFLINE, basename, null);
    }

    public static BitStreamArcLabelledImmutableGraph loadOffline(CharSequence basename, ProgressLogger pl) throws IOException {
        return BitStreamArcLabelledImmutableGraph.load(ImmutableGraph.LoadMethod.OFFLINE, basename, pl);
    }

    public static BitStreamArcLabelledImmutableGraph load(CharSequence basename) throws IOException {
        return BitStreamArcLabelledImmutableGraph.load(ImmutableGraph.LoadMethod.STANDARD, basename, null);
    }

    public static BitStreamArcLabelledImmutableGraph load(CharSequence basename, ProgressLogger pl) throws IOException {
        return BitStreamArcLabelledImmutableGraph.load(ImmutableGraph.LoadMethod.STANDARD, basename, pl);
    }

    protected static BitStreamArcLabelledImmutableGraph load(ImmutableGraph.LoadMethod method, CharSequence basename, ProgressLogger pl) throws IOException {
        Label prototype;
        FileInputStream propertyFile = new FileInputStream(basename + ".properties");
        Properties properties = new Properties();
        properties.load(propertyFile);
        propertyFile.close();
        if (properties.getProperty("underlyinggraph") == null) {
            throw new IOException("The property file for " + basename + " does not contain an underlying graph basename");
        }
        String graphName = properties.getProperty("underlyinggraph");
        if (!new File(graphName).isAbsolute()) {
            graphName = new File(new File(basename.toString()).getParentFile(), properties.getProperty("underlyinggraph")).toString();
        }
        FileInputStream graphPropertyFile = new FileInputStream(graphName + ".properties");
        Properties graphProperties = new Properties();
        graphProperties.load(graphPropertyFile);
        graphPropertyFile.close();
        final ImmutableGraph g = ImmutableGraph.load(method, graphName, null, pl);
        if (properties.getProperty(LABELSPEC_PROPERTY_KEY) == null) {
            throw new IOException("The property file for " + basename + " does not contain a label specification");
        }
        try {
            try {
                prototype = (Label)ObjectParser.fromSpec((Object)new File(basename.toString()).getParentFile(), (String)properties.getProperty(LABELSPEC_PROPERTY_KEY), Label.class);
            }
            catch (NoSuchMethodException e) {
                prototype = (Label)ObjectParser.fromSpec((String)properties.getProperty(LABELSPEC_PROPERTY_KEY), Label.class);
            }
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        byte[] byteArray = null;
        FastMultiByteArrayInputStream labelStream = null;
        EliasFanoMonotoneLongBigList offsets = null;
        if (method != ImmutableGraph.LoadMethod.OFFLINE) {
            FileInputStream fis;
            long size;
            if (pl != null) {
                pl.itemsName = "bytes";
                pl.start((CharSequence)"Loading labels...");
            }
            if ((size = (fis = new FileInputStream(basename + LABELS_EXTENSION)).getChannel().size()) <= Integer.MAX_VALUE) {
                byteArray = BinIO.loadBytes((CharSequence)(basename + LABELS_EXTENSION));
            } else {
                labelStream = new FastMultiByteArrayInputStream((InputStream)fis, size);
            }
            if (pl != null) {
                pl.count = size;
                pl.done();
            }
            if (method != ImmutableGraph.LoadMethod.SEQUENTIAL) {
                if (pl != null) {
                    pl.itemsName = "deltas";
                    pl.expectedUpdates = g.numNodes() + 1;
                    pl.start((CharSequence)"Loading label offsets...");
                }
                final InputBitStream offsetStream = new InputBitStream(basename + LABEL_OFFSETS_EXTENSION);
                offsets = new EliasFanoMonotoneLongBigList((long)(g.numNodes() + 1), size * 8L + 1L, (LongIterator)new AbstractLongIterator(){
                    private long off;
                    private int i;

                    public boolean hasNext() {
                        return this.i <= g.numNodes();
                    }

                    public long nextLong() {
                        ++this.i;
                        try {
                            this.off = offsetStream.readLongGamma() + this.off;
                            return this.off;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
                offsetStream.close();
                if (pl != null) {
                    pl.count = g.numNodes() + 1;
                    pl.done();
                    pl.logger().info("Label pointer bits per node: " + (double)offsets.numBits() / ((double)g.numNodes() + 1.0));
                }
            }
            fis.close();
        }
        return new BitStreamArcLabelledImmutableGraph(basename, g, prototype, byteArray, labelStream, offsets);
    }

    @Override
    public ArcLabelledNodeIterator nodeIterator(int from) {
        try {
            return new BitStreamArcLabelledNodeIterator(from, this.g, this.prototype, this.newInputBitStream());
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Label prototype() {
        return this.prototype;
    }

    public static void store(ArcLabelledImmutableGraph graph, CharSequence basename, CharSequence underlyingBasename) throws IOException {
        BitStreamArcLabelledImmutableGraph.store(graph, basename, underlyingBasename, null);
    }

    public static void store(ArcLabelledImmutableGraph graph, CharSequence basename, CharSequence underlyingBasename, ProgressLogger pl) throws IOException {
        OutputBitStream labels = new OutputBitStream(basename + LABELS_EXTENSION, 0x100000);
        OutputBitStream offsets = new OutputBitStream(basename + LABEL_OFFSETS_EXTENSION, 0x100000);
        if (pl != null) {
            pl.itemsName = "nodes";
            pl.expectedUpdates = graph.numNodes();
            pl.start((CharSequence)"Saving labels...");
        }
        ArcLabelledNodeIterator nodeIterator = graph.nodeIterator();
        offsets.writeGamma(0);
        while (nodeIterator.hasNext()) {
            int curr = nodeIterator.nextInt();
            ArcLabelledNodeIterator.LabelledArcIterator successors = nodeIterator.successors();
            long count = 0L;
            while (successors.nextInt() != -1) {
                count += (long)successors.label().toBitStream(labels, curr);
            }
            offsets.writeLongGamma(count);
            if (pl == null) continue;
            pl.lightUpdate();
        }
        if (pl != null) {
            pl.done();
        }
        labels.close();
        offsets.close();
        PrintWriter properties = new PrintWriter(new FileOutputStream(basename + ".properties"));
        properties.println("graphclass = " + BitStreamArcLabelledImmutableGraph.class.getName());
        properties.println("underlyinggraph = " + underlyingBasename);
        properties.println("labelspec = " + graph.prototype().toSpec());
        properties.close();
    }

    private static final class BitStreamArcLabelledNodeIterator
    extends ArcLabelledNodeIterator {
        private static final Label[] EMPTY_ARRAY = new Label[0];
        private final NodeIterator underlyingNodeIterator;
        private final InputBitStream ibs;
        private final Label prototype;
        private Label[] label = EMPTY_ARRAY;

        public BitStreamArcLabelledNodeIterator(int from, ImmutableGraph g, Label prototype, InputBitStream ibs) {
            this.prototype = prototype;
            this.ibs = ibs;
            this.underlyingNodeIterator = g.nodeIterator();
            int i = from;
            while (i-- != 0) {
                this.nextInt();
            }
        }

        @Override
        public ArcLabelledNodeIterator.LabelledArcIterator successors() {
            return new BitStreamArcLabelledNodeIteratorArcIterator(this.underlyingNodeIterator.outdegree(), this.underlyingNodeIterator.successorArray(), this.label);
        }

        @Override
        public int[] successorArray() {
            return this.underlyingNodeIterator.successorArray();
        }

        @Override
        public Label[] labelArray() {
            return this.label;
        }

        @Override
        public int outdegree() {
            return this.underlyingNodeIterator.outdegree();
        }

        public int nextInt() {
            int i;
            int curr = this.underlyingNodeIterator.nextInt();
            int d = this.underlyingNodeIterator.outdegree();
            if (this.label.length < d) {
                this.label = (Label[])ObjectArrays.grow((Object[])this.label, (int)d);
                i = this.label.length;
                while (i-- != 0 && this.label[i] == null) {
                    this.label[i] = this.prototype.copy();
                }
            }
            try {
                for (i = 0; i < d; ++i) {
                    this.label[i].fromBitStream(this.ibs, curr);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return curr;
        }

        public boolean hasNext() {
            return this.underlyingNodeIterator.hasNext();
        }

        private static final class BitStreamArcLabelledNodeIteratorArcIterator
        extends AbstractLazyIntIterator
        implements ArcLabelledNodeIterator.LabelledArcIterator {
            private final Label[] label;
            private final int[] successor;
            private final int outdegree;
            private int curr;

            public BitStreamArcLabelledNodeIteratorArcIterator(int outdegree, int[] successor, Label[] label) {
                this.outdegree = outdegree;
                this.successor = successor;
                this.label = label;
                this.curr = -1;
            }

            @Override
            public Label label() {
                if (this.curr == -1) {
                    throw new IllegalStateException("This successor iterator is currently not valid");
                }
                return this.label[this.curr];
            }

            @Override
            public int nextInt() {
                if (this.curr == this.outdegree - 1) {
                    return -1;
                }
                return this.successor[++this.curr];
            }

            @Override
            public int skip(int n) {
                int toSkip = Math.min(n, this.outdegree - 1 - this.curr);
                this.curr += toSkip;
                return toSkip;
            }
        }
    }

    protected static class BitStreamLabelledArcIterator
    extends AbstractLazyIntIterator
    implements ArcLabelledNodeIterator.LabelledArcIterator {
        protected final LazyIntIterator underlyingIterator;
        protected final InputBitStream ibs;
        protected final Label label;
        protected final int from;

        public BitStreamLabelledArcIterator(BitStreamArcLabelledImmutableGraph alg, int x) {
            this.from = x;
            this.underlyingIterator = alg.g.successors(this.from);
            try {
                this.ibs = alg.newInputBitStream();
                this.ibs.position(alg.offset(x));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.label = alg.prototype.copy();
        }

        @Override
        public Label label() {
            return this.label;
        }

        @Override
        public int nextInt() {
            int successor = this.underlyingIterator.nextInt();
            if (successor == -1) {
                return -1;
            }
            try {
                this.label.fromBitStream(this.ibs, this.from);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return successor;
        }
    }
}

