/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.webgraph.examples;

import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.webgraph.AbstractLazyIntIterator;
import it.unimi.dsi.webgraph.BVGraph;
import it.unimi.dsi.webgraph.labelling.ArcLabelledImmutableSequentialGraph;
import it.unimi.dsi.webgraph.labelling.ArcLabelledNodeIterator;
import it.unimi.dsi.webgraph.labelling.BitStreamArcLabelledImmutableGraph;
import it.unimi.dsi.webgraph.labelling.GammaCodedIntLabel;
import it.unimi.dsi.webgraph.labelling.Label;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Comparator;
import java.util.NoSuchElementException;

public class IntegerTriplesArcLabelledImmutableGraph
extends ArcLabelledImmutableSequentialGraph {
    private final int[][] triple;
    private final GammaCodedIntLabel prototype;
    private final int n;

    public IntegerTriplesArcLabelledImmutableGraph(int[][] triple) {
        this.triple = triple;
        this.prototype = new GammaCodedIntLabel("FOO");
        int m = 0;
        for (int i = 0; i < triple.length; ++i) {
            m = Math.max(m, Math.max(triple[i][0], triple[i][1]));
        }
        Arrays.sort(triple, new Comparator<int[]>(){

            @Override
            public int compare(int[] p, int[] q) {
                int t = p[0] - q[0];
                if (t != 0) {
                    return t;
                }
                return p[1] - q[1];
            }
        });
        this.n = m + 1;
    }

    @Override
    public Label prototype() {
        return this.prototype;
    }

    @Override
    public int numNodes() {
        return this.n;
    }

    @Override
    public ArcLabelledNodeIterator nodeIterator(int from) {
        if (from == 0) {
            return this.nodeIterator();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public ArcLabelledNodeIterator nodeIterator() {
        return new ArcLabelledNodeIterator(){
            private int last = -1;
            private int pos = -1;
            private GammaCodedIntLabel label = IntegerTriplesArcLabelledImmutableGraph.access$100(IntegerTriplesArcLabelledImmutableGraph.this).copy();

            @Override
            public ArcLabelledNodeIterator.LabelledArcIterator successors() {
                if (this.last < 0) {
                    throw new IllegalStateException();
                }
                int d = this.outdegree();
                return new ArcIterator(d, this.pos, this.label);
            }

            @Override
            public int outdegree() {
                int p;
                if (this.last < 0) {
                    throw new IllegalStateException();
                }
                for (p = this.pos + 1; p < IntegerTriplesArcLabelledImmutableGraph.this.triple.length && IntegerTriplesArcLabelledImmutableGraph.this.triple[p][0] == this.last; ++p) {
                }
                return p - this.pos - 1;
            }

            public boolean hasNext() {
                return this.last < IntegerTriplesArcLabelledImmutableGraph.this.n - 1;
            }

            public int nextInt() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.last >= 0) {
                    this.pos += this.outdegree();
                }
                return ++this.last;
            }
        };
    }

    public static void main(String[] arg) throws JSAPException, IOException {
        String line;
        SimpleJSAP jsap = new SimpleJSAP(IntegerTriplesArcLabelledImmutableGraph.class.getName(), "Reads from standard input a list of triples <source,dest,label>, where the three components are separated by a TAB, and saves the corresponding arc-labelled graph using a BVGraph and a BitStreamArcLabelledImmutableGraph. Labels are represeted using GammaCodedIntLabel.", new Parameter[]{new UnflaggedOption("basename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The basename of the resulting arc-labelled graph.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            System.exit(1);
        }
        String basename = jsapResult.getString("basename");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in, "ASCII"));
        ObjectArrayList list = new ObjectArrayList();
        while ((line = br.readLine()) != null) {
            String[] p = line.split("\t");
            list.add((Object)new int[]{Integer.parseInt(p[0]), Integer.parseInt(p[1]), Integer.parseInt(p[2])});
        }
        IntegerTriplesArcLabelledImmutableGraph g = new IntegerTriplesArcLabelledImmutableGraph((int[][])list.toArray((Object[])new int[0][]));
        BVGraph.store(g, basename + "-underlying");
        BitStreamArcLabelledImmutableGraph.store(g, basename, (CharSequence)(basename + "-underlying"));
    }

    static /* synthetic */ GammaCodedIntLabel access$100(IntegerTriplesArcLabelledImmutableGraph x0) {
        return x0.prototype;
    }

    private final class ArcIterator
    extends AbstractLazyIntIterator
    implements ArcLabelledNodeIterator.LabelledArcIterator {
        private final int d;
        private int k = 0;
        private final int pos;
        private final GammaCodedIntLabel label;

        private ArcIterator(int d, int pos, GammaCodedIntLabel label) {
            this.d = d;
            this.pos = pos;
            this.label = label;
        }

        @Override
        public Label label() {
            if (this.k == 0) {
                throw new IllegalStateException();
            }
            this.label.value = IntegerTriplesArcLabelledImmutableGraph.this.triple[this.pos + this.k][2];
            return this.label;
        }

        @Override
        public int nextInt() {
            if (this.k >= this.d) {
                return -1;
            }
            return IntegerTriplesArcLabelledImmutableGraph.this.triple[this.pos + ++this.k][1];
        }
    }
}

