/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.webgraph.algo;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.Util;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.ints.AbstractIntComparator;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.lang.ObjectParser;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.webgraph.GraphClassParser;
import it.unimi.dsi.webgraph.ImmutableGraph;
import it.unimi.dsi.webgraph.LazyIntIterator;
import it.unimi.dsi.webgraph.Transform;
import it.unimi.dsi.webgraph.labelling.ArcLabelledImmutableGraph;
import it.unimi.dsi.webgraph.labelling.ArcLabelledNodeIterator;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StronglyConnectedComponents {
    private static final boolean DEBUG = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(StronglyConnectedComponents.class);
    public final int numberOfComponents;
    public final int[] component;
    public final LongArrayBitVector buckets;

    protected StronglyConnectedComponents(int numberOfComponents, int[] status, LongArrayBitVector buckets) {
        this.numberOfComponents = numberOfComponents;
        this.component = status;
        this.buckets = buckets;
    }

    public static StronglyConnectedComponents compute(ImmutableGraph graph, boolean computeBuckets, ProgressLogger pl) {
        int n = graph.numNodes();
        Visit visit = new Visit(graph, new int[n], computeBuckets ? LongArrayBitVector.ofLength((long)n) : null, pl);
        visit.run();
        return new StronglyConnectedComponents(visit.numberOfComponents, visit.status, visit.buckets);
    }

    public static StronglyConnectedComponents compute(ArcLabelledImmutableGraph graph, Transform.LabelledArcFilter filter, boolean computeBuckets, ProgressLogger pl) {
        int n = graph.numNodes();
        FilteredVisit filteredVisit = new FilteredVisit(graph, filter, new int[n], computeBuckets ? LongArrayBitVector.ofLength((long)n) : null, pl);
        filteredVisit.run();
        return new StronglyConnectedComponents(filteredVisit.numberOfComponents, filteredVisit.status, filteredVisit.buckets);
    }

    public int[] computeSizes() {
        int[] size = new int[this.numberOfComponents];
        int i = this.component.length;
        while (i-- != 0) {
            int n = this.component[i];
            size[n] = size[n] + 1;
        }
        return size;
    }

    public void sortBySize(final int[] size) {
        int[] perm = Util.identity((int)size.length);
        IntArrays.quickSort((int[])perm, (int)0, (int)perm.length, (IntComparator)new AbstractIntComparator(){

            public int compare(int x, int y) {
                return size[y] - size[x];
            }
        });
        int[] copy = (int[])size.clone();
        int i = size.length;
        while (i-- != 0) {
            size[i] = copy[perm[i]];
        }
        Util.invertPermutationInPlace((int[])perm);
        i = this.component.length;
        while (i-- != 0) {
            this.component[i] = perm[this.component[i]];
        }
    }

    public static void main(String[] arg) throws IOException, JSAPException {
        StronglyConnectedComponents components;
        SimpleJSAP jsap = new SimpleJSAP(StronglyConnectedComponents.class.getName(), "Computes the strongly connected components (and optionally the buckets) of a graph of given basename. The resulting data is saved in files stemmed from the given basename with extension .scc (a list of binary integers specifying the component of each node), .sccsizes (a list of binary integer specifying the size of each component) and .buckets  (a serialised LongArrayBigVector specifying buckets). Please use suitable JVM options to set a large stack size.", new Parameter[]{new Switch("sizes", 's', "sizes", "Compute component sizes."), new Switch("renumber", 'r', "renumber", "Renumber components in decreasing-size order."), new Switch("buckets", 'b', "buckets", "Compute buckets (nodes belonging to a bucket component, i.e., a terminal nondangling component)."), new FlaggedOption("filter", (StringParser)new ObjectParser(Transform.LabelledArcFilter.class, GraphClassParser.PACKAGE), JSAP.NO_DEFAULT, false, 'f', "filter", "A filter for labelled arcs; requires the provided graph to be arc labelled."), new FlaggedOption("logInterval", (StringParser)JSAP.LONG_PARSER, Long.toString(10000L), false, 'l', "log-interval", "The minimum time interval between activity logs in milliseconds."), new UnflaggedOption("basename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The basename of the graph."), new UnflaggedOption("resultsBasename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, false, "The basename of the resulting files.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            System.exit(1);
        }
        String basename = jsapResult.getString("basename");
        String resultsBasename = jsapResult.getString("resultsBasename", basename);
        Transform.LabelledArcFilter filter = (Transform.LabelledArcFilter)jsapResult.getObject("filter");
        ProgressLogger pl = new ProgressLogger(LOGGER, jsapResult.getLong("logInterval"), TimeUnit.MILLISECONDS);
        StronglyConnectedComponents stronglyConnectedComponents = components = filter != null ? StronglyConnectedComponents.compute(ArcLabelledImmutableGraph.load(basename), filter, jsapResult.getBoolean("buckets"), pl) : StronglyConnectedComponents.compute(ImmutableGraph.load(basename), jsapResult.getBoolean("buckets"), pl);
        if (jsapResult.getBoolean("sizes") || jsapResult.getBoolean("renumber")) {
            int[] size = components.computeSizes();
            if (jsapResult.getBoolean("renumber")) {
                components.sortBySize(size);
            }
            if (jsapResult.getBoolean("sizes")) {
                BinIO.storeInts((int[])size, (CharSequence)(resultsBasename + ".sccsizes"));
            }
        }
        BinIO.storeInts((int[])components.component, (CharSequence)(resultsBasename + ".scc"));
        if (components.buckets != null) {
            BinIO.storeObject((Object)components.buckets, (CharSequence)(resultsBasename + ".buckets"));
        }
    }

    private static final class FilteredVisit {
        private final ArcLabelledImmutableGraph graph;
        private final int n;
        private final ProgressLogger pl;
        private final Transform.LabelledArcFilter filter;
        private final boolean computeBuckets;
        private final int[] status;
        private final LongArrayBitVector buckets;
        private final IntArrayList componentStack;
        private int clock;
        private int numberOfComponents;

        private FilteredVisit(ArcLabelledImmutableGraph graph, Transform.LabelledArcFilter filter, int[] status, LongArrayBitVector buckets, ProgressLogger pl) {
            this.graph = graph;
            this.filter = filter;
            this.buckets = buckets;
            this.status = status;
            this.pl = pl;
            this.computeBuckets = buckets != null;
            this.n = graph.numNodes();
            this.componentStack = new IntArrayList(this.n);
        }

        private long filteredOutdegree(int node) {
            int s;
            long filteredOutdegree = 0L;
            ArcLabelledNodeIterator.LabelledArcIterator successors = this.graph.successors(node);
            while ((s = successors.nextInt()) != -1) {
                if (!this.filter.accept(node, s, successors.label())) continue;
                ++filteredOutdegree;
            }
            return filteredOutdegree;
        }

        private void visit(int startNode) {
            LongArrayBitVector olderNodeFound = LongArrayBitVector.ofLength((long)this.n);
            IntArrayList nodeStack = new IntArrayList();
            ObjectArrayList successorsStack = new ObjectArrayList();
            int[] status = this.status;
            LongArrayBitVector nonBuckets = this.buckets;
            status[startNode] = ++this.clock;
            this.componentStack.push(startNode);
            nodeStack.push(startNode);
            successorsStack.push((Object)this.graph.successors(startNode));
            if (this.computeBuckets && this.filteredOutdegree(startNode) == 0L) {
                nonBuckets.set(startNode);
            }
            block0: while (!nodeStack.isEmpty()) {
                int z;
                int s;
                int currentNode = nodeStack.topInt();
                ArcLabelledNodeIterator.LabelledArcIterator successors = (ArcLabelledNodeIterator.LabelledArcIterator)successorsStack.top();
                while ((s = successors.nextInt()) != -1) {
                    if (!this.filter.accept(currentNode, s, successors.label())) continue;
                    int successorStatus = status[s];
                    if (successorStatus == 0) {
                        status[s] = ++this.clock;
                        nodeStack.push(s);
                        this.componentStack.push(s);
                        successorsStack.push((Object)this.graph.successors(s));
                        if (!this.computeBuckets || this.filteredOutdegree(s) != 0L) continue block0;
                        nonBuckets.set(s);
                        continue block0;
                    }
                    if (successorStatus > 0) {
                        if (successorStatus >= status[currentNode]) continue;
                        status[currentNode] = successorStatus;
                        olderNodeFound.set(currentNode);
                        continue;
                    }
                    if (!this.computeBuckets) continue;
                    nonBuckets.set(currentNode);
                }
                nodeStack.pop();
                successorsStack.pop();
                if (this.pl != null) {
                    this.pl.lightUpdate();
                }
                if (olderNodeFound.getBoolean(currentNode)) {
                    int currentNodeStatus = status[currentNode];
                    int parentNode = nodeStack.topInt();
                    if (currentNodeStatus < status[parentNode]) {
                        status[parentNode] = currentNodeStatus;
                        olderNodeFound.set(parentNode);
                    }
                    if (!this.computeBuckets || !nonBuckets.getBoolean(currentNode)) continue;
                    nonBuckets.set(parentNode);
                    continue;
                }
                if (this.computeBuckets && !nodeStack.isEmpty()) {
                    nonBuckets.set(nodeStack.topInt());
                }
                boolean notABucket = this.computeBuckets ? nonBuckets.getBoolean(currentNode) : false;
                ++this.numberOfComponents;
                do {
                    z = this.componentStack.popInt();
                    status[z] = -this.numberOfComponents;
                    if (!notABucket) continue;
                    nonBuckets.set(z);
                } while (z != currentNode);
            }
        }

        public void run() {
            if (this.pl != null) {
                this.pl.itemsName = "nodes";
                this.pl.expectedUpdates = this.n;
                this.pl.displayFreeMemory = true;
                this.pl.start((CharSequence)"Computing strongly connected components...");
            }
            for (int x = 0; x < this.n; ++x) {
                if (this.status[x] != 0) continue;
                this.visit(x);
            }
            if (this.pl != null) {
                this.pl.done();
            }
            int i = this.status.length;
            while (i-- != 0) {
                this.status[i] = -this.status[i] - 1;
            }
            if (this.buckets != null) {
                this.buckets.flip();
            }
        }
    }

    private static final class Visit {
        private final ImmutableGraph graph;
        private final int n;
        private final ProgressLogger pl;
        private final boolean computeBuckets;
        private final int[] status;
        private final LongArrayBitVector buckets;
        private final IntArrayList componentStack;
        private int clock;
        private int numberOfComponents;

        private Visit(ImmutableGraph graph, int[] status, LongArrayBitVector buckets, ProgressLogger pl) {
            this.graph = graph;
            this.buckets = buckets;
            this.status = status;
            this.pl = pl;
            this.computeBuckets = buckets != null;
            this.n = graph.numNodes();
            this.componentStack = new IntArrayList(this.n);
        }

        private void visit(int startNode) {
            BooleanArrayList olderNodeFound = new BooleanArrayList();
            IntArrayList nodeStack = new IntArrayList();
            ObjectArrayList successorsStack = new ObjectArrayList();
            int[] status = this.status;
            LongArrayBitVector nonBuckets = this.buckets;
            status[startNode] = ++this.clock;
            this.componentStack.push(startNode);
            nodeStack.push(startNode);
            successorsStack.push((Object)this.graph.successors(startNode));
            olderNodeFound.push(false);
            if (this.computeBuckets && this.graph.outdegree(startNode) == 0) {
                nonBuckets.set(startNode);
            }
            block0: while (!nodeStack.isEmpty()) {
                int z;
                int s;
                int currentNode = nodeStack.topInt();
                LazyIntIterator successors = (LazyIntIterator)successorsStack.top();
                while ((s = successors.nextInt()) != -1) {
                    int successorStatus = status[s];
                    if (successorStatus == 0) {
                        status[s] = ++this.clock;
                        nodeStack.push(s);
                        this.componentStack.push(s);
                        successorsStack.push((Object)this.graph.successors(s));
                        olderNodeFound.push(false);
                        if (!this.computeBuckets || this.graph.outdegree(s) != 0) continue block0;
                        nonBuckets.set(s);
                        continue block0;
                    }
                    if (successorStatus > 0) {
                        if (successorStatus >= status[currentNode]) continue;
                        status[currentNode] = successorStatus;
                        olderNodeFound.pop();
                        olderNodeFound.push(true);
                        continue;
                    }
                    if (!this.computeBuckets) continue;
                    nonBuckets.set(currentNode);
                }
                nodeStack.pop();
                successorsStack.pop();
                if (this.pl != null) {
                    this.pl.lightUpdate();
                }
                if (olderNodeFound.popBoolean()) {
                    int currentNodeStatus = status[currentNode];
                    int parentNode = nodeStack.topInt();
                    if (currentNodeStatus < status[parentNode]) {
                        status[parentNode] = currentNodeStatus;
                        olderNodeFound.pop();
                        olderNodeFound.push(true);
                    }
                    if (!this.computeBuckets || !nonBuckets.getBoolean(currentNode)) continue;
                    nonBuckets.set(parentNode);
                    continue;
                }
                if (this.computeBuckets && !nodeStack.isEmpty()) {
                    nonBuckets.set(nodeStack.topInt());
                }
                boolean notABucket = this.computeBuckets ? nonBuckets.getBoolean(currentNode) : false;
                ++this.numberOfComponents;
                do {
                    z = this.componentStack.popInt();
                    status[z] = -this.numberOfComponents;
                    if (!notABucket) continue;
                    nonBuckets.set(z);
                } while (z != currentNode);
            }
        }

        public void run() {
            if (this.pl != null) {
                this.pl.itemsName = "nodes";
                this.pl.expectedUpdates = this.n;
                this.pl.displayFreeMemory = true;
                this.pl.start((CharSequence)"Computing strongly connected components...");
            }
            for (int x = 0; x < this.n; ++x) {
                if (this.status[x] != 0) continue;
                this.visit(x);
            }
            if (this.pl != null) {
                this.pl.done();
            }
            int i = this.status.length;
            while (i-- != 0) {
                this.status[i] = -this.status[i] - 1;
            }
            if (this.buckets != null) {
                this.buckets.flip();
            }
        }
    }
}

