/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.webgraph.algo;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.fastutil.objects.AbstractObjectList;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.stat.Jackknife;
import it.unimi.dsi.util.XorShift1024StarRandom;
import it.unimi.dsi.webgraph.ImmutableGraph;
import it.unimi.dsi.webgraph.algo.ApproximateNeighbourhoodFunctions;
import it.unimi.dsi.webgraph.algo.ParallelBreadthFirstVisit;
import java.io.IOException;
import java.math.RoundingMode;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SampleDistanceCumulativeDistributionFunction {
    private static final Logger LOGGER = LoggerFactory.getLogger(SampleDistanceCumulativeDistributionFunction.class);

    private static int visitedNodes(ParallelBreadthFirstVisit visit, int visitedNodes) {
        if (visit.queue.size() != visit.graph.numNodes()) {
            if (visitedNodes == -1) {
                visitedNodes = visit.queue.size();
                LOGGER.warn("The graph is not strongly connected: visiting " + visitedNodes + " < " + visit.graph.numNodes() + " nodes");
            } else if (visitedNodes != visit.queue.size()) {
                throw new IllegalStateException("Queue size (" + visit.queue.size() + ") is different from the number of previously visited nodes (" + visitedNodes + "): maybe the graph is not symmetric.");
            }
        }
        return visitedNodes;
    }

    protected static int[][] sample(ImmutableGraph graph, int k, int threads) {
        return SampleDistanceCumulativeDistributionFunction.sample(graph, k, false, threads);
    }

    protected static int[][] sample(ImmutableGraph graph, int k, boolean naive, int threads) {
        ParallelBreadthFirstVisit visit = new ParallelBreadthFirstVisit(graph, threads, false, new ProgressLogger(LOGGER, "nodes"));
        XorShift1024StarRandom random = new XorShift1024StarRandom();
        int componentSize = -1;
        int[][] result = new int[k][];
        int i = k;
        while (i-- != 0) {
            visit.clear();
            visit.visit(visit.queue.isEmpty() || naive ? random.nextInt(visit.graph.numNodes()) : visit.queue.getInt(random.nextInt(visit.queue.size())), componentSize);
            if (!naive) {
                componentSize = SampleDistanceCumulativeDistributionFunction.visitedNodes(visit, componentSize);
            }
            int maxDistance = visit.maxDistance();
            result[i] = new int[maxDistance + 1];
            for (int d = 0; d <= maxDistance; ++d) {
                result[i][d] = visit.cutPoints.getInt(d + 1);
            }
        }
        return result;
    }

    public static void main(String[] arg) throws IOException, JSAPException {
        SimpleJSAP jsap = new SimpleJSAP(SampleDistanceCumulativeDistributionFunction.class.getName(), "Estimates the neighbourhood function, the distance cumulative distribution function and the distance probability mass function by sampling.The output files contains nine columns: for each function, we give the value, the standard error and the relativestandard error as a percentage (all estimated by the jacknife).", new Parameter[]{new Switch("mapped", 'm', "mapped", "Do not load the graph in main memory, but rather memory-map it."), new FlaggedOption("threads", (StringParser)JSAP.INTSIZE_PARSER, "0", false, 'T', "threads", "The number of threads to be used. If 0, the number will be estimated automatically."), new FlaggedOption("samples", (StringParser)JSAP.INTSIZE_PARSER, "1000", false, 's', "samples", "The number of samples (breadth-first visits)."), new Switch("naive", 'n', "naive", "Sample naively: pick nodes at random and do not stop sampling even when detecting the lack of strong connection."), new UnflaggedOption("basename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The basename of the graph.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            System.exit(1);
        }
        String basename = jsapResult.getString("basename");
        final ImmutableGraph graph = jsapResult.userSpecified("mapped") ? ImmutableGraph.loadMapped(basename) : ImmutableGraph.load(basename);
        final int[][] sample = SampleDistanceCumulativeDistributionFunction.sample(graph, jsapResult.getInt("samples"), jsapResult.userSpecified("naive"), jsapResult.getInt("threads"));
        int l = 0;
        for (int[] s : sample) {
            l = Math.max(l, s.length);
        }
        final int length = l;
        AbstractObjectList<double[]> samples = new AbstractObjectList<double[]>(){

            public double[] get(int index) {
                double[] result = new double[length];
                int[] s = sample[index];
                double n = graph.numNodes();
                for (int i = 0; i < length; ++i) {
                    result[i] = (double)s[Math.min(i, s.length - 1)] * n;
                }
                return result;
            }

            public int size() {
                return sample.length;
            }
        };
        Jackknife nf = Jackknife.compute((List)samples, (Jackknife.Statistic)Jackknife.IDENTITY);
        Jackknife cdf = Jackknife.compute((List)samples, (Jackknife.Statistic)ApproximateNeighbourhoodFunctions.CDF);
        Jackknife pmf = Jackknife.compute((List)samples, (Jackknife.Statistic)ApproximateNeighbourhoodFunctions.PMF);
        for (int i = 0; i < pmf.estimate.length; ++i) {
            System.out.println(nf.bigEstimate[i].setScale(30, RoundingMode.HALF_EVEN) + "\t" + nf.standardError[i] + "\t" + 100.0 * nf.standardError[i] / nf.estimate[i] + "\t" + cdf.bigEstimate[i].setScale(30, RoundingMode.HALF_EVEN) + "\t" + cdf.standardError[i] + "\t" + 100.0 * cdf.standardError[i] / cdf.estimate[i] + "\t" + pmf.bigEstimate[i].setScale(30, RoundingMode.HALF_EVEN) + "\t" + pmf.standardError[i] + "\t" + 100.0 * pmf.standardError[i] / pmf.estimate[i]);
        }
    }
}

