/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.webgraph.algo;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.webgraph.ImmutableGraph;
import it.unimi.dsi.webgraph.LazyIntIterator;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;

public class ParallelBreadthFirstVisit {
    public final ImmutableGraph graph;
    public final IntArrayList queue;
    public final IntArrayList cutPoints;
    public final boolean parent;
    public final AtomicIntegerArray marker;
    private final ProgressLogger pl;
    private final int numberOfThreads;
    private final AtomicInteger progress;
    private final AtomicLong nextPosition;
    private volatile boolean completed;
    private volatile CyclicBarrier barrier;
    private volatile Throwable threadThrowable;
    public int round;

    public ParallelBreadthFirstVisit(ImmutableGraph graph, int requestedThreads, boolean parent, ProgressLogger pl) {
        this.graph = graph;
        this.parent = parent;
        this.pl = pl;
        this.marker = new AtomicIntegerArray(graph.numNodes());
        this.queue = new IntArrayList(graph.numNodes());
        this.progress = new AtomicInteger();
        this.nextPosition = new AtomicLong();
        this.cutPoints = new IntArrayList();
        this.numberOfThreads = requestedThreads != 0 ? requestedThreads : Runtime.getRuntime().availableProcessors();
        this.clear();
    }

    public void clear() {
        this.round = -1;
        int i = this.marker.length();
        while (i-- != 0) {
            this.marker.set(i, -1);
        }
    }

    public int visit(int start) {
        return this.visit(start, -1);
    }

    public int visit(int start, int expectedSize) {
        if (this.marker.get(start) != -1) {
            return 0;
        }
        ++this.round;
        this.completed = false;
        this.queue.clear();
        this.cutPoints.clear();
        this.queue.add(start);
        this.cutPoints.add(0);
        this.marker.set(start, this.parent ? start : this.round);
        IterationThread[] thread = new IterationThread[this.numberOfThreads];
        int i = thread.length;
        while (i-- != 0) {
            thread[i] = new IterationThread();
        }
        this.progress.set(0);
        if (this.pl != null) {
            this.pl.start((CharSequence)"Starting visit...");
            this.pl.expectedUpdates = expectedSize != -1 ? (long)expectedSize : (long)this.graph.numNodes();
            this.pl.itemsName = "nodes";
        }
        this.barrier = new CyclicBarrier(this.numberOfThreads, new Runnable(){

            @Override
            public void run() {
                if (ParallelBreadthFirstVisit.this.pl != null) {
                    ParallelBreadthFirstVisit.this.pl.set((long)ParallelBreadthFirstVisit.this.progress.get());
                }
                if (ParallelBreadthFirstVisit.this.queue.size() == ParallelBreadthFirstVisit.this.cutPoints.getInt(ParallelBreadthFirstVisit.this.cutPoints.size() - 1)) {
                    ParallelBreadthFirstVisit.this.completed = true;
                    return;
                }
                ParallelBreadthFirstVisit.this.cutPoints.add(ParallelBreadthFirstVisit.this.queue.size());
                ParallelBreadthFirstVisit.this.nextPosition.set(0L);
            }
        });
        i = thread.length;
        while (i-- != 0) {
            thread[i].start();
        }
        i = thread.length;
        while (i-- != 0) {
            try {
                thread[i].join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.threadThrowable != null) {
            throw new RuntimeException(this.threadThrowable);
        }
        if (this.pl != null) {
            this.pl.done();
        }
        return this.queue.size();
    }

    public void visitAll() {
        IterationThread[] thread = new IterationThread[this.numberOfThreads];
        int i = thread.length;
        while (i-- != 0) {
            thread[i] = new IterationThread();
        }
        final int n = this.graph.numNodes();
        this.completed = false;
        this.clear();
        this.queue.clear();
        this.cutPoints.clear();
        this.progress.set(0);
        if (this.pl != null) {
            this.pl.start((CharSequence)"Starting visits...");
            this.pl.expectedUpdates = this.graph.numNodes();
            this.pl.displayLocalSpeed = true;
            this.pl.itemsName = "nodes";
        }
        this.barrier = new CyclicBarrier(this.numberOfThreads, new Runnable(){
            int curr = -1;

            @Override
            public void run() {
                if (ParallelBreadthFirstVisit.this.pl != null) {
                    ParallelBreadthFirstVisit.this.pl.set((long)ParallelBreadthFirstVisit.this.progress.get());
                }
                if (this.curr == -1 || ParallelBreadthFirstVisit.this.queue.size() == ParallelBreadthFirstVisit.this.cutPoints.getInt(ParallelBreadthFirstVisit.this.cutPoints.size() - 1)) {
                    if (ParallelBreadthFirstVisit.this.pl != null) {
                        ParallelBreadthFirstVisit.this.pl.set((long)ParallelBreadthFirstVisit.this.progress.get());
                    }
                    while (true) {
                        if (++this.curr < n && ParallelBreadthFirstVisit.this.marker.get(this.curr) != -1) {
                            continue;
                        }
                        if (this.curr == n) {
                            ParallelBreadthFirstVisit.this.completed = true;
                            return;
                        }
                        ++ParallelBreadthFirstVisit.this.round;
                        ParallelBreadthFirstVisit.this.marker.set(this.curr, ParallelBreadthFirstVisit.this.parent ? this.curr : ParallelBreadthFirstVisit.this.round);
                        int d = ParallelBreadthFirstVisit.this.graph.outdegree(this.curr);
                        if (d != 0 && (d != 1 || ParallelBreadthFirstVisit.this.graph.successors(this.curr).nextInt() != this.curr)) break;
                    }
                    ParallelBreadthFirstVisit.this.queue.clear();
                    ParallelBreadthFirstVisit.this.queue.add(this.curr);
                    ParallelBreadthFirstVisit.this.cutPoints.clear();
                    ParallelBreadthFirstVisit.this.cutPoints.add(0);
                }
                ParallelBreadthFirstVisit.this.cutPoints.add(ParallelBreadthFirstVisit.this.queue.size());
                ParallelBreadthFirstVisit.this.nextPosition.set(0L);
            }
        });
        int i2 = thread.length;
        while (i2-- != 0) {
            thread[i2].start();
        }
        i2 = thread.length;
        while (i2-- != 0) {
            try {
                thread[i2].join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.threadThrowable != null) {
            throw new RuntimeException(this.threadThrowable);
        }
        if (this.pl != null) {
            this.pl.done();
        }
    }

    public int nodeAtMaxDistance() {
        return this.queue.getInt(this.queue.size() - 1);
    }

    public int maxDistance() {
        return this.cutPoints.size() - 2;
    }

    private final class IterationThread
    extends Thread {
        private static final int GRANULARITY = 1000;

        private IterationThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                AtomicIntegerArray marker = ParallelBreadthFirstVisit.this.marker;
                ImmutableGraph graph = ParallelBreadthFirstVisit.this.graph.copy();
                boolean parent = ParallelBreadthFirstVisit.this.parent;
                block4: while (true) {
                    ParallelBreadthFirstVisit.this.barrier.await();
                    if (ParallelBreadthFirstVisit.this.completed) {
                        return;
                    }
                    IntArrayList out = new IntArrayList();
                    int first = ParallelBreadthFirstVisit.this.cutPoints.getInt(ParallelBreadthFirstVisit.this.cutPoints.size() - 2);
                    int last = ParallelBreadthFirstVisit.this.cutPoints.getInt(ParallelBreadthFirstVisit.this.cutPoints.size() - 1);
                    int mark = ParallelBreadthFirstVisit.this.round;
                    while (true) {
                        long start;
                        if ((start = (long)first + ParallelBreadthFirstVisit.this.nextPosition.getAndAdd(1000L)) >= (long)last) {
                            ParallelBreadthFirstVisit.this.nextPosition.getAndAdd(-1000L);
                            continue block4;
                        }
                        int end = (int)Math.min((long)last, start + 1000L);
                        out.clear();
                        for (int pos = (int)start; pos < end; ++pos) {
                            int s;
                            int curr = ParallelBreadthFirstVisit.this.queue.getInt(pos);
                            if (parent) {
                                mark = curr;
                            }
                            LazyIntIterator successors = graph.successors(curr);
                            while ((s = successors.nextInt()) != -1) {
                                if (!marker.compareAndSet(s, -1, mark)) continue;
                                out.add(s);
                            }
                        }
                        ParallelBreadthFirstVisit.this.progress.addAndGet(end - (int)start);
                        if (out.isEmpty()) continue;
                        IntArrayList intArrayList = ParallelBreadthFirstVisit.this.queue;
                        synchronized (intArrayList) {
                            ParallelBreadthFirstVisit.this.queue.addAll((IntList)out);
                        }
                    }
                    break;
                }
            }
            catch (Throwable t) {
                ParallelBreadthFirstVisit.this.threadThrowable = t;
                return;
            }
        }
    }
}

