/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.webgraph.algo;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.fastutil.io.TextIO;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.webgraph.ArrayListMutableGraph;
import it.unimi.dsi.webgraph.ImmutableGraph;
import it.unimi.dsi.webgraph.algo.ParallelBreadthFirstVisit;
import java.io.IOException;
import java.io.PrintStream;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NeighbourhoodFunction {
    private static final Logger LOGGER = LoggerFactory.getLogger(NeighbourhoodFunction.class);

    public static double[] compute(ImmutableGraph g) {
        return NeighbourhoodFunction.compute(g, null);
    }

    public static double[] compute(ImmutableGraph g, ProgressLogger pl) {
        return NeighbourhoodFunction.compute(g, 0, pl);
    }

    public static double[] compute(ImmutableGraph g, int threads, ProgressLogger pl) {
        long[] computeExact = NeighbourhoodFunction.computeExact(g, threads, pl);
        double[] result = new double[computeExact.length];
        int i = result.length;
        while (i-- != 0) {
            result[i] = computeExact[i];
        }
        return result;
    }

    public static long[] computeExact(ImmutableGraph g, int threads, ProgressLogger pl) {
        int n = g.numNodes();
        long[] count = LongArrays.EMPTY_ARRAY;
        ParallelBreadthFirstVisit visit = new ParallelBreadthFirstVisit(g, threads, true, null);
        if (pl != null) {
            pl.itemsName = "nodes";
            pl.expectedUpdates = n;
            pl.start();
        }
        for (int i = 0; i < n; ++i) {
            visit.clear();
            visit.visit(i);
            int maxDistance = visit.maxDistance();
            if (count.length <= maxDistance) {
                count = LongArrays.grow((long[])count, (int)(maxDistance + 1));
            }
            int d = maxDistance + 1;
            while (d-- != 0) {
                int n2 = d;
                count[n2] = count[n2] + (long)(visit.cutPoints.getInt(d + 1) - visit.cutPoints.getInt(d));
            }
            if (pl == null) continue;
            pl.update();
        }
        if (pl != null) {
            pl.done();
        }
        int last = count.length;
        while (last-- != 0 && count[last] == 0L) {
        }
        long[] result = new long[++last];
        result[0] = count[0];
        for (int i = 1; i < last; ++i) {
            result[i] = result[i - 1] + count[i];
        }
        return result;
    }

    public static double[] distanceCumulativeDistributionFunction(double[] neighbourhoodFunction) {
        double[] result = (double[])neighbourhoodFunction.clone();
        double lastValue = result[result.length - 1];
        int d = result.length;
        while (d-- != 0) {
            int n = d;
            result[n] = result[n] / lastValue;
        }
        return result;
    }

    public static double[] distanceProbabilityMassFunction(double[] neighbourhoodFunction) {
        double[] result = (double[])neighbourhoodFunction.clone();
        double lastValue = result[result.length - 1];
        int d = result.length;
        while (d-- != 0) {
            int n = d;
            result[n] = result[n] / lastValue;
        }
        d = result.length;
        while (d-- != 1) {
            int n = d;
            result[n] = result[n] - result[d - 1];
        }
        return result;
    }

    public static double effectiveDiameter(double alpha, double[] neighbourhoodFunction) {
        double finalFraction = neighbourhoodFunction[neighbourhoodFunction.length - 1];
        int d = 0;
        while (neighbourhoodFunction[d] / finalFraction < alpha) {
            ++d;
        }
        if (d == 0) {
            return (double)d + (alpha * finalFraction - neighbourhoodFunction[d]) / neighbourhoodFunction[d];
        }
        return (double)d + (alpha * finalFraction - neighbourhoodFunction[d]) / (neighbourhoodFunction[d] - neighbourhoodFunction[d - 1]);
    }

    public static double effectiveDiameter(double[] neighbourhoodFunction) {
        return NeighbourhoodFunction.effectiveDiameter(0.9, neighbourhoodFunction);
    }

    public static double medianDistance(double[] neighbourhoodFunction) {
        return NeighbourhoodFunction.medianDistance((int)Math.round(neighbourhoodFunction[0]), neighbourhoodFunction);
    }

    public static double medianDistance(int n, double[] neighbourhoodFunction) {
        double halfPairs = 0.5 * (double)n * (double)n;
        int d = neighbourhoodFunction.length;
        while (d-- != 0 && neighbourhoodFunction[d] > halfPairs) {
        }
        return d == neighbourhoodFunction.length - 1 ? Double.POSITIVE_INFINITY : (double)(d + 1);
    }

    public static double spid(double[] neighbourhoodFunction) {
        double[] distanceProbabilityMassFunction = NeighbourhoodFunction.distanceProbabilityMassFunction(neighbourhoodFunction);
        double mean = 0.0;
        double meanOfSquares = 0.0;
        for (int i = 0; i < distanceProbabilityMassFunction.length; ++i) {
            mean += distanceProbabilityMassFunction[i] * (double)i;
            meanOfSquares += distanceProbabilityMassFunction[i] * (double)i * (double)i;
        }
        return (meanOfSquares - mean * mean) / mean;
    }

    public static double averageDistance(double[] neighbourhoodFunction) {
        double[] distanceProbabilityMassFunction = NeighbourhoodFunction.distanceProbabilityMassFunction(neighbourhoodFunction);
        double mean = 0.0;
        for (int i = 0; i < distanceProbabilityMassFunction.length; ++i) {
            mean += distanceProbabilityMassFunction[i] * (double)i;
        }
        return mean;
    }

    public static double harmonicDiameter(double[] neighbourhoodFunction) {
        return NeighbourhoodFunction.harmonicDiameter((int)Math.round(neighbourhoodFunction[0]), neighbourhoodFunction);
    }

    public static double harmonicDiameter(int n, double[] neighbourhoodFunction) {
        double t = 0.0;
        for (int i = 1; i < neighbourhoodFunction.length; ++i) {
            t += (neighbourhoodFunction[i] - neighbourhoodFunction[i - 1]) / (double)i;
        }
        return (double)n * (double)(n - 1) / t;
    }

    public static void main(String[] arg) throws IOException, JSAPException {
        SimpleJSAP jsap = new SimpleJSAP(NeighbourhoodFunction.class.getName(), "Prints the neighbourhood function of a graph, computing it via breadth-first visits.", new Parameter[]{new FlaggedOption("logInterval", (StringParser)JSAP.LONG_PARSER, Long.toString(10000L), false, 'l', "log-interval", "The minimum time interval between activity logs in milliseconds."), new Switch("expand", 'e', "expand", "Expand the graph to increase speed (no compression)."), new FlaggedOption("threads", (StringParser)JSAP.INTSIZE_PARSER, "0", false, 'T', "threads", "The number of threads to be used. If 0, the number will be estimated automatically."), new UnflaggedOption("basename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The basename of the graph.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            System.exit(1);
        }
        String basename = jsapResult.getString("basename");
        int threads = jsapResult.getInt("threads");
        ProgressLogger pl = new ProgressLogger(LOGGER, jsapResult.getLong("logInterval"), TimeUnit.MILLISECONDS);
        ImmutableGraph g = ImmutableGraph.load(basename);
        if (jsapResult.userSpecified("expand")) {
            g = new ArrayListMutableGraph(g).immutableView();
        }
        TextIO.storeLongs((long[])NeighbourhoodFunction.computeExact(g, threads, pl), (PrintStream)System.out);
    }
}

