/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.webgraph.algo;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.Util;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.lang.ObjectParser;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.util.XorShift1024StarRandom;
import it.unimi.dsi.webgraph.GraphClassParser;
import it.unimi.dsi.webgraph.ImmutableGraph;
import it.unimi.dsi.webgraph.algo.ParallelBreadthFirstVisit;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FourSweepIterativeFringeDiameter {
    private static final Logger LOGGER = LoggerFactory.getLogger(FourSweepIterativeFringeDiameter.class);

    private static int componentSize(ParallelBreadthFirstVisit visit, int componentSize) {
        if (visit.queue.size() != visit.graph.numNodes()) {
            if (componentSize == -1) {
                componentSize = visit.queue.size();
                LOGGER.warn("The graph is not connected: computing the diameter of a component of " + componentSize + " < " + visit.graph.numNodes() + " nodes");
            } else if (componentSize != visit.queue.size()) {
                throw new IllegalStateException("Queue size (" + visit.queue.size() + ") is different from component size (" + componentSize + "): maybe the graph is not symmetric.");
            }
        }
        return componentSize;
    }

    public static int run(ImmutableGraph symGraph, int threads, ProgressLogger pl, long seed) {
        ParallelBreadthFirstVisit visit = new ParallelBreadthFirstVisit(symGraph, threads, true, pl);
        AtomicIntegerArray parent = visit.marker;
        XorShift1024StarRandom random = new XorShift1024StarRandom(seed);
        int n = symGraph.numNodes();
        int lowerBound = 0;
        int upperBound = n - 1;
        int componentSize = -1;
        while (lowerBound < upperBound) {
            ProgressLogger globalProgressLogger;
            if (pl != null) {
                pl.logger().info("New round of bound refinement... [" + lowerBound + ".." + upperBound + "]");
            }
            visit.clear();
            visit.visit(visit.queue.isEmpty() ? random.nextInt(n) : visit.queue.getInt(random.nextInt(visit.queue.size())), componentSize);
            int border = visit.nodeAtMaxDistance();
            componentSize = FourSweepIterativeFringeDiameter.componentSize(visit, componentSize);
            lowerBound = Math.max(visit.maxDistance(), lowerBound);
            upperBound = Math.min(upperBound, 2 * visit.maxDistance());
            if (pl != null) {
                pl.logger().info("After visit from random node: [" + lowerBound + ".." + upperBound + "]");
            }
            if (lowerBound == upperBound) break;
            visit.clear();
            visit.visit(border, componentSize);
            border = visit.nodeAtMaxDistance();
            componentSize = FourSweepIterativeFringeDiameter.componentSize(visit, componentSize);
            lowerBound = Math.max(visit.maxDistance(), lowerBound);
            upperBound = Math.min(upperBound, 2 * visit.maxDistance());
            if (pl != null) {
                pl.logger().info("After first double sweep: [" + lowerBound + ".." + upperBound + "]");
            }
            if (lowerBound == upperBound) break;
            int center = border;
            int i = visit.maxDistance() / 2;
            while (i-- != 0) {
                center = parent.get(center);
            }
            visit.clear();
            visit.visit(center, componentSize);
            border = visit.nodeAtMaxDistance();
            componentSize = FourSweepIterativeFringeDiameter.componentSize(visit, componentSize);
            lowerBound = Math.max(visit.maxDistance(), lowerBound);
            upperBound = Math.min(upperBound, 2 * visit.maxDistance());
            if (pl != null) {
                pl.logger().info("After visit from first tentative center (node " + center + "): [" + lowerBound + ".." + upperBound + "]");
            }
            if (lowerBound == upperBound) break;
            visit.clear();
            visit.visit(border);
            border = visit.nodeAtMaxDistance();
            componentSize = FourSweepIterativeFringeDiameter.componentSize(visit, componentSize);
            lowerBound = Math.max(visit.maxDistance(), lowerBound);
            upperBound = Math.min(upperBound, 2 * visit.maxDistance());
            if (pl != null) {
                pl.logger().info("After second double sweep: [" + lowerBound + ".." + upperBound + "]");
            }
            if (lowerBound == upperBound) break;
            center = border;
            i = visit.maxDistance() / 2;
            while (i-- != 0) {
                center = parent.get(center);
            }
            visit.clear();
            visit.visit(center, componentSize);
            componentSize = FourSweepIterativeFringeDiameter.componentSize(visit, componentSize);
            lowerBound = Math.max(visit.maxDistance(), lowerBound);
            upperBound = Math.min(upperBound, 2 * visit.maxDistance());
            if (pl != null) {
                pl.logger().info("After visit from new center (node " + center + "): [" + lowerBound + ".." + upperBound + "]");
            }
            if (lowerBound == upperBound) break;
            IntArrayList cutPoints = visit.cutPoints.clone();
            IntArrayList queue = visit.queue.clone();
            ProgressLogger progressLogger = globalProgressLogger = pl == null ? null : new ProgressLogger(pl.logger(), pl.logInterval, TimeUnit.MILLISECONDS, "visits");
            if (pl != null) {
                pl.logger().debug("Cutpoints: " + cutPoints);
                globalProgressLogger.start((CharSequence)"Starting visits...");
            }
            int maxEcc = 0;
            for (int d = visit.maxDistance(); d > 0 && lowerBound < upperBound; --d) {
                if (pl != null) {
                    globalProgressLogger.expectedUpdates = pl.count + (long)cutPoints.getInt(d + 1) - (long)cutPoints.getInt(lowerBound / 2 + 1);
                    pl.logger().info("Examining " + (cutPoints.getInt(d + 1) - cutPoints.getInt(d)) + " nodes at distance " + d + " (at most " + globalProgressLogger.expectedUpdates + " visits to go)...");
                }
                for (int pos = cutPoints.getInt(d); pos < cutPoints.getInt(d + 1); ++pos) {
                    int x = queue.getInt(pos);
                    visit.clear();
                    visit.visit(x);
                    componentSize = FourSweepIterativeFringeDiameter.componentSize(visit, componentSize);
                    maxEcc = Math.max(maxEcc, visit.maxDistance());
                    lowerBound = Math.max(lowerBound, maxEcc);
                    if (lowerBound != upperBound) continue;
                    return lowerBound;
                }
                upperBound = Math.max(maxEcc, 2 * (d - 1));
                if (pl == null) continue;
                globalProgressLogger.updateAndDisplay((long)(cutPoints.getInt(d + 1) - cutPoints.getInt(d)));
                pl.logger().info("After enlarging fringe: [" + lowerBound + ".." + upperBound + "]");
            }
            if (globalProgressLogger == null) continue;
            globalProgressLogger.done();
        }
        return lowerBound;
    }

    public static void main(String[] arg) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, JSAPException, IOException, ClassNotFoundException, InstantiationException {
        ImmutableGraph graph;
        SimpleJSAP jsap = new SimpleJSAP(FourSweepIterativeFringeDiameter.class.getName(), "Computes the diamater of a symmetric graph using Magnien-Latay-Habib's technique.", new Parameter[]{new FlaggedOption("graphClass", (StringParser)GraphClassParser.getParser(), null, false, 'g', "graph-class", "Forces a Java class for the source graph."), new Switch("spec", 's', "spec", "The basename is rather a specification of the form <ImmutableGraphImplementation>(arg,arg,...)."), new Switch("mapped", 'm', "mapped", "Do not load the graph in main memory, but rather memory-map it."), new FlaggedOption("logInterval", (StringParser)JSAP.LONG_PARSER, Long.toString(10000L), false, 'l', "log-interval", "The minimum time interval between activity logs in milliseconds."), new FlaggedOption("threads", (StringParser)JSAP.INTSIZE_PARSER, "0", false, 'T', "threads", "The number of threads to be used. If 0, the number will be estimated automatically."), new UnflaggedOption("basename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The basename of the graph.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            System.exit(1);
        }
        ProgressLogger pl = new ProgressLogger(LOGGER, jsapResult.getLong("logInterval"), TimeUnit.MILLISECONDS);
        String basename = jsapResult.getString("basename");
        Class graphClass = jsapResult.getClass("graphClass");
        boolean spec = jsapResult.getBoolean("spec");
        boolean mapped = jsapResult.getBoolean("mapped");
        int threads = jsapResult.getInt("threads");
        if (graphClass != null) {
            if (spec) {
                System.err.println("Options --graph-class and --spec are incompatible");
                System.exit(1);
                return;
            }
            graph = (ImmutableGraph)graphClass.getMethod(mapped ? ImmutableGraph.LoadMethod.MAPPED.toMethod() : ImmutableGraph.LoadMethod.STANDARD.toMethod(), CharSequence.class).invoke(null, basename);
        } else {
            graph = !spec ? (mapped ? ImmutableGraph.loadMapped(basename, pl) : ImmutableGraph.load(basename, pl)) : (ImmutableGraph)ObjectParser.fromSpec((String)basename, ImmutableGraph.class, (String[])GraphClassParser.PACKAGE);
        }
        System.out.println(FourSweepIterativeFringeDiameter.run(graph, threads, new ProgressLogger(LOGGER), Util.randomSeed()));
    }
}

