/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.webgraph.algo;

import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.fastutil.longs.LongBigList;
import it.unimi.dsi.sux4j.bits.SimpleSelectZero;
import it.unimi.dsi.webgraph.ImmutableGraph;

public final class EliasFanoCumulativeOutdegreeList {
    private final int l;
    private final long roundingMask;
    private final long[] upperBits;
    private final LongBigList lowerBits;
    private final long numNodes;
    private long window;
    private int curr;
    private int currentIndex;
    private SimpleSelectZero simpleSelectZero;

    public EliasFanoCumulativeOutdegreeList(ImmutableGraph graph) {
        this(graph, graph.numArcs());
    }

    public EliasFanoCumulativeOutdegreeList(ImmutableGraph graph, long numArcs) {
        this(graph, numArcs, 0);
    }

    public EliasFanoCumulativeOutdegreeList(ImmutableGraph graph, long numArcs, int roundingMask) {
        if (roundingMask + 1 != Integer.highestOneBit(roundingMask + 1)) {
            throw new IllegalArgumentException("Illegal rounding mask: " + roundingMask);
        }
        this.roundingMask = roundingMask;
        long length = this.numNodes = (long)graph.numNodes();
        long upperBound = numArcs;
        this.l = Math.max(0, Fast.mostSignificantBit((long)(upperBound / length)));
        long lowerBitsMask = (1L << this.l) - 1L;
        LongBigList lowerBitsList = LongArrayBitVector.getInstance().asLongBigList(this.l);
        lowerBitsList.size(length);
        LongArrayBitVector upperBitsVector = LongArrayBitVector.getInstance().length(length + (upperBound >>> this.l) + 1L);
        long v = 0L;
        int i = 0;
        while ((long)i < length) {
            if ((v += (long)graph.outdegree(i)) > upperBound) {
                throw new IllegalArgumentException("Too large value: " + v + " > " + upperBound);
            }
            if (this.l != 0) {
                lowerBitsList.set((long)i, v & lowerBitsMask);
            }
            upperBitsVector.set((v >>> this.l) + (long)i);
            ++i;
        }
        this.lowerBits = lowerBitsList;
        this.upperBits = upperBitsVector.bits();
        this.simpleSelectZero = new SimpleSelectZero((BitVector)upperBitsVector);
        this.currentIndex = -1;
    }

    private long getNextUpperBits() {
        assert ((long)this.currentIndex < this.numNodes);
        while (this.window == 0L) {
            this.window = this.upperBits[++this.curr];
        }
        long upperBits = (long)this.curr * 64L + (long)Long.numberOfTrailingZeros(this.window) - (long)this.currentIndex++;
        this.window &= this.window - 1L;
        return upperBits;
    }

    public int currentIndex() {
        return this.currentIndex;
    }

    public long skipTo(long lowerBound) {
        long lower;
        long last;
        long zeroesToSkip = (lowerBound >>> this.l) - 1L;
        long position = zeroesToSkip == -1L ? 0L : this.simpleSelectZero.selectZero(zeroesToSkip);
        this.curr = (int)(position / 64L);
        this.window = this.upperBits[this.curr];
        this.window &= -1L << (int)(position % 64L);
        assert (zeroesToSkip == -1L || position - zeroesToSkip <= Integer.MAX_VALUE) : position - zeroesToSkip;
        this.currentIndex = (int)(zeroesToSkip == -1L ? 0L : position - zeroesToSkip);
        do {
            lower = this.lowerBits.getLong((long)this.currentIndex);
        } while (((last = this.getNextUpperBits() << this.l | lower) < lowerBound || ((long)this.currentIndex & this.roundingMask) != 0L) && (long)this.currentIndex != this.numNodes);
        return last;
    }
}

