/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.webgraph.algo;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterators;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.stat.Jackknife;
import it.unimi.dsi.webgraph.algo.NeighbourhoodFunction;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Arrays;

public class ApproximateNeighbourhoodFunctions {
    public static Jackknife.Statistic SPID = new Jackknife.Statistic(){

        public BigDecimal[] compute(BigDecimal[] sample, MathContext mc) {
            BigDecimal sumDistances = BigDecimal.ZERO;
            BigDecimal sumSquareDistances = BigDecimal.ZERO;
            int i = sample.length;
            while (i-- != 1) {
                BigDecimal delta = sample[i].subtract(sample[i - 1]);
                sumDistances = sumDistances.add(delta.multiply(BigDecimal.valueOf(i)));
                sumSquareDistances = sumSquareDistances.add(delta.multiply(BigDecimal.valueOf((long)i * (long)i)));
            }
            return new BigDecimal[]{sumSquareDistances.divide(sumDistances, mc).subtract(sumDistances.divide(sample[sample.length - 1], mc))};
        }
    };
    public static Jackknife.Statistic AVERAGE_DISTANCE = new Jackknife.Statistic(){

        public BigDecimal[] compute(BigDecimal[] sample, MathContext mc) {
            BigDecimal mean = BigDecimal.ZERO;
            int i = sample.length;
            while (i-- != 1) {
                mean = mean.add(sample[i].subtract(sample[i - 1]).multiply(BigDecimal.valueOf(i)));
            }
            return new BigDecimal[]{mean.divide(sample[sample.length - 1], mc)};
        }
    };
    public static Jackknife.Statistic HARMONIC_DIAMETER = new Jackknife.Statistic(){

        public BigDecimal[] compute(BigDecimal[] sample, MathContext mc) {
            BigDecimal sumInverseDistances = BigDecimal.ZERO;
            int i = sample.length;
            while (i-- != 1) {
                sumInverseDistances = sumInverseDistances.add(sample[i].subtract(sample[i - 1]).divide(BigDecimal.valueOf(i), mc));
            }
            return new BigDecimal[]{sample[0].multiply(sample[0]).divide(sumInverseDistances, mc)};
        }
    };
    public static Jackknife.Statistic EFFECTIVE_DIAMETER = new Jackknife.AbstractStatistic(){

        public double[] compute(double[] sample) {
            return new double[]{NeighbourhoodFunction.effectiveDiameter(sample)};
        }
    };
    public static Jackknife.Statistic CDF = new Jackknife.Statistic(){

        public BigDecimal[] compute(BigDecimal[] sample, MathContext mc) {
            BigDecimal[] result = new BigDecimal[sample.length];
            BigDecimal norm = BigDecimal.ONE.divide(sample[sample.length - 1], mc);
            int i = result.length;
            while (i-- != 0) {
                result[i] = sample[i].multiply(norm);
            }
            return result;
        }
    };
    public static Jackknife.Statistic PMF = new Jackknife.Statistic(){

        public BigDecimal[] compute(BigDecimal[] sample, MathContext mc) {
            BigDecimal[] result = new BigDecimal[sample.length];
            BigDecimal norm = BigDecimal.ONE.divide(sample[sample.length - 1], mc);
            result[0] = sample[0].multiply(norm);
            int i = result.length - 1;
            while (i-- != 0) {
                result[i + 1] = sample[i + 1].subtract(sample[i]).multiply(norm);
            }
            return result;
        }
    };

    private ApproximateNeighbourhoodFunctions() {
    }

    public static double[] combine(Iterable<double[]> anf) {
        Object[] t = ObjectIterators.unwrap(anf.iterator());
        double[][] a = (double[][])Arrays.copyOf(t, t.length, double[][].class);
        int n = a.length;
        int length = 0;
        for (double[] b : a) {
            length = Math.max(length, b.length);
        }
        double[] result = new double[length];
        BigDecimal last = BigDecimal.ZERO;
        for (int i = 0; i < length; ++i) {
            BigDecimal curr = BigDecimal.ZERO;
            for (int j = 0; j < n; ++j) {
                curr = curr.add(BigDecimal.valueOf(a[j][i < a[j].length ? i : a[j].length - 1]));
            }
            if (curr.compareTo(last) < 0) {
                curr = last;
            }
            result[i] = curr.doubleValue() / (double)n;
            last = curr;
        }
        return result;
    }

    public static ObjectList<double[]> evenOut(Iterable<double[]> anf) {
        Object[] u = ObjectIterators.unwrap(anf.iterator());
        double[][] t = (double[][])Arrays.copyOf(u, u.length, double[][].class);
        int n = t.length;
        int max = 0;
        for (double[] a : t) {
            max = Math.max(max, a.length);
        }
        ObjectArrayList result = new ObjectArrayList(n);
        for (int i = 0; i < n; ++i) {
            double[] a = new double[max];
            System.arraycopy(t[i], 0, a, 0, t[i].length);
            for (int j = t[i].length; j < max; ++j) {
                a[j] = a[j - 1];
            }
            result.add((Object)a);
        }
        return result;
    }
}

