/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.webgraph;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.io.TextIO;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.webgraph.GraphClassParser;
import it.unimi.dsi.webgraph.ImmutableGraph;
import it.unimi.dsi.webgraph.NodeIterator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;

public class Stats {
    private Stats() {
    }

    public static void run(ImmutableGraph graph, LongArrayBitVector buckets, int[] sccsize, CharSequence resultsBasename, ProgressLogger pl) throws IOException {
        Stats.run(graph, buckets, sccsize, resultsBasename, false, pl);
    }

    public static void run(ImmutableGraph graph, LongArrayBitVector buckets, int[] sccsize, CharSequence resultsBasename, boolean saveDegrees, ProgressLogger pl) throws IOException {
        int i;
        int d;
        NodeIterator nodeIterator = graph.nodeIterator();
        int[] count = IntArrays.EMPTY_ARRAY;
        int[] indegree = new int[graph.numNodes()];
        int maxd = 0;
        int maxNode = 0;
        int mind = Integer.MAX_VALUE;
        int minNode = 0;
        long dangling = 0L;
        long terminal = 0L;
        long loops = 0L;
        long numArcs = 0L;
        long numGaps = 0L;
        BigInteger totLoc = BigInteger.ZERO;
        BigInteger totGap = BigInteger.ZERO;
        if (pl != null) {
            pl.itemsName = "nodes";
            pl.expectedUpdates = graph.numNodes();
            pl.start((CharSequence)"Scanning...");
        }
        PrintWriter outdegreesPrintWriter = saveDegrees ? new PrintWriter(new BufferedWriter(new FileWriter(resultsBasename + ".outdegrees"))) : null;
        long[] successorDeltaStats = new long[32];
        int i2 = graph.numNodes();
        while (i2-- != 0) {
            int curr = nodeIterator.nextInt();
            d = nodeIterator.outdegree();
            if (saveDegrees) {
                outdegreesPrintWriter.println(d);
            }
            int[] successor = nodeIterator.successorArray();
            if (d > 1) {
                totGap = totGap.add(BigInteger.valueOf(successor[d - 1] - successor[0]));
                totGap = totGap.add(BigInteger.valueOf(Fast.int2nat((int)(successor[0] - curr))));
                numGaps += (long)d;
            }
            int s = d;
            while (s-- != 0) {
                totLoc = totLoc.add(BigInteger.valueOf(Math.abs(successor[s] - curr)));
                if (successor[s] != curr) {
                    int n = Fast.mostSignificantBit((int)Math.abs(curr - successor[s]));
                    successorDeltaStats[n] = successorDeltaStats[n] + 1L;
                } else {
                    ++loops;
                }
                int n = successor[s];
                indegree[n] = indegree[n] + 1;
            }
            if (d == 0) {
                ++dangling;
                ++terminal;
            }
            if (d == 1 && successor[0] == curr) {
                ++terminal;
            }
            if (d < mind) {
                mind = d;
                minNode = curr;
            }
            if (d > maxd) {
                maxd = d;
                maxNode = curr;
            }
            numArcs += (long)d;
            if (d >= count.length) {
                count = IntArrays.grow((int[])count, (int)(d + 1));
            }
            int n = d;
            count[n] = count[n] + 1;
            if (pl == null) continue;
            pl.lightUpdate();
        }
        if (pl != null) {
            pl.done();
        }
        if (saveDegrees) {
            outdegreesPrintWriter.close();
            TextIO.storeInts((int[])indegree, (CharSequence)(resultsBasename + ".indegrees"));
        }
        PrintWriter properties = new PrintWriter(new FileWriter(resultsBasename + ".stats"));
        properties.println("nodes=" + graph.numNodes());
        properties.println("arcs=" + numArcs);
        properties.println("loops=" + loops);
        properties.println("successoravggap=" + new BigDecimal(totGap).divide(BigDecimal.valueOf(Math.max(1L, numGaps)), 3, RoundingMode.HALF_EVEN));
        properties.println("avglocality=" + new BigDecimal(totLoc).divide(BigDecimal.valueOf(Math.max(1L, numArcs)), 3, RoundingMode.HALF_EVEN));
        properties.println("minoutdegree=" + mind);
        properties.println("maxoutdegree=" + maxd);
        properties.println("minoutdegreenode=" + minNode);
        properties.println("maxoutdegreenode=" + maxNode);
        properties.println("dangling=" + dangling);
        properties.println("terminal=" + terminal);
        properties.println("percdangling=" + 100.0 * (double)dangling / (double)graph.numNodes());
        properties.println("avgoutdegree=" + (double)numArcs / (double)graph.numNodes());
        int l = successorDeltaStats.length;
        while (l-- != 0 && successorDeltaStats[l] == 0L) {
        }
        StringBuilder s = new StringBuilder();
        double totLogDelta = 0.0;
        long numDelta = 0L;
        long g = 1L;
        for (i = 0; i <= l; ++i) {
            if (i != 0) {
                s.append(',');
            }
            s.append(successorDeltaStats[i]);
            numDelta += successorDeltaStats[i];
            totLogDelta += (Fast.log2((double)(g * 2L + g + 1L)) - 1.0) * (double)successorDeltaStats[i];
            g *= 2L;
        }
        properties.println("successorlogdeltastats=" + s.toString());
        properties.println("successoravglogdelta=" + (numDelta == 0L ? "0" : new BigDecimal(totLogDelta).divide(BigDecimal.valueOf(Math.max(1L, numDelta * 2L)), 3, RoundingMode.HALF_EVEN).toString()));
        TextIO.storeInts((int[])count, (int)0, (int)(maxd + 1), (CharSequence)(resultsBasename + ".outdegree"));
        IntArrays.fill((int[])count, (int)0);
        minNode = 0;
        maxNode = 0;
        maxd = 0;
        mind = Integer.MAX_VALUE;
        i = indegree.length;
        while (i-- != 0) {
            d = indegree[i];
            if (d >= count.length) {
                count = IntArrays.grow((int[])count, (int)(d + 1));
            }
            if (d < mind) {
                mind = d;
                minNode = i;
            }
            if (d > maxd) {
                maxd = d;
                maxNode = i;
            }
            int n = d;
            count[n] = count[n] + 1;
        }
        TextIO.storeInts((int[])count, (int)0, (int)(maxd + 1), (CharSequence)(resultsBasename + ".indegree"));
        properties.println("minindegree=" + mind);
        properties.println("maxindegree=" + maxd);
        properties.println("minindegreenode=" + minNode);
        properties.println("maxindegreenode=" + maxNode);
        properties.println("avgindegree=" + (double)numArcs / (double)graph.numNodes());
        if (buckets != null) {
            long numBuckets = buckets.count();
            properties.println("buckets=" + numBuckets);
            properties.println("percbuckets=" + 100.0 * (double)numBuckets / (double)graph.numNodes());
        }
        if (sccsize != null) {
            IntArrays.mergeSort((int[])sccsize);
            int m = sccsize.length;
            int maxSize = sccsize[m - 1];
            int minSize = sccsize[0];
            properties.println("sccs=" + m);
            properties.println("maxsccsize=" + maxSize);
            properties.println("percmaxscc=" + 100.0 * (double)maxSize / (double)graph.numNodes());
            properties.println("minsccsize=" + minSize);
            properties.println("percminscc=" + 100.0 * (double)minSize / (double)graph.numNodes());
            PrintWriter pw = new PrintWriter(resultsBasename + ".sccdistr");
            int current = maxSize;
            int c = 0;
            int i3 = sccsize.length;
            while (i3-- != 0) {
                if (sccsize[i3] != current) {
                    pw.println(current + "\t" + c);
                    current = sccsize[i3];
                    c = 0;
                }
                ++c;
            }
            pw.println(current + "\t" + c);
            pw.flush();
            pw.close();
        }
        properties.close();
    }

    public static void main(String[] arg) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, JSAPException, IOException, ClassNotFoundException {
        SimpleJSAP jsap = new SimpleJSAP(Stats.class.getName(), "Computes statistical data of a given graph.", new Parameter[]{new FlaggedOption("graphClass", (StringParser)GraphClassParser.getParser(), null, false, 'g', "graph-class", "Forces a Java class for the source graph."), new FlaggedOption("logInterval", (StringParser)JSAP.LONG_PARSER, Long.toString(10000L), false, 'l', "log-interval", "The minimum time interval between activity logs in milliseconds."), new Switch("saveDegrees", 's', "save-degrees", "Save indegrees and outdegrees in text format."), new UnflaggedOption("basename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The basename of the graph."), new UnflaggedOption("resultsBasename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, false, "The basename of the resulting files.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            System.exit(1);
        }
        Class graphClass = jsapResult.getClass("graphClass");
        String basename = jsapResult.getString("basename");
        String resultsBasename = jsapResult.userSpecified("resultsBasename") ? jsapResult.getString("resultsBasename") : basename;
        ProgressLogger pl = new ProgressLogger();
        pl.logInterval = jsapResult.getLong("logInterval");
        ImmutableGraph graph = graphClass != null ? (ImmutableGraph)graphClass.getMethod("loadOffline", CharSequence.class).invoke(null, basename) : ImmutableGraph.loadOffline(basename, pl);
        LongArrayBitVector buckets = (LongArrayBitVector)(new File(basename + ".buckets").exists() ? BinIO.loadObject((CharSequence)(basename + ".buckets")) : null);
        int[] sccsize = new File(basename + ".sccsizes").exists() ? BinIO.loadInts((CharSequence)(basename + ".sccsizes")) : null;
        Stats.run(graph, buckets, sccsize, resultsBasename, jsapResult.getBoolean("saveDegrees"), pl);
    }
}

