/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.webgraph;

import it.unimi.dsi.webgraph.ImmutableSequentialGraph;
import it.unimi.dsi.webgraph.NodeIterator;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;

public class IncrementalImmutableSequentialGraph
extends ImmutableSequentialGraph {
    public static int[] END_OF_GRAPH = new int[0];
    private int n = -1;
    private final ArrayBlockingQueue<int[]> successorQueue = new ArrayBlockingQueue(100);

    @Override
    public int numNodes() {
        if (this.n == -1) {
            throw new UnsupportedOperationException("The number of nodes is unknown (you need to complete a traversal)");
        }
        return this.n;
    }

    @Override
    public NodeIterator nodeIterator() {
        if (this.n != -1) {
            throw new IllegalStateException();
        }
        return new NodeIterator(){
            int i = 0;
            private int[] currentSuccessor;
            private int[] nextSuccessor;

            public boolean hasNext() {
                boolean end;
                if (this.nextSuccessor == END_OF_GRAPH) {
                    return false;
                }
                if (this.nextSuccessor != null) {
                    return true;
                }
                try {
                    this.nextSuccessor = (int[])IncrementalImmutableSequentialGraph.this.successorQueue.take();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                boolean bl = end = this.nextSuccessor == END_OF_GRAPH;
                if (end) {
                    IncrementalImmutableSequentialGraph.this.n = this.i;
                }
                return !end;
            }

            public int nextInt() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.currentSuccessor = this.nextSuccessor;
                this.nextSuccessor = null;
                return this.i++;
            }

            @Override
            public int outdegree() {
                if (this.currentSuccessor == null) {
                    throw new IllegalStateException();
                }
                return this.currentSuccessor.length;
            }

            @Override
            public int[] successorArray() {
                if (this.currentSuccessor == null) {
                    throw new IllegalStateException();
                }
                return this.currentSuccessor;
            }
        };
    }

    public void add(int[] successor, int offset, int length) throws InterruptedException {
        this.successorQueue.put(Arrays.copyOfRange(successor, offset, offset + length));
    }

    public void add(int[] successor) throws InterruptedException {
        this.successorQueue.put(successor);
    }
}

