/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.webgraph;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.webgraph.ImmutableGraph;
import it.unimi.dsi.webgraph.LazyIntIterator;
import it.unimi.dsi.webgraph.LazyIntIterators;
import it.unimi.dsi.webgraph.NodeIterator;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.NoSuchElementException;
import java.util.Properties;

public class ImmutableSubgraph
extends ImmutableGraph {
    private static final boolean ASSERTS = false;
    private static final boolean DEBUG = false;
    public static final String SUBGRAPHNODES_PROPERTY_KEY = "subgraphnodes";
    public static final String SUPERGRAPHBASENAME_PROPERTY_KEY = "supergraphbasename";
    protected final ImmutableGraph supergraph;
    protected final ImmutableSubgraph supergraphAsSubgraph;
    protected final int[] subgraphNode;
    protected final int[] supergraphNode;
    protected final int subgraphSize;
    protected final int supergraphNumNodes;
    protected CharSequence basename;
    private int cacheNode = -1;
    private int[] cacheSuccessors;

    private static final int[] set2sortedArray(IntSet subgraphNodes) {
        int[] a = subgraphNodes.toIntArray();
        IntArrays.radixSort((int[])a);
        return a;
    }

    public ImmutableSubgraph(ImmutableGraph supergraph, IntSet subgraphNodes) {
        this(supergraph, ImmutableSubgraph.set2sortedArray(subgraphNodes));
    }

    public ImmutableSubgraph(ImmutableGraph supergraph, int[] subgraphNode) {
        this.supergraph = supergraph;
        this.supergraphAsSubgraph = supergraph instanceof ImmutableSubgraph ? (ImmutableSubgraph)supergraph : null;
        this.subgraphNode = subgraphNode;
        this.subgraphSize = subgraphNode.length;
        this.supergraphNumNodes = supergraph.numNodes();
        this.supergraphNode = new int[this.supergraphNumNodes];
        IntArrays.fill((int[])this.supergraphNode, (int)-1);
        int i = this.subgraphSize;
        while (i-- != 0) {
            this.supergraphNode[subgraphNode[i]] = i;
        }
        for (i = 1; i < this.subgraphSize; ++i) {
            if (subgraphNode[i - 1] < subgraphNode[i]) continue;
            throw new IllegalArgumentException("The provided integer array is not strictly increasing: " + (i - 1) + "-th element is " + subgraphNode[i - 1] + ", " + i + "-th element is " + subgraphNode[i]);
        }
        if (this.subgraphSize > 0 && subgraphNode[this.subgraphSize - 1] >= this.supergraphNumNodes) {
            throw new IllegalArgumentException("Subnode index out of bounds: " + subgraphNode[this.subgraphSize - 1]);
        }
    }

    protected ImmutableSubgraph(ImmutableSubgraph immutableSubgraph) {
        this.supergraphNumNodes = immutableSubgraph.supergraphNumNodes;
        this.subgraphSize = immutableSubgraph.subgraphSize;
        this.supergraph = immutableSubgraph.supergraph.copy();
        this.supergraphAsSubgraph = this.supergraph instanceof ImmutableSubgraph ? (ImmutableSubgraph)this.supergraph : null;
        this.subgraphNode = immutableSubgraph.subgraphNode;
        this.supergraphNode = immutableSubgraph.supergraphNode;
    }

    protected ImmutableSubgraph(ImmutableGraph immutableGraph) {
        this.subgraphSize = this.supergraphNumNodes = immutableGraph.numNodes();
        this.supergraph = immutableGraph;
        this.supergraphAsSubgraph = null;
        this.supergraphNode = null;
        this.subgraphNode = null;
    }

    @Override
    public int numNodes() {
        return this.subgraphSize;
    }

    @Override
    public long numArcs() {
        throw new UnsupportedOperationException("Cannot determine the number of arcs in a subgraph");
    }

    @Override
    public boolean randomAccess() {
        return this.supergraph.randomAccess();
    }

    @Override
    public CharSequence basename() {
        if (this.basename == null) {
            throw new IllegalStateException("This immutable subgraph has no basename");
        }
        return this.basename;
    }

    public CharSequence rootBasename() {
        return this.supergraphAsSubgraph != null ? this.supergraphAsSubgraph.rootBasename() : this.supergraph.basename();
    }

    public int toSupergraphNode(int x) {
        if (x < 0 || x >= this.subgraphSize) {
            throw new IllegalArgumentException();
        }
        return this.subgraphNode[x];
    }

    public int fromSupergraphNode(int x) {
        return this.supergraphNode[x];
    }

    public int toRootNode(int x) {
        return this.supergraphAsSubgraph != null ? this.supergraphAsSubgraph.toRootNode(this.toSupergraphNode(x)) : this.toSupergraphNode(x);
    }

    public int fromRootNode(int x) {
        if (this.supergraphAsSubgraph == null) {
            return this.fromSupergraphNode(x);
        }
        int y = this.supergraphAsSubgraph.fromRootNode(x);
        if (y < 0) {
            return -1;
        }
        return this.fromSupergraphNode(y);
    }

    @Override
    public NodeIterator nodeIterator(final int from) {
        return this.supergraph.randomAccess() && this.subgraphSize < this.supergraphNumNodes / 8 ? super.nodeIterator(from) : new NodeIterator(){
            int node;
            int[] successorsCache;
            int outdegree;
            final NodeIterator supergraphNodeIterator;
            {
                this.node = from;
                this.successorsCache = IntArrays.EMPTY_ARRAY;
                this.outdegree = -1;
                this.supergraphNodeIterator = ImmutableSubgraph.this.supergraph.nodeIterator(ImmutableSubgraph.this.subgraphNode[from]);
            }

            public int nextInt() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.node != from) {
                    this.supergraphNodeIterator.skip(ImmutableSubgraph.this.subgraphNode[this.node] - ImmutableSubgraph.this.subgraphNode[this.node - 1]);
                } else {
                    this.supergraphNodeIterator.nextInt();
                }
                this.outdegree = -1;
                return this.node++;
            }

            public boolean hasNext() {
                return this.node < ImmutableSubgraph.this.subgraphSize;
            }

            private void unwrapSuccessors() {
                int done;
                int start = 0;
                LazyIntIterator i = ImmutableSubgraph.this.successors(this.node - 1, this.supergraphNodeIterator.successors());
                while ((done = LazyIntIterators.unwrap(i, this.successorsCache, start, this.successorsCache.length - start)) == this.successorsCache.length - start) {
                    start = this.successorsCache.length;
                    this.successorsCache = IntArrays.grow((int[])this.successorsCache, (int)(this.successorsCache.length + 1));
                }
                this.outdegree = start + done;
            }

            @Override
            public int[] successorArray() {
                if (this.node == from) {
                    throw new IllegalStateException();
                }
                if (this.outdegree == -1) {
                    this.unwrapSuccessors();
                }
                return this.successorsCache;
            }

            @Override
            public LazyIntIterator successors() {
                if (this.node == from) {
                    throw new IllegalStateException();
                }
                if (this.outdegree == -1) {
                    this.unwrapSuccessors();
                }
                return LazyIntIterators.wrap(this.successorsCache, this.outdegree);
            }

            @Override
            public int outdegree() {
                if (this.node == from) {
                    throw new IllegalStateException();
                }
                if (this.outdegree == -1) {
                    this.unwrapSuccessors();
                }
                return this.outdegree;
            }
        };
    }

    @Override
    public LazyIntIterator successors(int x) {
        return this.successors(x, this.supergraph.successors(this.toSupergraphNode(x)));
    }

    private LazyIntIterator successors(int x, final LazyIntIterator supergraphSuccessors) {
        if (x < 0 || x >= this.subgraphSize) {
            throw new IllegalArgumentException();
        }
        if (this.cacheNode == x) {
            return LazyIntIterators.wrap(this.cacheSuccessors);
        }
        return new LazyIntIterator(){

            @Override
            public int nextInt() {
                int x;
                while ((x = supergraphSuccessors.nextInt()) != -1) {
                    int result = ImmutableSubgraph.this.supergraphNode[x];
                    if (result < 0) continue;
                    return result;
                }
                return -1;
            }

            @Override
            public int skip(int n) {
                int i;
                for (i = 0; i < n && this.nextInt() != -1; ++i) {
                }
                return i;
            }
        };
    }

    @Override
    public int outdegree(int x) {
        return this.outdegree(x, this.supergraph.successors(this.toSupergraphNode(x)));
    }

    public int outdegree(int x, LazyIntIterator supergraphSuccessors) {
        if (x < 0 || x >= this.subgraphSize) {
            throw new IllegalArgumentException();
        }
        if (this.cacheNode == x) {
            return this.cacheSuccessors.length;
        }
        this.cacheSuccessors = LazyIntIterators.unwrap(this.successors(x, supergraphSuccessors));
        this.cacheNode = x;
        return this.cacheSuccessors.length;
    }

    @Override
    public ImmutableSubgraph copy() {
        return new ImmutableSubgraph(this);
    }

    public static ImmutableSubgraph asImmutableSubgraph(ImmutableGraph graph) {
        return new ImmutableGraphWrapper(graph);
    }

    public static ImmutableGraph loadSequential(CharSequence basename) throws IOException {
        return ImmutableSubgraph.load(ImmutableGraph.LoadMethod.STANDARD, basename);
    }

    public static ImmutableGraph loadSequential(CharSequence basename, ProgressLogger pl) throws IOException {
        return ImmutableSubgraph.load(ImmutableGraph.LoadMethod.STANDARD, basename, pl);
    }

    public static ImmutableGraph loadOffline(CharSequence basename) throws IOException {
        return ImmutableSubgraph.load(ImmutableGraph.LoadMethod.OFFLINE, basename);
    }

    public static ImmutableGraph loadOffline(CharSequence basename, ProgressLogger pl) throws IOException {
        return ImmutableSubgraph.load(ImmutableGraph.LoadMethod.OFFLINE, basename, pl);
    }

    public static ImmutableGraph load(CharSequence basename) throws IOException {
        return ImmutableSubgraph.load(ImmutableGraph.LoadMethod.STANDARD, basename);
    }

    public static ImmutableGraph load(CharSequence basename, ProgressLogger pl) throws IOException {
        return ImmutableSubgraph.load(ImmutableGraph.LoadMethod.STANDARD, basename, pl);
    }

    private static ImmutableGraph load(ImmutableGraph.LoadMethod method, CharSequence basename) throws IOException {
        return ImmutableSubgraph.load(method, basename, null);
    }

    protected static ImmutableGraph load(ImmutableGraph.LoadMethod method, CharSequence basename, ProgressLogger pl) throws IOException {
        String nodes;
        FileInputStream propertyFile = new FileInputStream(basename + ".properties");
        Properties properties = new Properties();
        properties.load(propertyFile);
        propertyFile.close();
        String graphClassName = properties.getProperty("graphclass");
        if (!graphClassName.equals(ImmutableSubgraph.class.getName())) {
            throw new IOException("This class (" + ImmutableSubgraph.class.getName() + ") cannot load a graph stored using " + graphClassName);
        }
        String supergraphBasename = properties.getProperty(SUPERGRAPHBASENAME_PROPERTY_KEY);
        if (supergraphBasename == null) {
            throw new IOException("This property file does not specify the required property supergraphbasename");
        }
        ImmutableGraph supergraph = ImmutableGraph.load(method, supergraphBasename, null, pl);
        if (pl != null) {
            pl.start((CharSequence)"Reading nodes...");
        }
        ImmutableSubgraph isg = new ImmutableSubgraph(supergraph, BinIO.loadInts((CharSequence)((nodes = properties.getProperty(SUBGRAPHNODES_PROPERTY_KEY)) != null ? nodes : basename + ".nodes")));
        if (pl != null) {
            pl.count = isg.numNodes();
            pl.done();
        }
        isg.basename = new MutableString(basename);
        return isg;
    }

    public static void store(ImmutableGraph graph, CharSequence basename, ProgressLogger pm) {
        throw new UnsupportedOperationException("You cannot store a generic immutable graph as a subgraph");
    }

    public static void store(ImmutableGraph graph, CharSequence basename) {
        ImmutableSubgraph.store(graph, basename, (ProgressLogger)null);
    }

    public void save(CharSequence basename, ProgressLogger pl) throws IOException {
        Properties properties = new Properties();
        properties.setProperty("graphclass", ImmutableSubgraph.class.getName());
        properties.setProperty(SUPERGRAPHBASENAME_PROPERTY_KEY, this.supergraph.basename().toString());
        FileOutputStream propertyFile = new FileOutputStream(basename + ".properties");
        properties.store(propertyFile, null);
        propertyFile.close();
        if (pl != null) {
            pl.start((CharSequence)"Saving nodes...");
        }
        BinIO.storeInts((int[])this.subgraphNode, (int)0, (int)this.subgraphNode.length, (CharSequence)(basename + ".nodes"));
        if (pl != null) {
            pl.count = this.subgraphNode.length;
            pl.done();
        }
    }

    public void save(CharSequence basename) throws IOException {
        this.save(basename, null);
    }

    public static void main(String[] args) throws IllegalArgumentException, SecurityException, JSAPException, UnsupportedEncodingException, FileNotFoundException {
        SimpleJSAP jsap = new SimpleJSAP(ImmutableSubgraph.class.getName(), "Writes the property file of an immutable subgraph.", new Parameter[]{new UnflaggedOption("supergraphBasename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The basename of the supergraph."), new FlaggedOption("subgraphNodes", (StringParser)JSAP.STRING_PARSER, null, false, 's', "subgraph-nodes", "Sets a subgraph node file (a list integers in DataInput format). If not specified, the name will be stemmed from the basename."), new UnflaggedOption("basename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The basename of resulting immutable subgraph.")});
        JSAPResult jsapResult = jsap.parse(args);
        if (jsap.messagePrinted()) {
            System.exit(1);
        }
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(jsapResult.getString("basename") + ".properties"), "UTF-8"));
        pw.println("graphclass = " + ImmutableSubgraph.class.getName());
        pw.println("supergraphbasename = " + jsapResult.getString("supergraphBasename"));
        if (jsapResult.userSpecified("subgraphNodes")) {
            pw.println("subgraphnodes = " + jsapResult.getString("subgraphNodes"));
        }
        pw.close();
    }

    private static class ImmutableGraphWrapper
    extends ImmutableSubgraph {
        public ImmutableGraphWrapper(ImmutableGraph graph) {
            super(graph);
            try {
                this.basename = graph.basename();
            }
            catch (UnsupportedOperationException e) {
                this.basename = null;
            }
        }

        @Override
        public NodeIterator nodeIterator() {
            return this.supergraph.nodeIterator();
        }

        @Override
        public NodeIterator nodeIterator(int from) {
            return this.supergraph.nodeIterator(from);
        }

        @Override
        public long numArcs() {
            return this.supergraph.numArcs();
        }

        @Override
        public int numNodes() {
            return this.supergraph.numNodes();
        }

        @Override
        public int outdegree(int x) {
            return this.supergraph.outdegree(x);
        }

        @Override
        public int[] successorArray(int x) {
            return this.supergraph.successorArray(x);
        }

        @Override
        public LazyIntIterator successors(int x) {
            return this.supergraph.successors(x);
        }

        @Override
        public int toSupergraphNode(int x) {
            return x;
        }

        @Override
        public int fromSupergraphNode(int x) {
            return x;
        }

        @Override
        public int toRootNode(int x) {
            return x;
        }

        @Override
        public int fromRootNode(int x) {
            return x;
        }
    }
}

