/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.webgraph;

import it.unimi.dsi.fastutil.ints.AbstractIntIterator;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.lang.FlyweightPrototype;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.webgraph.LazyIntIterator;
import it.unimi.dsi.webgraph.LazyIntIterators;
import it.unimi.dsi.webgraph.NodeIterator;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ImmutableGraph
implements FlyweightPrototype<ImmutableGraph> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImmutableGraph.class);
    public static final String GRAPHCLASS_PROPERTY_KEY = "graphclass";
    public static final String PROPERTIES_EXTENSION = ".properties";
    private static final ProgressLogger UNUSED = new ProgressLogger();

    public abstract int numNodes();

    public long numArcs() {
        throw new UnsupportedOperationException();
    }

    public abstract boolean randomAccess();

    public CharSequence basename() {
        throw new UnsupportedOperationException();
    }

    public LazyIntIterator successors(int x) {
        return LazyIntIterators.wrap(this.successorArray(x), this.outdegree(x));
    }

    public int[] successorArray(int x) {
        int[] successor = new int[this.outdegree(x)];
        LazyIntIterators.unwrap(this.successors(x), successor);
        return successor;
    }

    public abstract int outdegree(int var1);

    public NodeIterator nodeIterator(final int from) {
        return new NodeIterator(){
            int curr;
            final int n;
            {
                this.curr = from - 1;
                this.n = ImmutableGraph.this.numNodes();
            }

            public int nextInt() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return ++this.curr;
            }

            public boolean hasNext() {
                return this.curr < this.n - 1;
            }

            @Override
            public LazyIntIterator successors() {
                if (this.curr == from - 1) {
                    throw new IllegalStateException();
                }
                return ImmutableGraph.this.successors(this.curr);
            }

            @Override
            public int outdegree() {
                if (this.curr == from - 1) {
                    throw new IllegalStateException();
                }
                return ImmutableGraph.this.outdegree(this.curr);
            }
        };
    }

    public NodeIterator nodeIterator() {
        return this.nodeIterator(0);
    }

    public abstract ImmutableGraph copy();

    public String toString() {
        StringBuilder s = new StringBuilder();
        long numArcs = -1L;
        try {
            numArcs = this.numArcs();
        }
        catch (UnsupportedOperationException ignore) {
            // empty catch block
        }
        s.append("Nodes: " + this.numNodes() + "\nArcs: " + (numArcs == -1L ? "unknown" : Long.toString(numArcs)) + "\n");
        NodeIterator nodeIterator = this.nodeIterator();
        int i = this.numNodes();
        while (i-- != 0) {
            int curr = nodeIterator.nextInt();
            s.append("Successors of " + curr + " (degree " + nodeIterator.outdegree() + "):");
            LazyIntIterator successors = nodeIterator.successors();
            int d = nodeIterator.outdegree();
            while (d-- != 0) {
                s.append(" " + successors.nextInt());
            }
            s.append('\n');
        }
        return s.toString();
    }

    public IntIterator outdegrees() {
        return this.randomAccess() ? new AbstractIntIterator(){
            private final int n;
            private int next;
            {
                this.n = ImmutableGraph.this.numNodes();
                this.next = 0;
            }

            public boolean hasNext() {
                return this.next < this.n;
            }

            public int nextInt() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return ImmutableGraph.this.outdegree(this.next++);
            }
        } : new AbstractIntIterator(){
            private final NodeIterator nodeIterator;
            {
                this.nodeIterator = ImmutableGraph.this.nodeIterator();
            }

            public boolean hasNext() {
                return this.nodeIterator.hasNext();
            }

            public int nextInt() {
                this.nodeIterator.nextInt();
                return this.nodeIterator.outdegree();
            }
        };
    }

    public static ImmutableGraph loadSequential(CharSequence basename) throws IOException {
        return ImmutableGraph.load(LoadMethod.SEQUENTIAL, basename, null);
    }

    public static ImmutableGraph loadSequential(CharSequence basename, ProgressLogger pl) throws IOException {
        return ImmutableGraph.load(LoadMethod.SEQUENTIAL, basename, null, pl);
    }

    public static ImmutableGraph loadOffline(CharSequence basename) throws IOException {
        return ImmutableGraph.load(LoadMethod.OFFLINE, basename, null);
    }

    public static ImmutableGraph loadOffline(CharSequence basename, ProgressLogger pl) throws IOException {
        return ImmutableGraph.load(LoadMethod.OFFLINE, basename, null, pl);
    }

    public static ImmutableGraph loadMapped(CharSequence basename, ProgressLogger pl) throws IOException {
        return ImmutableGraph.load(LoadMethod.MAPPED, basename, null, pl);
    }

    public static ImmutableGraph loadMapped(CharSequence basename) throws IOException {
        return ImmutableGraph.load(LoadMethod.MAPPED, basename, null);
    }

    public static ImmutableGraph loadOnce(InputStream is) throws IOException {
        throw new UnsupportedOperationException("This class does not support read-once loading");
    }

    public static ImmutableGraph load(CharSequence basename) throws IOException {
        return ImmutableGraph.load(LoadMethod.STANDARD, basename, null);
    }

    public static ImmutableGraph load(CharSequence basename, ProgressLogger pl) throws IOException {
        return ImmutableGraph.load(LoadMethod.STANDARD, basename, null, pl);
    }

    private static ImmutableGraph load(LoadMethod method, CharSequence basename, InputStream is) throws IOException {
        return ImmutableGraph.load(method, basename, is, UNUSED);
    }

    protected static ImmutableGraph load(LoadMethod method, CharSequence basename, InputStream is, ProgressLogger pl) throws IOException {
        FileInputStream propertyFile = new FileInputStream(basename + PROPERTIES_EXTENSION);
        Properties properties = new Properties();
        properties.load(propertyFile);
        propertyFile.close();
        String graphClassName = properties.getProperty(GRAPHCLASS_PROPERTY_KEY);
        if (graphClassName == null) {
            throw new IOException("The property file for " + basename + " does not contain a graphclass property");
        }
        if (graphClassName.startsWith("class ")) {
            graphClassName = graphClassName.substring(6);
        }
        if (graphClassName.startsWith("it.unimi.dsi.big.webgraph")) {
            String standardGraphClassName = graphClassName.replace("it.unimi.dsi.big.webgraph", "it.unimi.dsi.webgraph");
            LOGGER.warn("Replacing class " + graphClassName + " with " + standardGraphClassName);
            graphClassName = standardGraphClassName;
        }
        ImmutableGraph graph = null;
        try {
            Class<?> graphClass = Class.forName(graphClassName);
            graph = method == LoadMethod.ONCE ? (ImmutableGraph)graphClass.getMethod(method.toMethod(), InputStream.class).invoke(null, is) : (pl == UNUSED ? (ImmutableGraph)graphClass.getMethod(method.toMethod(), CharSequence.class).invoke(null, basename) : (ImmutableGraph)graphClass.getMethod(method.toMethod(), CharSequence.class, ProgressLogger.class).invoke(null, basename, pl));
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return graph;
    }

    public static void store(Class<?> graphClass, ImmutableGraph graph, CharSequence basename, ProgressLogger pl) throws IOException {
        if (!ImmutableGraph.class.isAssignableFrom(graphClass)) {
            throw new ClassCastException(graphClass.getName() + " is not a subclass of ImmutableGraph");
        }
        try {
            if (pl == UNUSED) {
                graphClass.getMethod("store", ImmutableGraph.class, CharSequence.class).invoke(null, graph, basename);
            } else {
                graphClass.getMethod("store", ImmutableGraph.class, CharSequence.class, ProgressLogger.class).invoke(null, graph, basename, pl);
            }
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void store(Class<?> graphClass, ImmutableGraph graph, CharSequence basename) throws IOException {
        ImmutableGraph.store(graphClass, graph, basename, UNUSED);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ImmutableGraph)) {
            return false;
        }
        ImmutableGraph g = (ImmutableGraph)o;
        int n = this.numNodes();
        if (n != g.numNodes()) {
            return false;
        }
        NodeIterator i = this.nodeIterator();
        NodeIterator j = g.nodeIterator();
        while (n-- != 0) {
            i.nextInt();
            j.nextInt();
            int d = i.outdegree();
            if (d != j.outdegree()) {
                return false;
            }
            int[] s = i.successorArray();
            int[] t = j.successorArray();
            while (d-- != 0) {
                if (s[d] == t[d]) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int n = this.numNodes();
        int h = -1;
        NodeIterator i = this.nodeIterator();
        while (n-- != 0) {
            h = h * 31 + i.nextInt();
            int[] s = i.successorArray();
            int d = i.outdegree();
            while (d-- != 0) {
                h = h * 31 + s[d];
            }
        }
        return h;
    }

    public static enum LoadMethod {
        STANDARD,
        SEQUENTIAL,
        OFFLINE,
        ONCE,
        MAPPED;


        public String toMethod() {
            switch (this) {
                case STANDARD: {
                    return "load";
                }
                case SEQUENTIAL: {
                    return "loadSequential";
                }
                case OFFLINE: {
                    return "loadOffline";
                }
                case ONCE: {
                    return "loadOnce";
                }
                case MAPPED: {
                    return "loadMapped";
                }
            }
            throw new AssertionError();
        }
    }
}

