/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.webgraph;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.webgraph.ImmutableGraph;
import it.unimi.dsi.webgraph.ImmutableSubgraph;
import it.unimi.dsi.webgraph.NodeIterator;
import java.io.IOException;

public class DegreeRangeImmutableSubgraph
extends ImmutableSubgraph {
    protected static int[] createMap(ImmutableGraph graph, int minDegree, int maxDegree) {
        IntArrayList map = new IntArrayList();
        int n = graph.numNodes();
        NodeIterator nodeIterator = graph.nodeIterator();
        for (int i = 0; i < n; ++i) {
            nodeIterator.nextInt();
            int d = nodeIterator.outdegree();
            if (d < minDegree || d >= maxDegree) continue;
            map.add(i);
        }
        return map.toIntArray();
    }

    public DegreeRangeImmutableSubgraph(ImmutableGraph graph, int minDegree, int maxDegree) {
        super(graph, DegreeRangeImmutableSubgraph.createMap(graph, minDegree, maxDegree));
    }

    public DegreeRangeImmutableSubgraph(String graph, String minDegree, String maxDegree) throws IOException {
        this(graph, minDegree, maxDegree, "false");
    }

    public DegreeRangeImmutableSubgraph(String graph, String minDegree, String maxDegree, String mapped) throws IOException {
        this(Boolean.parseBoolean(mapped) ? ImmutableGraph.loadMapped(graph) : ImmutableGraph.load(graph), Integer.parseInt(minDegree), Integer.parseInt(maxDegree));
    }
}

